import re

def is_valid_dot_name(dot_name):
    regex = re.compile('^(\w+)(:(\w+))*$')
    return regex.match(dot_name) is not None

def get_n_admin_levels(dot_name):
    return len(_split_admin_levels(dot_name))

def get_admin_levels(dot_name):
    return dict(zip(range(get_n_admin_levels(dot_name)), _split_admin_levels(dot_name)))

def get_admin_level(dot_name, level):
    return get_admin_levels(dot_name)[level]

def _split_admin_levels(dot_name):
    return dot_name.split(':')
