# -*- coding: utf-8 -*-
"""
Created on Mon Mar 18 16:37:31 2019

@author: dharding
"""

from collections import defaultdict

from dselib.dse_tools import TileNodeMap

class Weather:
    """
    Base class for weather outputs
    Represents weather information: nodes, node-tile map and tile weather time series for DTK weather variables.
    inherited by DTKWeather and CSVWeather
    """
    def __init__(self, nodes, resolution, start_date, end_date, weather_series_map=None, variables=None, tile_node_map=None):
        # Required arguments
        self.nodes = nodes
        self.resolution = resolution
        self.start_date = start_date
        self.end_date = end_date

        # Per scenario arguments

        # Save scenario:
        # Dictionary, tile_id->[node_ids]
        if tile_node_map is None:
            self.tile_node_map = TileNodeMap(resolution, nodes)
        else:
            self.tile_node_map = tile_node_map
        # Dictionary of dictionaries: variable->tile_id->[weather series values]
        self.weather_series_map = weather_series_map

        # Load scenario:
        # If weather_series_map dictionary is not provided it is generated from the list of DTK weather variables.
        if variables is not None and weather_series_map is None:
            # Lists are populated during loading of data.
            self.weather_series_map = {variable: defaultdict(list) for variable in variables}
