
import unittest
import sys
import os
from pathlib import Path
import datetime

#from dseCommon_common import norm_join, IsNullOrEmpty, parse_date
from dselib.dse_tools import dseCommon

RUN_ALL = os.environ.get('RUN_ALL', False)

date_array = [
    '2017',
    '2017045',
    '20170214',
    '2018-06-29',
    '2018-06-29 08:15:27.243860',
    'Jun 28 2018  7:40AM',
    'Jun 28 2018 at 7:40AM',
    'September 18, 2017, 22:19:55',
    'Sun, 05/12/1999, 12:30PM',
    'Mon, 21 March, 2015',
    '2018-03-12T10:12:45Z',
    '2018-06-29 17:08:00.586525+00:00',
    '2018-06-29 17:08:00.586525+05:00',
    'Tuesday , 6th September, 2017 at 4:30pm'
]

date_target_array = [
    '2017-01-01 00:00:00',
    '2017-02-14 00:00:00',
    '2017-02-14 00:00:00',
    '2018-06-29 00:00:00',
    '2018-06-29 08:15:27.243860',
    '2018-06-28 07:40:00',
    '2018-06-28 07:40:00',
    '2017-09-18 22:19:55',
    '1999-05-12 12:30:00',
    '2015-03-21 00:00:00',
    '2018-03-12 10:12:45+00:00',
    '2018-06-29 17:08:00.586525+00:00',
    '2018-06-29 17:08:00.586525+05:00',
    '2017-09-06 16:30:00'
    ]

class TestdseCommon_Common(unittest.TestCase):
    def testNormJoin_1(self):
        base_dir = 'a/b/c'
        file = 'test_file.x'
        target = 'a/b/c/test_file.x'
        if sys.platform == 'win32':
            target = 'a\\b\\c\\test_file.x'
        result = dseCommon.norm_join(base_dir,file)
        self.assertEqual(result, target)

    def testNormJoin_2(self):
        base_dir = 'a'
        file = 'test_file.x'
        target = 'a/test_file.x'
        if sys.platform == 'win32':
            target = 'a\\test_file.x'
        result = dseCommon.norm_join(base_dir,file)
        self.assertEqual(result, target)

    def testNormJoin_3(self):
        base_dir = 'system:/a'
        file = 'test_file.x'
        target = 'system:/a/test_file.x'
        if sys.platform == 'win32':
            target = 'system:\\a\\test_file.x'
        result = dseCommon.norm_join(base_dir,file)
        self.assertEqual(result, target)

    def testIsNullOrEmpty_1(self):
        s =None
        result = dseCommon.IsNullOrEmpty(s)
        self.assertTrue(result)

    def testIsNullOrEmpty_2(self):
        s =""
        result = dseCommon.IsNullOrEmpty(s)
        self.assertTrue(result)

    def testIsNullOrEmpty_3(self):
        s ="test string"
        result = dseCommon.IsNullOrEmpty(s)
        self.assertFalse(result)

    def testParse_date(self):
        for i in range(len(date_array)):
            date_object = dseCommon.parse_date(date_array[i])
            self.assertEqual(date_target_array[i], str(date_object))

    def testParse_date_2(self):
        date_object = dseCommon.parse_date('2017', 7, 4)
        target = '2017-07-04 00:00:00'
        self.assertEqual(target, str(date_object))


if __name__ == '__main__':
    unittest.main()

