import unittest
import sys
import os
from pathlib import Path
import datetime
import numpy as np

from dselib.dse_tools import humidityType,HumidityCalculator,CalculateHumidityARM,CalculateHumidityViasala

# note CalculateHumidityViasala is tested in functional test
RUN_ALL = os.environ.get('RUN_ALL', False)

class TestCalc_Helper(unittest.TestCase):
    def testHumidityType(self):
        # test humidity type class
        htype = humidityType.from_string('arm')
        self.assertEqual(htype, humidityType.arm)
        htype = humidityType.from_string('viasala')
        self.assertEqual(htype, humidityType.viasala)

    def testHumidityCalculator_factory(self):
        calc = HumidityCalculator.humidity_factory(humidityType.arm)
        self.assertEqual(type(calc),type(CalculateHumidityARM()))
        calc = HumidityCalculator.humidity_factory(humidityType.viasala)
        self.assertEqual(type(calc),type(CalculateHumidityViasala()))

    def testARM(self):
        T = np.array([[25,45],[25,0]])
        TD = np.array([[20,20],[25,-5]])
        target_RH = np.array([[0.738, 0.2433],[1.0,0.6906]])
        calc = HumidityCalculator.humidity_factory(humidityType.arm)
        result_RH = np.around(calc.calculate_humidity(T, TD), 4)
        self.assertTrue(np.array_equal(result_RH, target_RH))

    def testViasala(self):
        T = np.array([[25,45],[25,0]])
        TD = np.array([[20,20],[25,-5]])
        target_RH = np.array([[0.7381, 0.2436],[1.0,0.6902]])
        calc = HumidityCalculator.humidity_factory(humidityType.viasala)
        result_RH = np.around(calc.calculate_humidity(T, TD), 4)
        self.assertTrue(np.array_equal(result_RH, target_RH))


if __name__ == '__main__':
    unittest.main()
