
import unittest
import sys
import os
from pathlib import Path
import datetime
import numpy as np
from netCDF4 import Dataset, date2num, num2date

from dselib.dse_tools import NetCDFHelper

RUN_ALL = os.environ.get('RUN_ALL', False)

TESTFILE = os.path.abspath(os.path.join(os.path.dirname(__file__),"testdata","netcdf-data/sresa1b_ncar_ccsm3-example.nc"))

class TestCalc_Helper(unittest.TestCase):
    def testGetDimensions(self):
        target = ['lat', 'lon', 'bnds', 'plev','time']
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            dimensions = NetCDFHelper.get_dimensions(dataset)
            dataset.close()
            self.assertEqual(dimensions, target)
        else:
            self.assertTrue(False)

    def testGetVsariables(self):
        target = ['area', 'lat', 'lat_bnds', 'lon', 'lon_bnds', 'msk_rgn', 'plev', 'pr', 'tas', 'time', 'time_bnds', 'ua']
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            variables = NetCDFHelper.get_variables(dataset)
            dataset.close()
            self.assertEqual(variables, target)
        else:
            self.assertTrue(False)

    def testGetParameters(self):
        target = ['area', 'lat_bnds', 'lon_bnds', 'msk_rgn', 'pr', 'tas', 'time_bnds', 'ua']
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            parameters = NetCDFHelper.get_parameters(dataset)
            dataset.close()
            self.assertEqual(parameters, target)
        else:
            self.assertTrue(False)

    def testGetDimensionOrderForParameter(self):
        target = ['time', 'lat', 'lon']
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            dimensions = NetCDFHelper.get_dimension_order_for_parameters(dataset, 'pr')
            dataset.close()
            self.assertEqual(dimensions, target)
        else:
            self.assertTrue(False)

    def testGetParamNoDataValue(self):
        target_NDV = (1e+20)
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            NDV = NetCDFHelper.get_param_nodata_value(dataset, 'pr')
            self.assertEqual(NDV, target_NDV )
        else:
            self.assertTrue(False)

    def testGetVariable(self):
        target_dim = ('time', 'lat', 'lon')
        dataset = Dataset(TESTFILE, 'r')
        if dataset:
            attributes, values, dtype, dimensions = NetCDFHelper.get_variable(dataset, 'pr')
            dataset.close()
            self.assertEqual(dtype, 'float32')
            self.assertEqual(dimensions, target_dim)
            self.assertEqual(len(attributes), 11)
            self.assertEqual(values.size,32768)
        else:
            self.assertTrue(False)


if __name__ == '__main__':
    unittest.main()
