import os
import sys
import subprocess

from setuptools import setup, find_packages
from setuptools.command.install import install

dirpath = os.getcwd()
foldername = os.path.basename(dirpath)

#required_list = [line.rstrip('\n') for line in open('requirements_list.txt')]
required_list = [line.rstrip('\n') for line in open('requirements.txt')]
depend_list = [line.rstrip('\n') for line in open('dependency_links.txt')]


class CustomInstallCommand(install):
    """Customized setuptools install command - prints a friendly greeting."""
    def run(self):
        print ("Hello, installing dselib:")
        if sys.platform.startswith('win'):
          completed = subprocess.call(['python','-m', 'pip', 'install', '--upgrade', 'pip'])
          completed = subprocess.call(['python', 'req_setup_win.py'])
        elif sys.platform.startswith('linux'):
          # check for gdal and install requirements
          # we do this by running gdalinfo to get version. If gdalinfo does not exist,
          # an exception is thrown
          try:
            completed = subprocess.call(['gdalinfo', '--version'])
          except Exception as e:
            print("GDAL is not installed. Please install GDAL before installing dselib.")
            sys.exit(1)
          completed = subprocess.call(['python3','-m', 'pip', 'install', '--upgrade', 'pip'])
          completed = subprocess.call(['pip3', 'install', '-r', 'requirements.txt'])
        else:
          print("{} is not support by dselib".format(sys.platform))
          sys.exit(1)

        install.run(self)


setup(name='dselib',
      version='0.2.0',
      author='Dennis Harding',
      author_email='dharding@idmod.org',
      description='Data Services Library Tools',
      long_description=open('README.md', 'r', encoding='utf8').read(),
      long_description_content_type="text/markdown",
      url='https://github.com/InstituteforDiseaseModeling/dse-utility-library.git', #project page
      packages=find_packages(exclude=['test','examples']),
      project_urls={
        "Bug Tacker": "https://github.com/InstituteforDiseaseModeling/dse-utility-library/issues",
        "Documentation": "https://github.com/InstituteforDiseaseModeling/dse-utility-library",
        "Source Code": "https://github.com/InstituteforDiseaseModeling/dse-utility-library"
      },
      license=open('LICENSE','r', encoding='utf8' ).read(),
      keywords='gdal raster, shapes, dtk',
      install_requires=required_list,
      dependency_links=depend_list if sys.platform.startswith('Win') else [] ,

      classifiers=[
           "Programming Language :: Python :: 3",
           "Operating System :: OS Independent"
      ],
      cmdclass={
          'install': CustomInstallCommand,
      },
      test_suite='nose.collector',
      tests_require=['nose'],
      include_package_data=True,
      zip_safe=False)
