#!/usr/bin/env python3
import os
import sys
import shutil
from glob import glob


def setup(local_dir="./../sif"):
    """
        Copy singularity definition files from idm_test package into a local directory.
    """
    if not os.path.exists(local_dir):
        os.mkdir(local_dir)
    package_dir = sys.modules['idm_test'].__path__[0]

    for file_path in glob(os.path.join(package_dir, 'dtk_test/integration/sif', "*.def")):
        print(f"copying {file_path} to {local_dir}")
        shutil.copy(file_path, local_dir)


if __name__ == "__main__":
    setup()
