import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

requirements = ['matplotlib', 'pandas', 'seaborn']

setuptools.setup(
    name="idm_test",
    version="0.0.11",
    author="Ye Chen",
    author_email="yechen@idmod.org",
    description="idm_test package",
    install_requires=requirements,
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/InstituteforDiseaseModeling/idm_test",
    project_urls={
        "Bug Tracker": "https://github.com/InstituteforDiseaseModeling/idm_test/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
        'Framework:: IDM-Test :: Test'
    ],
    package_data={'': ['*.def']},
    include_package_data=True,
    package_dir={},
    packages=setuptools.find_packages(),
    python_requires=">=3.6",
)