import unittest


class IDMTestImportTest(unittest.TestCase):
    def setUp(self) -> None:
        self.expected_items = None
        self.found_items = None
        pass

    def verify_expected_items_present(self, namespace):
        self.found_items = dir(namespace)
        for item in self.expected_items:
            self.assertIn(
                item,
                self.found_items
            )

    def tearDown(self) -> None:
        pass

    def test_plot_import(self):
        self.expected_items = [
            'check_for_plotting',
            'plot_poisson_probability',
            'plot_dataframe_line',
            'plot_probability',
            'plot_hist_df',
            'plot_hist',
            'calc_cdf',
            'plot_cdf',
            'plot_data_3series',
            'plot_data_unsorted',
            'plot_data_sorted',
            'plot_scatter_fit_line',
            'plot_data',
            'plot_pie',
            'plot_scatter_with_fit_lines',
            'plot_bar_graph',
            'autolabel',
            'plot_cdf_w_fun',
            'calculate_cdf',
            'get_cmap',
            'three_plots',
            'plot_histogram'
        ]
        import idm_test.plot as plot
        self.verify_expected_items_present(namespace=plot)
        pass

    def test_stats_import(self):
        self.expected_items = [
            'test_binomial_95ci',
            'test_binomial_99ci',
            'calc_poisson_binomial',
            'calc_ks_critical_value',
            'get_p_s_from_ksresult',
            'create_geometric_dist',
            'test_geometric_decay',
            'convert_remains_to_binomial_chain',
            'convert_binomial_chain_to_geometric',
            'test_geometric',
            'test_poisson',
            'test_lognorm',
            'test_uniform',
            'test_gaussian',
            'round_down',
            'round_up',
            'test_exponential',
            'test_bimodal',
            'test_weibull',
            'test_multinomial',
            'test_gamma',
            'is_stats_test_pass',
            'round_to_1_digit',
            'round_to_n_digit',
            'convert_barchart_to_interpolation',
            'cal_tolerance_poisson',
            'cal_tolerance_binomial',
            'test_eGaussNonNeg',
            'test_dual_exponential',
            'mean_f',
            'variance_f'
        ]
        import idm_test.stats_test as stats_test
        self.verify_expected_items_present(namespace=stats_test)
        pass

    def test_sft_import(self):
        self.expected_items = [
            'start_report_file',
            'format_success_msg',
            'add_time_stamp',
            'get_val',
            'wait_for_done',
            'md5_hash',
            'md5_hash_of_file',
            'has_match',
            'get_char',
            'get_config_parameter',
            'get_config_name',
            'get_simulation_duration',
            'get_simulation_timestep'
        ]
        import idm_test.dtk_test.sft as sft
        self.verify_expected_items_present(namespace=sft)
        pass

    def test_general_support_import(self):
        self.expected_items = [
            'load_config_parameters',
            'parse_inset_chart',
            'CampaignKeys',
            'ConfigKeys',
            'DemographicsKeys',
            'InsetKeys'
        ]
        import idm_test.dtk_test.general_support as general_support
        self.verify_expected_items_present(namespace=general_support)
        pass

    def test_inset_chart_import(self):
        self.expected_items = [
            'InsetChart'
        ]
        import idm_test.dtk_test.inset_chart as inset_chart
        self.verify_expected_items_present(namespace=inset_chart)
        pass

    def test_output_file_import(self):
        self.expected_items = [
            'OutputFile',
            'TextFile',
            'JsonOutput',
            'CsvOutput',
            'ReportEventRecorder',
            'LineListReport'
        ]
        import idm_test.dtk_test.output_file as output_file
        self.verify_expected_items_present(namespace=output_file)
        pass

    def test_sft_class_import(self):
        self.expected_items = [
            'SFT'
        ]
        import idm_test.dtk_test.sft_class as sft_class
        self.verify_expected_items_present(namespace=sft_class)
        pass

    def test_std_out_import(self):
        self.expected_items = [
            'SearchType',
            'StdOut'
        ]
        import idm_test.dtk_test.std_out as std_out
        self.verify_expected_items_present(namespace=std_out)
        pass

    def test_dtk_HINT_Support_import(self):
        self.expected_items = [
            'Stdout',
            'load_config_parameters',
            'load_campaign_file',
            'load_demo_overlay_file',
            'load_demo_mr_overlay_file',
            'parse_stdout_file',
            'parse_property_report_json',
            'build_values_from_property_values',
            'build_channel_string_for_property',
            'test_new_infections',
            'compare_new_infections_channels',
            'compare_contagion_channels',
            'RunTest'
        ]
        import idm_test.dtk_test.dtk_HINT_Support as dtk_HINT_Support
        self.verify_expected_items_present(namespace=dtk_HINT_Support)
        pass

    def test_dtk_Individual_Property_Support_import(self):
        self.expected_items = [
            'CampaignKeys',
            'ConfigKeys',
            'DemographicsKeys',
            'JsonReport',
            'load_config_file',
            'load_campaign_file',
            'channels_from_jsonreport',
            'dataframe_from_channeldict',
            'dataframe_join_on_day',
            'get_properties_from_demographics',
            'get_property_channels',
            'build_strings_for_all_properties',
            'build_strings_for_property',
            'build_channel_matrix_for_properties',
            'build_channel_matrix_from_scratch',
            'verify_channel_sum',
            'verify_channel_split'
        ]
        import idm_test.dtk_test.dtk_Individual_Property_Support as dtk_Individual_Property_Support
        self.verify_expected_items_present(namespace=dtk_Individual_Property_Support)
        pass

    def test_dtk_Generic_InfectionRate_Basic_Calculation_Support_import(self):
        self.expected_items = [
            'Config',
            'Stdout',
            'InsetChart',
            'Campaign',
            'load_emod_parameters',
            'load_campaign_file',
            'parse_stdout_file',
            'parse_insetchart_json',
            'create_report_file'
        ]
        import \
            idm_test.dtk_test.dtk_Generic_InfectionRate_Basic_Calculation_Support as dtk_Generic_InfectionRate_Basic_Calculation_Support
        self.verify_expected_items_present(namespace=dtk_Generic_InfectionRate_Basic_Calculation_Support)
        pass

    def test_dtk_Generic_InfectionRate_Mod_Additive_Multiplicative_Support_import(self):
        self.expected_items = [
            'CampaignKeys',
            'ConfigKeys',
            'Constants',
            'DemographicsKeys',
            'NATURAL_LOG_OF_2',
            'Stdout',
            'get_val',
            'has_match',
            'load_campaign_file',
            'load_demo_file',
            'matches',
            'parse_stdout_file'
        ]

        import \
            idm_test.dtk_test.dtk_Generic_InfectionRate_Mod_Additive_Multiplicative_Support as \
                dtk_Generic_InfectionRate_Mod_Additive_Multiplicative_Support
        self.verify_expected_items_present(namespace=dtk_Generic_InfectionRate_Mod_Additive_Multiplicative_Support)
        pass


if __name__ == '__main__':
    unittest.main()
