import os

from idmtools_platform_comps.utils.singularity_build import SingularityBuildWorkItem
from idmtools_platform_comps.utils.assetize_output.assetize_output import AssetizeOutput

from idmtools.entities.experiment import Experiment
from idmtools.entities.command_task import CommandTask


def build_eradication_singularity(platform, manifest, force_build_exe, python=39):
    ac_obj = _build_singularity(platform=platform,
                                singularity_definition=manifest.build_sif,
                                sif_id_file=manifest.build_id,
                                image_name='Linux_build_exe.sif',
                                force=force_build_exe)

    _create_eradication_asset_collection(platform, ac_obj, manifest, python)


def _create_eradication_asset_collection(platform, ac_obj, manifest, python):
    cmd_line = 'singularity exec Assets/Linux_build_exe.sif cp -r /outputs/. .'

    # Create CommandTask
    task_obj = CommandTask(command=cmd_line)
    task_obj.common_assets.add_assets(ac_obj)

    # Wait until asset collection has been built
    ao_obj = AssetizeOutput(no_simulation_prefix=True)
    ao_obj.from_items(Experiment.from_task(task_obj))
    ao_obj.run(wait_until_done=True, platform=platform)
    if ao_obj.succeeded:
        # Write ID
        if python == 39:
            ao_obj.asset_collection.to_id_file(manifest.eradication_ac)
        elif python == 38:
            ao_obj.asset_collection.to_id_file(manifest.eradication_ac_38)


def build_sft_singularity(platform, manifest):
    _build_singularity(platform=platform,
                       singularity_definition=manifest.sft_sif,
                       sif_id_file=manifest.sft_id,
                       image_name='Linux_sft.sif')


def _build_singularity(platform, singularity_definition, sif_id_file, image_name="Linux.sif", force=False):
    sbwi = SingularityBuildWorkItem(
        name=f"Creating Linux sif with def file: {os.path.basename(singularity_definition)}",
        definition_file=singularity_definition,
        image_name=image_name,
        force=force)
    sbwi.tags = dict(os="Linux")
    ac_obj = sbwi.run(wait_until_done=True, platform=platform)
    if sbwi.succeeded:
        # Write ID
        ac_obj.to_id_file(sif_id_file)
    return ac_obj
