import os

from idmtools.assets import AssetCollection
from emodpy.bamboo import get_model_files
from idm_test.dtk_test.integration.create_singularity import build_eradication_singularity


def download_model_files(platform, manifest, force_build_exe):
    """
    A template solution to build the latest Eradication and other model files from Generic-Ongoing branch and download
    them for SFT.
    We will need to update this function to what ever solution we decided on pypi and Jenkins projects.
    Args:
        platform:
        manifest:
        force_build_exe:

    Returns:

    """
    if os.path.isfile(manifest.eradication_ac):
        print("try to download model files in Comps.")
        _get_model_files_from_comps(manifest)
    else:
        print(f"{manifest.eradication_ac} doesn't exist yet, will try to build model files in Comps with "
              f"{manifest.build_sif}.")
        print(os.getcwd())
        if os.path.isfile(manifest.build_sif):
            build_eradication_singularity(platform, manifest, force_build_exe)
            assert os.path.isfile(manifest.eradication_ac)
            print(f"{manifest.eradication_ac} does exist now, try to download model files in Comps.")
            _get_model_files_from_comps(manifest)
        else:
            print(f"{manifest.build_sif} doesn't exist, will try to download from bamboo.")
            # there is no test-sugar enabled plan in EradicationBambooBuilds, workaround for now
            from enum import Enum
            class EradicationBambooBuilds(Enum):
                GENERIC_LINUXSFT = 'DTKGENCI-SCONSRELLNXSFT'

            plan = EradicationBambooBuilds.GENERIC_LINUXSFT
            get_model_files(plan, manifest)


def _get_model_files_from_comps(manifest):
    if os.path.isfile(manifest.eradication_ac):
        ac = AssetCollection.from_id_file(manifest.eradication_ac)
        if not os.path.isdir(manifest.input_folder):
            os.makedirs(manifest.input_folder)
        for asset in ac.assets:
            asset.download_to_path(manifest.input_folder)
    else:
        raise ValueError(f"Can't find {manifest.eradication_ac}.")
