import os
import unittest

from idmtools.core.platform_factory import Platform

from idm_test.dtk_test.integration import manifest
from idm_test.dtk_test.integration.create_singularity import build_sft_singularity, build_eradication_singularity


class TestBuildSingularity38(unittest.TestCase):
    @classmethod
    def setUpClass(cls) -> None:
        cls.platform = Platform(manifest.platform)

    def setUp(self) -> None:
        self.case_name = os.path.basename(__file__) + "--" + self._testMethodName

    def test_build_CentOS_8_Py38_SFT(self):
        my_manifest = manifest
        my_manifest.build_sif = os.path.join(my_manifest.SIF_DIR, "CentOS_8_Py38_SFT.def")
        my_manifest.sft_id = os.path.join(my_manifest.SIF_DIR, "CentOS_8_Py38_SFT.id")
        build_sft_singularity(self.platform, my_manifest)

    def test_build_CentOS_8_Py38_Build(self):
        my_manifest = manifest
        my_manifest.build_sif = os.path.join(my_manifest.SIF_DIR, "CentOS_8_Py38_Build.def")
        my_manifest.build_id = os.path.join(my_manifest.SIF_DIR, "CentOS_8_Py38_Build.id")
        build_eradication_singularity(self.platform, my_manifest, force_build_exe=False, python=38)

