import os
import unittest

from idmtools.core.platform_factory import Platform

from idm_test.dtk_test.integration import manifest
from idm_test.dtk_test.integration.create_singularity import build_sft_singularity, build_eradication_singularity


class TestBuildSingularity39(unittest.TestCase):
    @classmethod
    def setUpClass(cls) -> None:
        cls.platform = Platform(manifest.platform)

    def setUp(self) -> None:
        self.case_name = os.path.basename(__file__) + "--" + self._testMethodName

    def test_build_CentOS_8_Py39_SFT(self):
        build_sft_singularity(self.platform, manifest)

    def test_build_CentOS_8_Py39_Build(self):
        build_eradication_singularity(self.platform, manifest, force_build_exe=False)

