"""Misc util functions for cli."""
from __future__ import absolute_import
from __future__ import with_statement

import errno
import os.path
from os import makedirs
from glob import glob

try:
    basestring
except NameError:
    basestring = str


def expand_path(path):
    """Expands directories and globs in given path."""
    paths = []
    path = os.path.expanduser(path)
    path = os.path.expandvars(path)

    if os.path.isdir(path):

        for (dir, _dirs, files) in os.walk(path):
            for file in files:
                paths.append(os.path.join(dir, file))
    else:
        paths.extend(glob(path))

    return paths


def is_collection(obj):
    """Tests if an object is a collection. Strings don't count."""
    if isinstance(obj, basestring):
        return False

    return hasattr(obj, '__getitem__')


def mkdir_p(path):
    """Emulates `mkdir -p` behavior."""
    try:
        makedirs(path)
    except OSError as exc:  # Python >2.5
        if exc.errno != errno.EEXIST:
            raise


def tsplit(string, delimiters):
    """Behaves str.split but supports tuples of delimiters."""
    delimiters = tuple(delimiters)
    if len(delimiters) < 1:
        return [string, ]
    final_delimiter = delimiters[0]
    for i in delimiters[1:]:
        string = string.replace(i, final_delimiter)
    return string.split(final_delimiter)


def schunk(string, size):
    """Splits string into n sized chunks."""
    return [string[i:i + size] for i in range(0, len(string), size)]
