from typing import Any, Protocol

from pydantic import BaseModel


class IBasePersistence(Protocol):
    def load_data(self, model: BaseModel) -> bool: ...
    def save_data(self, model: BaseModel) -> Any: ...
    def __init__(self) -> None: ...

class IBaseCommand(Protocol):
    def get_model(self) -> 'IBaseModel | None': ...

    def execute(self, **params: Any) -> Any: ...

    def exec_command(self, command_name: str, **params: Any) -> Any: ...

class IBaseModel(Protocol):
    def get_data(self) -> BaseModel: ...
    def load_data(self) -> bool: ...
    def save_data(self) -> None: ...
    def __init__(self, persistence: IBasePersistence, **data: Any) -> None: ...
    def exec_command(self, command_name: str, **params: Any) -> Any: ...

class IBaseView(Protocol):
    def update(self, model: IBaseModel) -> None: ...
    def refresh(self, model: IBaseModel) -> None: ...
    def on_field_change(self, field: Any, old_value: Any, new_value: Any) -> None: ...

class IBaseController(Protocol):
    def run(self) -> None: ...
    def execute(self) -> None: ...
