"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyopencga.rest_clients._parent_rest_clients import _ParentRestClient


class Organization(_ParentRestClient):
    """
    This class contains methods for the 'Organizations' webservices
    PATH: /{apiVersion}/organizations
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Organization, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def create(self, data=None, **options):
        """
        Create a new organization.
        PATH: /{apiVersion}/organizations/create

        :param dict data: JSON containing the organization to be created.
            (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='organizations', resource='create', data=data, **options)

    def create_notes(self, data=None, **options):
        """
        Create a new note.
        PATH: /{apiVersion}/organizations/notes/create

        :param dict data: JSON containing the Note to be added. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='organizations', resource='create', subcategory='notes', data=data, **options)

    def search_notes(self, **options):
        """
        Search for notes of scope ORGANIZATION.
        PATH: /{apiVersion}/organizations/notes/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str id: Note unique identifier.
        :param str type: Note type.
        :param str scope: Scope of the Note.
        :param str visibility: Visibility of the Note.
        :param str uuid: Unique 32-character identifier assigned automatically
            by OpenCGA.
        :param str user_id: User that wrote that Note.
        :param str tags: Note tags.
        :param str version: Autoincremental version assigned to the registered
            entry. By default, updates does not create new versions. To enable
            versioning, users must set the `incVersion` flag from the /update
            web service when updating the document.
        """

        return self._get(category='organizations', resource='search', subcategory='notes', **options)

    def delete_notes(self, id, **options):
        """
        Delete note.
        PATH: /{apiVersion}/organizations/notes/{id}/delete

        :param str id: Note unique identifier. (REQUIRED)
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._delete(category='organizations', resource='delete', subcategory='notes', second_query_id=id, **options)

    def update_notes(self, id, data=None, **options):
        """
        Update a note.
        PATH: /{apiVersion}/organizations/notes/{id}/update

        :param dict data: JSON containing the Note fields to be updated.
            (REQUIRED)
        :param str id: Note unique identifier. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str tags_action: Action to be performed if the array of tags is
            being updated. Allowed values: ['ADD SET REMOVE']
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='organizations', resource='update', subcategory='notes', second_query_id=id, data=data, **options)

    def reset_user_password(self, **options):
        """
        Reset user's password.
        PATH: /{apiVersion}/organizations/user/password/reset

        :param str user_id: User whose password needs to be reset.
        """

        return self._post(category='organizations', resource='reset', subcategory='user/password', **options)

    def user_update_status(self, user, data=None, **options):
        """
        Update the user status.
        PATH: /{apiVersion}/organizations/user/{user}/status/update

        :param dict data: JSON containing the User fields to be updated.
            (REQUIRED)
        :param str user: User ID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str organization: Organization id.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='organizations/user', resource='update', query_id=user, subcategory='status', data=data, **options)

    def update_user(self, user, data=None, **options):
        """
        Update the user information.
        PATH: /{apiVersion}/organizations/user/{user}/update

        :param dict data: JSON containing the User fields to be updated.
            (REQUIRED)
        :param str user: User ID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str organization: Organization id.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='organizations', resource='update', subcategory='user', second_query_id=user, data=data, **options)

    def update_configuration(self, organization, data=None, **options):
        """
        Update the Organization configuration attributes.
        PATH: /{apiVersion}/organizations/{organization}/configuration/update

        :param dict data: JSON containing the params to be updated. (REQUIRED)
        :param str organization: Organization id. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        :param str authentication_origins_action: Action to be performed if
            the array of authenticationOrigins is being updated. Allowed
            values: ['ADD SET REMOVE REPLACE']
        """

        return self._post(category='organizations', resource='update', query_id=organization, subcategory='configuration', data=data, **options)

    def info(self, organization, **options):
        """
        Return the organization information.
        PATH: /{apiVersion}/organizations/{organization}/info

        :param str organization: Organization id. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        """

        return self._get(category='organizations', resource='info', query_id=organization, **options)

    def update(self, organization, data=None, **options):
        """
        Update some organization attributes.
        PATH: /{apiVersion}/organizations/{organization}/update

        :param dict data: JSON containing the params to be updated. (REQUIRED)
        :param str organization: Organization id. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        :param str admins_action: Action to be performed if the array of
            admins is being updated. Allowed values: ['ADD REMOVE']
        """

        return self._post(category='organizations', resource='update', query_id=organization, data=data, **options)

