# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EnablementArgs', 'Enablement']

@pulumi.input_type
class EnablementArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[_builtins.str],
                 entity_type: pulumi.Input[_builtins.str],
                 feature: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Enablement resource.
        :param pulumi.Input[_builtins.str] entity_id: The ID of the entity for which to manage the enablement.
        :param pulumi.Input[_builtins.str] entity_type: The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        :param pulumi.Input[_builtins.str] feature: The name of the feature to enable or disable. Possible values can be `aiops`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "feature", feature)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the entity for which to manage the enablement.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_id", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _EnablementState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Enablement resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        :param pulumi.Input[_builtins.str] entity_id: The ID of the entity for which to manage the enablement.
        :param pulumi.Input[_builtins.str] entity_type: The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        :param pulumi.Input[_builtins.str] feature: The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the entity for which to manage the enablement.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_id", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)


@pulumi.type_token("pagerduty:index/enablement:Enablement")
class Enablement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        [Enablements](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODE5Nw-list-enablements) allow you to enable or disable specific features for PagerDuty entities such as services and event orchestrations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.get_service(name="My Web Service")
        example_enablement = pagerduty.Enablement("example",
            entity_type="service",
            entity_id=example.id,
            feature="aiops",
            enabled=True)
        ```

        ## Import

        Enablements can be imported using the `id`, which is constructed by concatenating the `entity_type`, `entity_id`, and `feature` with dots, e.g.

        ```sh
        $ pulumi import pagerduty:index/enablement:Enablement example service.P7HHMVK.aiops
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        :param pulumi.Input[_builtins.str] entity_id: The ID of the entity for which to manage the enablement.
        :param pulumi.Input[_builtins.str] entity_type: The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        :param pulumi.Input[_builtins.str] feature: The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnablementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [Enablements](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODE5Nw-list-enablements) allow you to enable or disable specific features for PagerDuty entities such as services and event orchestrations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.get_service(name="My Web Service")
        example_enablement = pagerduty.Enablement("example",
            entity_type="service",
            entity_id=example.id,
            feature="aiops",
            enabled=True)
        ```

        ## Import

        Enablements can be imported using the `id`, which is constructed by concatenating the `entity_type`, `entity_id`, and `feature` with dots, e.g.

        ```sh
        $ pulumi import pagerduty:index/enablement:Enablement example service.P7HHMVK.aiops
        ```

        :param str resource_name: The name of the resource.
        :param EnablementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnablementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnablementArgs.__new__(EnablementArgs)

            __props__.__dict__["enabled"] = enabled
            if entity_id is None and not opts.urn:
                raise TypeError("Missing required property 'entity_id'")
            __props__.__dict__["entity_id"] = entity_id
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            if feature is None and not opts.urn:
                raise TypeError("Missing required property 'feature'")
            __props__.__dict__["feature"] = feature
        super(Enablement, __self__).__init__(
            'pagerduty:index/enablement:Enablement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_id: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None,
            feature: Optional[pulumi.Input[_builtins.str]] = None) -> 'Enablement':
        """
        Get an existing Enablement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        :param pulumi.Input[_builtins.str] entity_id: The ID of the entity for which to manage the enablement.
        :param pulumi.Input[_builtins.str] entity_type: The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        :param pulumi.Input[_builtins.str] feature: The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnablementState.__new__(_EnablementState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["feature"] = feature
        return Enablement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the feature should be enabled (`true`) or disabled (`false`) for the specified entity.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the entity for which to manage the enablement.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of entity for which to manage the enablement. Possible values can be `service` and `event_orchestration`.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def feature(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature to enable or disable. Possible values can be `aiops`.
        """
        return pulumi.get(self, "feature")

