# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEventOrchestrationsResult',
    'AwaitableGetEventOrchestrationsResult',
    'get_event_orchestrations',
    'get_event_orchestrations_output',
]

@pulumi.output_type
class GetEventOrchestrationsResult:
    """
    A collection of values returned by getEventOrchestrations.
    """
    def __init__(__self__, event_orchestrations=None, id=None, name_filter=None):
        if event_orchestrations and not isinstance(event_orchestrations, list):
            raise TypeError("Expected argument 'event_orchestrations' to be a list")
        pulumi.set(__self__, "event_orchestrations", event_orchestrations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)

    @_builtins.property
    @pulumi.getter(name="eventOrchestrations")
    def event_orchestrations(self) -> Sequence['outputs.GetEventOrchestrationsEventOrchestrationResult']:
        """
        The list of the Event Orchestrations with a name that matches the `name_filter` argument.
        """
        return pulumi.get(self, "event_orchestrations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> _builtins.str:
        """
        The regex supplied to find the list of Global Event Orchestrations
        """
        return pulumi.get(self, "name_filter")


class AwaitableGetEventOrchestrationsResult(GetEventOrchestrationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventOrchestrationsResult(
            event_orchestrations=self.event_orchestrations,
            id=self.id,
            name_filter=self.name_filter)


def get_event_orchestrations(name_filter: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventOrchestrationsResult:
    """
    Use this data source to get information as a list about specific Global [Event Orchestrations](https://developer.pagerduty.com/api-reference/7ba0fe7bdb26a-list-event-orchestrations) filtered by a Regular Expression provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    tf_orch_a = pagerduty.EventOrchestration("tf_orch_a", name="Test Event A Orchestration")
    tf_orch_b = pagerduty.EventOrchestration("tf_orch_b", name="Test Event B Orchestration")
    tf_my_monitor = pagerduty.get_event_orchestrations(name_filter=".*Orchestration$")
    cache_var = pagerduty.EventOrchestrationGlobalCacheVariable("cache_var",
        event_orchestration=tf_my_monitor.event_orchestrations[0].id,
        name="recent_host",
        conditions=[{
            "expression": "event.source exists",
        }],
        configuration={
            "type": "recent_value",
            "source": "event.source",
            "regex": ".*",
        })
    ```


    :param _builtins.str name_filter: The regex name of Global Event Orchestrations to find in the PagerDuty API.
    """
    __args__ = dict()
    __args__['nameFilter'] = name_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getEventOrchestrations:getEventOrchestrations', __args__, opts=opts, typ=GetEventOrchestrationsResult).value

    return AwaitableGetEventOrchestrationsResult(
        event_orchestrations=pulumi.get(__ret__, 'event_orchestrations'),
        id=pulumi.get(__ret__, 'id'),
        name_filter=pulumi.get(__ret__, 'name_filter'))
def get_event_orchestrations_output(name_filter: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventOrchestrationsResult]:
    """
    Use this data source to get information as a list about specific Global [Event Orchestrations](https://developer.pagerduty.com/api-reference/7ba0fe7bdb26a-list-event-orchestrations) filtered by a Regular Expression provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    tf_orch_a = pagerduty.EventOrchestration("tf_orch_a", name="Test Event A Orchestration")
    tf_orch_b = pagerduty.EventOrchestration("tf_orch_b", name="Test Event B Orchestration")
    tf_my_monitor = pagerduty.get_event_orchestrations(name_filter=".*Orchestration$")
    cache_var = pagerduty.EventOrchestrationGlobalCacheVariable("cache_var",
        event_orchestration=tf_my_monitor.event_orchestrations[0].id,
        name="recent_host",
        conditions=[{
            "expression": "event.source exists",
        }],
        configuration={
            "type": "recent_value",
            "source": "event.source",
            "regex": ".*",
        })
    ```


    :param _builtins.str name_filter: The regex name of Global Event Orchestrations to find in the PagerDuty API.
    """
    __args__ = dict()
    __args__['nameFilter'] = name_filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getEventOrchestrations:getEventOrchestrations', __args__, opts=opts, typ=GetEventOrchestrationsResult)
    return __ret__.apply(lambda __response__: GetEventOrchestrationsResult(
        event_orchestrations=pulumi.get(__response__, 'event_orchestrations'),
        id=pulumi.get(__response__, 'id'),
        name_filter=pulumi.get(__response__, 'name_filter')))
