# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 escalation_policy: pulumi.Input[_builtins.str],
                 acknowledgement_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping_parameters: Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']] = None,
                 alert_grouping_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pause_notifications_parameters: Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']] = None,
                 auto_resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_urgency_rule: Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 response_play: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]] = None,
                 support_hours: Optional[pulumi.Input['ServiceSupportHoursArgs']] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] escalation_policy: The escalation policy used by this service.
        :param pulumi.Input[_builtins.str] acknowledgement_timeout: Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        :param pulumi.Input[_builtins.str] alert_creation: (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        :param pulumi.Input[_builtins.str] alert_grouping: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        :param pulumi.Input['ServiceAlertGroupingParametersArgs'] alert_grouping_parameters: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        :param pulumi.Input[_builtins.str] alert_grouping_timeout: (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        :param pulumi.Input['ServiceAutoPauseNotificationsParametersArgs'] auto_pause_notifications_parameters: Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        :param pulumi.Input[_builtins.str] auto_resolve_timeout: Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        :param pulumi.Input[_builtins.str] description: A human-friendly description of the service.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] response_play: (Deprecated) The response play used by this service.
        """
        pulumi.set(__self__, "escalation_policy", escalation_policy)
        if acknowledgement_timeout is not None:
            pulumi.set(__self__, "acknowledgement_timeout", acknowledgement_timeout)
        if alert_creation is not None:
            pulumi.set(__self__, "alert_creation", alert_creation)
        if alert_grouping is not None:
            warnings.warn("""Use `alert_grouping_parameters.type`""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping is deprecated: Use `alert_grouping_parameters.type`""")
        if alert_grouping is not None:
            pulumi.set(__self__, "alert_grouping", alert_grouping)
        if alert_grouping_parameters is not None:
            warnings.warn("""Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping_parameters is deprecated: Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""")
        if alert_grouping_parameters is not None:
            pulumi.set(__self__, "alert_grouping_parameters", alert_grouping_parameters)
        if alert_grouping_timeout is not None:
            warnings.warn("""Use `alert_grouping_parameters.config.timeout`""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping_timeout is deprecated: Use `alert_grouping_parameters.config.timeout`""")
        if alert_grouping_timeout is not None:
            pulumi.set(__self__, "alert_grouping_timeout", alert_grouping_timeout)
        if auto_pause_notifications_parameters is not None:
            pulumi.set(__self__, "auto_pause_notifications_parameters", auto_pause_notifications_parameters)
        if auto_resolve_timeout is not None:
            pulumi.set(__self__, "auto_resolve_timeout", auto_resolve_timeout)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if incident_urgency_rule is not None:
            pulumi.set(__self__, "incident_urgency_rule", incident_urgency_rule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if response_play is not None:
            pulumi.set(__self__, "response_play", response_play)
        if scheduled_actions is not None:
            pulumi.set(__self__, "scheduled_actions", scheduled_actions)
        if support_hours is not None:
            pulumi.set(__self__, "support_hours", support_hours)

    @_builtins.property
    @pulumi.getter(name="escalationPolicy")
    def escalation_policy(self) -> pulumi.Input[_builtins.str]:
        """
        The escalation policy used by this service.
        """
        return pulumi.get(self, "escalation_policy")

    @escalation_policy.setter
    def escalation_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "escalation_policy", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgementTimeout")
    def acknowledgement_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        """
        return pulumi.get(self, "acknowledgement_timeout")

    @acknowledgement_timeout.setter
    def acknowledgement_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acknowledgement_timeout", value)

    @_builtins.property
    @pulumi.getter(name="alertCreation")
    def alert_creation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        """
        return pulumi.get(self, "alert_creation")

    @alert_creation.setter
    def alert_creation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_creation", value)

    @_builtins.property
    @pulumi.getter(name="alertGrouping")
    @_utilities.deprecated("""Use `alert_grouping_parameters.type`""")
    def alert_grouping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        """
        return pulumi.get(self, "alert_grouping")

    @alert_grouping.setter
    def alert_grouping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_grouping", value)

    @_builtins.property
    @pulumi.getter(name="alertGroupingParameters")
    @_utilities.deprecated("""Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""")
    def alert_grouping_parameters(self) -> Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        """
        return pulumi.get(self, "alert_grouping_parameters")

    @alert_grouping_parameters.setter
    def alert_grouping_parameters(self, value: Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']]):
        pulumi.set(self, "alert_grouping_parameters", value)

    @_builtins.property
    @pulumi.getter(name="alertGroupingTimeout")
    @_utilities.deprecated("""Use `alert_grouping_parameters.config.timeout`""")
    def alert_grouping_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        """
        return pulumi.get(self, "alert_grouping_timeout")

    @alert_grouping_timeout.setter
    def alert_grouping_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_grouping_timeout", value)

    @_builtins.property
    @pulumi.getter(name="autoPauseNotificationsParameters")
    def auto_pause_notifications_parameters(self) -> Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']]:
        """
        Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        """
        return pulumi.get(self, "auto_pause_notifications_parameters")

    @auto_pause_notifications_parameters.setter
    def auto_pause_notifications_parameters(self, value: Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']]):
        pulumi.set(self, "auto_pause_notifications_parameters", value)

    @_builtins.property
    @pulumi.getter(name="autoResolveTimeout")
    def auto_resolve_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        """
        return pulumi.get(self, "auto_resolve_timeout")

    @auto_resolve_timeout.setter
    def auto_resolve_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resolve_timeout", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly description of the service.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="incidentUrgencyRule")
    def incident_urgency_rule(self) -> Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']]:
        return pulumi.get(self, "incident_urgency_rule")

    @incident_urgency_rule.setter
    def incident_urgency_rule(self, value: Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']]):
        pulumi.set(self, "incident_urgency_rule", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="responsePlay")
    def response_play(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The response play used by this service.
        """
        return pulumi.get(self, "response_play")

    @response_play.setter
    def response_play(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_play", value)

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]]:
        return pulumi.get(self, "scheduled_actions")

    @scheduled_actions.setter
    def scheduled_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]]):
        pulumi.set(self, "scheduled_actions", value)

    @_builtins.property
    @pulumi.getter(name="supportHours")
    def support_hours(self) -> Optional[pulumi.Input['ServiceSupportHoursArgs']]:
        return pulumi.get(self, "support_hours")

    @support_hours.setter
    def support_hours(self, value: Optional[pulumi.Input['ServiceSupportHoursArgs']]):
        pulumi.set(self, "support_hours", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 acknowledgement_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping_parameters: Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']] = None,
                 alert_grouping_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pause_notifications_parameters: Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']] = None,
                 auto_resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 escalation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 html_url: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_urgency_rule: Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']] = None,
                 last_incident_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 response_play: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_hours: Optional[pulumi.Input['ServiceSupportHoursArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.str] acknowledgement_timeout: Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        :param pulumi.Input[_builtins.str] alert_creation: (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        :param pulumi.Input[_builtins.str] alert_grouping: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        :param pulumi.Input['ServiceAlertGroupingParametersArgs'] alert_grouping_parameters: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        :param pulumi.Input[_builtins.str] alert_grouping_timeout: (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        :param pulumi.Input['ServiceAutoPauseNotificationsParametersArgs'] auto_pause_notifications_parameters: Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        :param pulumi.Input[_builtins.str] auto_resolve_timeout: Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp of the service.
        :param pulumi.Input[_builtins.str] description: A human-friendly description of the service.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[_builtins.str] escalation_policy: The escalation policy used by this service.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app.
        :param pulumi.Input[_builtins.str] last_incident_timestamp: Last incident timestamp of the service.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] response_play: (Deprecated) The response play used by this service.
        :param pulumi.Input[_builtins.str] status: The status of the service.
        :param pulumi.Input[_builtins.str] type: The type of object. The value returned will be `service`. Can be used for passing to a service dependency.
        """
        if acknowledgement_timeout is not None:
            pulumi.set(__self__, "acknowledgement_timeout", acknowledgement_timeout)
        if alert_creation is not None:
            pulumi.set(__self__, "alert_creation", alert_creation)
        if alert_grouping is not None:
            warnings.warn("""Use `alert_grouping_parameters.type`""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping is deprecated: Use `alert_grouping_parameters.type`""")
        if alert_grouping is not None:
            pulumi.set(__self__, "alert_grouping", alert_grouping)
        if alert_grouping_parameters is not None:
            warnings.warn("""Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping_parameters is deprecated: Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""")
        if alert_grouping_parameters is not None:
            pulumi.set(__self__, "alert_grouping_parameters", alert_grouping_parameters)
        if alert_grouping_timeout is not None:
            warnings.warn("""Use `alert_grouping_parameters.config.timeout`""", DeprecationWarning)
            pulumi.log.warn("""alert_grouping_timeout is deprecated: Use `alert_grouping_parameters.config.timeout`""")
        if alert_grouping_timeout is not None:
            pulumi.set(__self__, "alert_grouping_timeout", alert_grouping_timeout)
        if auto_pause_notifications_parameters is not None:
            pulumi.set(__self__, "auto_pause_notifications_parameters", auto_pause_notifications_parameters)
        if auto_resolve_timeout is not None:
            pulumi.set(__self__, "auto_resolve_timeout", auto_resolve_timeout)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if escalation_policy is not None:
            pulumi.set(__self__, "escalation_policy", escalation_policy)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if incident_urgency_rule is not None:
            pulumi.set(__self__, "incident_urgency_rule", incident_urgency_rule)
        if last_incident_timestamp is not None:
            pulumi.set(__self__, "last_incident_timestamp", last_incident_timestamp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if response_play is not None:
            pulumi.set(__self__, "response_play", response_play)
        if scheduled_actions is not None:
            pulumi.set(__self__, "scheduled_actions", scheduled_actions)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_hours is not None:
            pulumi.set(__self__, "support_hours", support_hours)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="acknowledgementTimeout")
    def acknowledgement_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        """
        return pulumi.get(self, "acknowledgement_timeout")

    @acknowledgement_timeout.setter
    def acknowledgement_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acknowledgement_timeout", value)

    @_builtins.property
    @pulumi.getter(name="alertCreation")
    def alert_creation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        """
        return pulumi.get(self, "alert_creation")

    @alert_creation.setter
    def alert_creation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_creation", value)

    @_builtins.property
    @pulumi.getter(name="alertGrouping")
    @_utilities.deprecated("""Use `alert_grouping_parameters.type`""")
    def alert_grouping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        """
        return pulumi.get(self, "alert_grouping")

    @alert_grouping.setter
    def alert_grouping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_grouping", value)

    @_builtins.property
    @pulumi.getter(name="alertGroupingParameters")
    @_utilities.deprecated("""Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""")
    def alert_grouping_parameters(self) -> Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        """
        return pulumi.get(self, "alert_grouping_parameters")

    @alert_grouping_parameters.setter
    def alert_grouping_parameters(self, value: Optional[pulumi.Input['ServiceAlertGroupingParametersArgs']]):
        pulumi.set(self, "alert_grouping_parameters", value)

    @_builtins.property
    @pulumi.getter(name="alertGroupingTimeout")
    @_utilities.deprecated("""Use `alert_grouping_parameters.config.timeout`""")
    def alert_grouping_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        """
        return pulumi.get(self, "alert_grouping_timeout")

    @alert_grouping_timeout.setter
    def alert_grouping_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_grouping_timeout", value)

    @_builtins.property
    @pulumi.getter(name="autoPauseNotificationsParameters")
    def auto_pause_notifications_parameters(self) -> Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']]:
        """
        Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        """
        return pulumi.get(self, "auto_pause_notifications_parameters")

    @auto_pause_notifications_parameters.setter
    def auto_pause_notifications_parameters(self, value: Optional[pulumi.Input['ServiceAutoPauseNotificationsParametersArgs']]):
        pulumi.set(self, "auto_pause_notifications_parameters", value)

    @_builtins.property
    @pulumi.getter(name="autoResolveTimeout")
    def auto_resolve_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        """
        return pulumi.get(self, "auto_resolve_timeout")

    @auto_resolve_timeout.setter
    def auto_resolve_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resolve_timeout", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp of the service.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly description of the service.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="escalationPolicy")
    def escalation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The escalation policy used by this service.
        """
        return pulumi.get(self, "escalation_policy")

    @escalation_policy.setter
    def escalation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "escalation_policy", value)

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL at which the entity is uniquely displayed in the Web app.
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_url", value)

    @_builtins.property
    @pulumi.getter(name="incidentUrgencyRule")
    def incident_urgency_rule(self) -> Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']]:
        return pulumi.get(self, "incident_urgency_rule")

    @incident_urgency_rule.setter
    def incident_urgency_rule(self, value: Optional[pulumi.Input['ServiceIncidentUrgencyRuleArgs']]):
        pulumi.set(self, "incident_urgency_rule", value)

    @_builtins.property
    @pulumi.getter(name="lastIncidentTimestamp")
    def last_incident_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last incident timestamp of the service.
        """
        return pulumi.get(self, "last_incident_timestamp")

    @last_incident_timestamp.setter
    def last_incident_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_incident_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="responsePlay")
    def response_play(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The response play used by this service.
        """
        return pulumi.get(self, "response_play")

    @response_play.setter
    def response_play(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_play", value)

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]]:
        return pulumi.get(self, "scheduled_actions")

    @scheduled_actions.setter
    def scheduled_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceScheduledActionArgs']]]]):
        pulumi.set(self, "scheduled_actions", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportHours")
    def support_hours(self) -> Optional[pulumi.Input['ServiceSupportHoursArgs']]:
        return pulumi.get(self, "support_hours")

    @support_hours.setter
    def support_hours(self, value: Optional[pulumi.Input['ServiceSupportHoursArgs']]):
        pulumi.set(self, "support_hours", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of object. The value returned will be `service`. Can be used for passing to a service dependency.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("pagerduty:index/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledgement_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping_parameters: Optional[pulumi.Input[Union['ServiceAlertGroupingParametersArgs', 'ServiceAlertGroupingParametersArgsDict']]] = None,
                 alert_grouping_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pause_notifications_parameters: Optional[pulumi.Input[Union['ServiceAutoPauseNotificationsParametersArgs', 'ServiceAutoPauseNotificationsParametersArgsDict']]] = None,
                 auto_resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 escalation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_urgency_rule: Optional[pulumi.Input[Union['ServiceIncidentUrgencyRuleArgs', 'ServiceIncidentUrgencyRuleArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 response_play: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceScheduledActionArgs', 'ServiceScheduledActionArgsDict']]]]] = None,
                 support_hours: Optional[pulumi.Input[Union['ServiceSupportHoursArgs', 'ServiceSupportHoursArgsDict']]] = None,
                 __props__=None):
        """
        A [service](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODE5Nw-create-a-service) represents something you monitor (like a web service, email service, or database service). It is a container for related incidents that associates them with escalation policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@graham.name")
        foo = pagerduty.EscalationPolicy("foo",
            name="Engineering Escalation Policy",
            num_loops=2,
            rules=[{
                "escalation_delay_in_minutes": 10,
                "targets": [{
                    "type": "user_reference",
                    "id": example.id,
                }],
            }])
        example_service = pagerduty.Service("example",
            name="My Web App",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=foo.id,
            alert_creation="create_alerts_and_incidents",
            auto_pause_notifications_parameters={
                "enabled": True,
                "timeout": 300,
            })
        ```

        ## Import

        Services can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/service:Service main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acknowledgement_timeout: Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        :param pulumi.Input[_builtins.str] alert_creation: (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        :param pulumi.Input[_builtins.str] alert_grouping: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        :param pulumi.Input[Union['ServiceAlertGroupingParametersArgs', 'ServiceAlertGroupingParametersArgsDict']] alert_grouping_parameters: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        :param pulumi.Input[_builtins.str] alert_grouping_timeout: (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        :param pulumi.Input[Union['ServiceAutoPauseNotificationsParametersArgs', 'ServiceAutoPauseNotificationsParametersArgsDict']] auto_pause_notifications_parameters: Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        :param pulumi.Input[_builtins.str] auto_resolve_timeout: Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        :param pulumi.Input[_builtins.str] description: A human-friendly description of the service.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[_builtins.str] escalation_policy: The escalation policy used by this service.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] response_play: (Deprecated) The response play used by this service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A [service](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODE5Nw-create-a-service) represents something you monitor (like a web service, email service, or database service). It is a container for related incidents that associates them with escalation policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@graham.name")
        foo = pagerduty.EscalationPolicy("foo",
            name="Engineering Escalation Policy",
            num_loops=2,
            rules=[{
                "escalation_delay_in_minutes": 10,
                "targets": [{
                    "type": "user_reference",
                    "id": example.id,
                }],
            }])
        example_service = pagerduty.Service("example",
            name="My Web App",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=foo.id,
            alert_creation="create_alerts_and_incidents",
            auto_pause_notifications_parameters={
                "enabled": True,
                "timeout": 300,
            })
        ```

        ## Import

        Services can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/service:Service main PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledgement_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_grouping_parameters: Optional[pulumi.Input[Union['ServiceAlertGroupingParametersArgs', 'ServiceAlertGroupingParametersArgsDict']]] = None,
                 alert_grouping_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pause_notifications_parameters: Optional[pulumi.Input[Union['ServiceAutoPauseNotificationsParametersArgs', 'ServiceAutoPauseNotificationsParametersArgsDict']]] = None,
                 auto_resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 escalation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 incident_urgency_rule: Optional[pulumi.Input[Union['ServiceIncidentUrgencyRuleArgs', 'ServiceIncidentUrgencyRuleArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 response_play: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceScheduledActionArgs', 'ServiceScheduledActionArgsDict']]]]] = None,
                 support_hours: Optional[pulumi.Input[Union['ServiceSupportHoursArgs', 'ServiceSupportHoursArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["acknowledgement_timeout"] = acknowledgement_timeout
            __props__.__dict__["alert_creation"] = alert_creation
            __props__.__dict__["alert_grouping"] = alert_grouping
            __props__.__dict__["alert_grouping_parameters"] = alert_grouping_parameters
            __props__.__dict__["alert_grouping_timeout"] = alert_grouping_timeout
            __props__.__dict__["auto_pause_notifications_parameters"] = auto_pause_notifications_parameters
            __props__.__dict__["auto_resolve_timeout"] = auto_resolve_timeout
            if description is None:
                description = 'Managed by Pulumi'
            __props__.__dict__["description"] = description
            if escalation_policy is None and not opts.urn:
                raise TypeError("Missing required property 'escalation_policy'")
            __props__.__dict__["escalation_policy"] = escalation_policy
            __props__.__dict__["incident_urgency_rule"] = incident_urgency_rule
            __props__.__dict__["name"] = name
            __props__.__dict__["response_play"] = response_play
            __props__.__dict__["scheduled_actions"] = scheduled_actions
            __props__.__dict__["support_hours"] = support_hours
            __props__.__dict__["created_at"] = None
            __props__.__dict__["html_url"] = None
            __props__.__dict__["last_incident_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        super(Service, __self__).__init__(
            'pagerduty:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledgement_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            alert_creation: Optional[pulumi.Input[_builtins.str]] = None,
            alert_grouping: Optional[pulumi.Input[_builtins.str]] = None,
            alert_grouping_parameters: Optional[pulumi.Input[Union['ServiceAlertGroupingParametersArgs', 'ServiceAlertGroupingParametersArgsDict']]] = None,
            alert_grouping_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pause_notifications_parameters: Optional[pulumi.Input[Union['ServiceAutoPauseNotificationsParametersArgs', 'ServiceAutoPauseNotificationsParametersArgsDict']]] = None,
            auto_resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            escalation_policy: Optional[pulumi.Input[_builtins.str]] = None,
            html_url: Optional[pulumi.Input[_builtins.str]] = None,
            incident_urgency_rule: Optional[pulumi.Input[Union['ServiceIncidentUrgencyRuleArgs', 'ServiceIncidentUrgencyRuleArgsDict']]] = None,
            last_incident_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            response_play: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceScheduledActionArgs', 'ServiceScheduledActionArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            support_hours: Optional[pulumi.Input[Union['ServiceSupportHoursArgs', 'ServiceSupportHoursArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acknowledgement_timeout: Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        :param pulumi.Input[_builtins.str] alert_creation: (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        :param pulumi.Input[_builtins.str] alert_grouping: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        :param pulumi.Input[Union['ServiceAlertGroupingParametersArgs', 'ServiceAlertGroupingParametersArgsDict']] alert_grouping_parameters: (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        :param pulumi.Input[_builtins.str] alert_grouping_timeout: (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        :param pulumi.Input[Union['ServiceAutoPauseNotificationsParametersArgs', 'ServiceAutoPauseNotificationsParametersArgsDict']] auto_pause_notifications_parameters: Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        :param pulumi.Input[_builtins.str] auto_resolve_timeout: Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp of the service.
        :param pulumi.Input[_builtins.str] description: A human-friendly description of the service.
               If not set, a placeholder of "Managed by Pulumi" will be set.
        :param pulumi.Input[_builtins.str] escalation_policy: The escalation policy used by this service.
        :param pulumi.Input[_builtins.str] html_url: URL at which the entity is uniquely displayed in the Web app.
        :param pulumi.Input[_builtins.str] last_incident_timestamp: Last incident timestamp of the service.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] response_play: (Deprecated) The response play used by this service.
        :param pulumi.Input[_builtins.str] status: The status of the service.
        :param pulumi.Input[_builtins.str] type: The type of object. The value returned will be `service`. Can be used for passing to a service dependency.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["acknowledgement_timeout"] = acknowledgement_timeout
        __props__.__dict__["alert_creation"] = alert_creation
        __props__.__dict__["alert_grouping"] = alert_grouping
        __props__.__dict__["alert_grouping_parameters"] = alert_grouping_parameters
        __props__.__dict__["alert_grouping_timeout"] = alert_grouping_timeout
        __props__.__dict__["auto_pause_notifications_parameters"] = auto_pause_notifications_parameters
        __props__.__dict__["auto_resolve_timeout"] = auto_resolve_timeout
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["escalation_policy"] = escalation_policy
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["incident_urgency_rule"] = incident_urgency_rule
        __props__.__dict__["last_incident_timestamp"] = last_incident_timestamp
        __props__.__dict__["name"] = name
        __props__.__dict__["response_play"] = response_play
        __props__.__dict__["scheduled_actions"] = scheduled_actions
        __props__.__dict__["status"] = status
        __props__.__dict__["support_hours"] = support_hours
        __props__.__dict__["type"] = type
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acknowledgementTimeout")
    def acknowledgement_timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time in seconds that an incident changes to the Triggered State after being Acknowledged. Disabled if set to the `"null"` string.  If not passed in, will default to '"1800"'.
        """
        return pulumi.get(self, "acknowledgement_timeout")

    @_builtins.property
    @pulumi.getter(name="alertCreation")
    def alert_creation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Deprecated) This attribute has been deprecated as all services will be migrated to use alerts and incidents. The incident only service setting will be no longer available and this attribute will be removed in an upcoming version. See knowledge base for details https://support.pagerduty.com/docs/alerts#enable-and-disable-alerts-on-a-service.
        """
        return pulumi.get(self, "alert_creation")

    @_builtins.property
    @pulumi.getter(name="alertGrouping")
    @_utilities.deprecated("""Use `alert_grouping_parameters.type`""")
    def alert_grouping(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident; If value is set to `time`: All alerts within a specified duration will be grouped into the same incident. This duration is set in the `alert_grouping_timeout` setting (described below). Available on Standard, Enterprise, and Event Intelligence plans; If value is set to `intelligent` - Alerts will be intelligently grouped based on a machine learning model that looks at the alert summary, timing, and the history of grouped alerts. Available on Enterprise and Event Intelligence plan. This field is deprecated, use `alert_grouping_parameters.type` instead,
        """
        return pulumi.get(self, "alert_grouping")

    @_builtins.property
    @pulumi.getter(name="alertGroupingParameters")
    @_utilities.deprecated("""Use a resource `AlertGroupingSetting` instead.
Follow the migration guide at https://registry.terraform.io/providers/PagerDuty/pagerduty/latest/docs/resources/alert_grouping_setting#migration-from-alert_grouping_parameters""")
    def alert_grouping_parameters(self) -> pulumi.Output[Optional['outputs.ServiceAlertGroupingParameters']]:
        """
        (Deprecated) Defines how alerts on this service will be automatically grouped into incidents. Note that the alert grouping features are available only on certain plans. If not set, each alert will create a separate incident. Instructions on how to migrate this configuration to `AlertGroupingSetting` resource can be found here.
        """
        return pulumi.get(self, "alert_grouping_parameters")

    @_builtins.property
    @pulumi.getter(name="alertGroupingTimeout")
    @_utilities.deprecated("""Use `alert_grouping_parameters.config.timeout`""")
    def alert_grouping_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated) The duration in minutes within which to automatically group incoming alerts. This setting applies only when `alert_grouping` is set to `time`. To continue grouping alerts until the incident is resolved, set this value to `0`. This field is deprecated, use `alert_grouping_parameters.config.timeout` instead,
        """
        return pulumi.get(self, "alert_grouping_timeout")

    @_builtins.property
    @pulumi.getter(name="autoPauseNotificationsParameters")
    def auto_pause_notifications_parameters(self) -> pulumi.Output['outputs.ServiceAutoPauseNotificationsParameters']:
        """
        Defines how alerts on this service are automatically suspended for a period of time before triggering, when identified as likely being transient. Note that automatically pausing notifications is only available on certain plans as mentioned [here](https://support.pagerduty.com/docs/auto-pause-incident-notifications).
        """
        return pulumi.get(self, "auto_pause_notifications_parameters")

    @_builtins.property
    @pulumi.getter(name="autoResolveTimeout")
    def auto_resolve_timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time in seconds that an incident is automatically resolved if left open for that long. Disabled if set to the `"null"` string.
        """
        return pulumi.get(self, "auto_resolve_timeout")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp of the service.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A human-friendly description of the service.
        If not set, a placeholder of "Managed by Pulumi" will be set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="escalationPolicy")
    def escalation_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The escalation policy used by this service.
        """
        return pulumi.get(self, "escalation_policy")

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL at which the entity is uniquely displayed in the Web app.
        """
        return pulumi.get(self, "html_url")

    @_builtins.property
    @pulumi.getter(name="incidentUrgencyRule")
    def incident_urgency_rule(self) -> pulumi.Output['outputs.ServiceIncidentUrgencyRule']:
        return pulumi.get(self, "incident_urgency_rule")

    @_builtins.property
    @pulumi.getter(name="lastIncidentTimestamp")
    def last_incident_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Last incident timestamp of the service.
        """
        return pulumi.get(self, "last_incident_timestamp")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="responsePlay")
    def response_play(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated) The response play used by this service.
        """
        return pulumi.get(self, "response_play")

    @_builtins.property
    @pulumi.getter(name="scheduledActions")
    def scheduled_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceScheduledAction']]]:
        return pulumi.get(self, "scheduled_actions")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportHours")
    def support_hours(self) -> pulumi.Output[Optional['outputs.ServiceSupportHours']]:
        return pulumi.get(self, "support_hours")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of object. The value returned will be `service`. Can be used for passing to a service dependency.
        """
        return pulumi.get(self, "type")

