# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceCustomFieldValueArgs', 'ServiceCustomFieldValue']

@pulumi.input_type
class ServiceCustomFieldValueArgs:
    def __init__(__self__, *,
                 custom_fields: pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]],
                 service_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServiceCustomFieldValue resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]] custom_fields: The custom field values to set for the service.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service to set custom field values for.
        """
        pulumi.set(__self__, "custom_fields", custom_fields)
        pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]]:
        """
        The custom field values to set for the service.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]]):
        pulumi.set(self, "custom_fields", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the service to set custom field values for.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)


@pulumi.input_type
class _ServiceCustomFieldValueState:
    def __init__(__self__, *,
                 custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceCustomFieldValue resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]] custom_fields: The custom field values to set for the service.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service to set custom field values for.
        """
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]]]:
        """
        The custom field values to set for the service.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCustomFieldValueCustomFieldArgs']]]]):
        pulumi.set(self, "custom_fields", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service to set custom field values for.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("pagerduty:index/serviceCustomFieldValue:ServiceCustomFieldValue")
class ServiceCustomFieldValue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldValueCustomFieldArgs', 'ServiceCustomFieldValueCustomFieldArgsDict']]]]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_pagerduty as pagerduty

        # First, create service custom fields
        environment = pagerduty.ServiceCustomField("environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value",
            description="The environment this service runs in")
        region = pagerduty.ServiceCustomField("region",
            name="region",
            display_name="Region",
            data_type="string",
            field_type="single_value",
            description="The region this service is deployed in")
        is_critical = pagerduty.ServiceCustomField("is_critical",
            name="is_critical",
            display_name="Is Critical",
            data_type="boolean",
            field_type="single_value",
            description="Whether this service is critical")
        regions = pagerduty.ServiceCustomField("regions",
            name="regions",
            display_name="AWS Regions",
            data_type="string",
            field_type="multi_value_fixed",
            description="AWS regions where this service is deployed",
            field_options=[
                {
                    "value": "us-east-1",
                    "data_type": "string",
                },
                {
                    "value": "us-west-1",
                    "data_type": "string",
                },
            ])
        # Create a service
        example = pagerduty.Service("example",
            name="Example Service",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=example_pagerduty_escalation_policy["id"])
        # Set custom field values on the service
        example_service_custom_field_value = pagerduty.ServiceCustomFieldValue("example",
            service_id=example.id,
            custom_fields=[
                {
                    "name": environment.name,
                    "value": json.dumps("production"),
                },
                {
                    "name": region.name,
                    "value": json.dumps("us-east-1"),
                },
                {
                    "name": is_critical.name,
                    "value": json.dumps(True),
                },
                {
                    "name": regions.name,
                    "value": json.dumps([
                        "us-east-1",
                        "us-west-1",
                    ]),
                },
            ])
        ```

        ## Import

        Service custom field values can be imported using the service ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/serviceCustomFieldValue:ServiceCustomFieldValue example PXYZ123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldValueCustomFieldArgs', 'ServiceCustomFieldValueCustomFieldArgsDict']]]] custom_fields: The custom field values to set for the service.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service to set custom field values for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceCustomFieldValueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_pagerduty as pagerduty

        # First, create service custom fields
        environment = pagerduty.ServiceCustomField("environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value",
            description="The environment this service runs in")
        region = pagerduty.ServiceCustomField("region",
            name="region",
            display_name="Region",
            data_type="string",
            field_type="single_value",
            description="The region this service is deployed in")
        is_critical = pagerduty.ServiceCustomField("is_critical",
            name="is_critical",
            display_name="Is Critical",
            data_type="boolean",
            field_type="single_value",
            description="Whether this service is critical")
        regions = pagerduty.ServiceCustomField("regions",
            name="regions",
            display_name="AWS Regions",
            data_type="string",
            field_type="multi_value_fixed",
            description="AWS regions where this service is deployed",
            field_options=[
                {
                    "value": "us-east-1",
                    "data_type": "string",
                },
                {
                    "value": "us-west-1",
                    "data_type": "string",
                },
            ])
        # Create a service
        example = pagerduty.Service("example",
            name="Example Service",
            auto_resolve_timeout="14400",
            acknowledgement_timeout="600",
            escalation_policy=example_pagerduty_escalation_policy["id"])
        # Set custom field values on the service
        example_service_custom_field_value = pagerduty.ServiceCustomFieldValue("example",
            service_id=example.id,
            custom_fields=[
                {
                    "name": environment.name,
                    "value": json.dumps("production"),
                },
                {
                    "name": region.name,
                    "value": json.dumps("us-east-1"),
                },
                {
                    "name": is_critical.name,
                    "value": json.dumps(True),
                },
                {
                    "name": regions.name,
                    "value": json.dumps([
                        "us-east-1",
                        "us-west-1",
                    ]),
                },
            ])
        ```

        ## Import

        Service custom field values can be imported using the service ID, e.g.

        ```sh
        $ pulumi import pagerduty:index/serviceCustomFieldValue:ServiceCustomFieldValue example PXYZ123
        ```

        :param str resource_name: The name of the resource.
        :param ServiceCustomFieldValueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceCustomFieldValueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldValueCustomFieldArgs', 'ServiceCustomFieldValueCustomFieldArgsDict']]]]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceCustomFieldValueArgs.__new__(ServiceCustomFieldValueArgs)

            if custom_fields is None and not opts.urn:
                raise TypeError("Missing required property 'custom_fields'")
            __props__.__dict__["custom_fields"] = custom_fields
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceCustomFieldValue, __self__).__init__(
            'pagerduty:index/serviceCustomFieldValue:ServiceCustomFieldValue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldValueCustomFieldArgs', 'ServiceCustomFieldValueCustomFieldArgsDict']]]]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceCustomFieldValue':
        """
        Get an existing ServiceCustomFieldValue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCustomFieldValueCustomFieldArgs', 'ServiceCustomFieldValueCustomFieldArgsDict']]]] custom_fields: The custom field values to set for the service.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service to set custom field values for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceCustomFieldValueState.__new__(_ServiceCustomFieldValueState)

        __props__.__dict__["custom_fields"] = custom_fields
        __props__.__dict__["service_id"] = service_id
        return ServiceCustomFieldValue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> pulumi.Output[Sequence['outputs.ServiceCustomFieldValueCustomField']]:
        """
        The custom field values to set for the service.
        """
        return pulumi.get(self, "custom_fields")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the service to set custom field values for.
        """
        return pulumi.get(self, "service_id")

