# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserHandoffNotificationRuleArgs', 'UserHandoffNotificationRule']

@pulumi.input_type
class UserHandoffNotificationRuleArgs:
    def __init__(__self__, *,
                 contact_method: pulumi.Input['UserHandoffNotificationRuleContactMethodArgs'],
                 notify_advance_in_minutes: pulumi.Input[_builtins.int],
                 user_id: pulumi.Input[_builtins.str],
                 handoff_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserHandoffNotificationRule resource.
        :param pulumi.Input['UserHandoffNotificationRuleContactMethodArgs'] contact_method: The contact method to notify the user. Contact method documented below.
        :param pulumi.Input[_builtins.int] notify_advance_in_minutes: The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        :param pulumi.Input[_builtins.str] handoff_type: The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        """
        pulumi.set(__self__, "contact_method", contact_method)
        pulumi.set(__self__, "notify_advance_in_minutes", notify_advance_in_minutes)
        pulumi.set(__self__, "user_id", user_id)
        if handoff_type is not None:
            pulumi.set(__self__, "handoff_type", handoff_type)

    @_builtins.property
    @pulumi.getter(name="contactMethod")
    def contact_method(self) -> pulumi.Input['UserHandoffNotificationRuleContactMethodArgs']:
        """
        The contact method to notify the user. Contact method documented below.
        """
        return pulumi.get(self, "contact_method")

    @contact_method.setter
    def contact_method(self, value: pulumi.Input['UserHandoffNotificationRuleContactMethodArgs']):
        pulumi.set(self, "contact_method", value)

    @_builtins.property
    @pulumi.getter(name="notifyAdvanceInMinutes")
    def notify_advance_in_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        """
        return pulumi.get(self, "notify_advance_in_minutes")

    @notify_advance_in_minutes.setter
    def notify_advance_in_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "notify_advance_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="handoffType")
    def handoff_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        """
        return pulumi.get(self, "handoff_type")

    @handoff_type.setter
    def handoff_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handoff_type", value)


@pulumi.input_type
class _UserHandoffNotificationRuleState:
    def __init__(__self__, *,
                 contact_method: Optional[pulumi.Input['UserHandoffNotificationRuleContactMethodArgs']] = None,
                 handoff_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_advance_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserHandoffNotificationRule resources.
        :param pulumi.Input['UserHandoffNotificationRuleContactMethodArgs'] contact_method: The contact method to notify the user. Contact method documented below.
        :param pulumi.Input[_builtins.str] handoff_type: The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        :param pulumi.Input[_builtins.int] notify_advance_in_minutes: The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        if contact_method is not None:
            pulumi.set(__self__, "contact_method", contact_method)
        if handoff_type is not None:
            pulumi.set(__self__, "handoff_type", handoff_type)
        if notify_advance_in_minutes is not None:
            pulumi.set(__self__, "notify_advance_in_minutes", notify_advance_in_minutes)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="contactMethod")
    def contact_method(self) -> Optional[pulumi.Input['UserHandoffNotificationRuleContactMethodArgs']]:
        """
        The contact method to notify the user. Contact method documented below.
        """
        return pulumi.get(self, "contact_method")

    @contact_method.setter
    def contact_method(self, value: Optional[pulumi.Input['UserHandoffNotificationRuleContactMethodArgs']]):
        pulumi.set(self, "contact_method", value)

    @_builtins.property
    @pulumi.getter(name="handoffType")
    def handoff_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        """
        return pulumi.get(self, "handoff_type")

    @handoff_type.setter
    def handoff_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handoff_type", value)

    @_builtins.property
    @pulumi.getter(name="notifyAdvanceInMinutes")
    def notify_advance_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        """
        return pulumi.get(self, "notify_advance_in_minutes")

    @notify_advance_in_minutes.setter
    def notify_advance_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "notify_advance_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("pagerduty:index/userHandoffNotificationRule:UserHandoffNotificationRule")
class UserHandoffNotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_method: Optional[pulumi.Input[Union['UserHandoffNotificationRuleContactMethodArgs', 'UserHandoffNotificationRuleContactMethodArgsDict']]] = None,
                 handoff_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_advance_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An [user handoff notification rule](https://developer.pagerduty.com/api-reference/f2ab7a3c1418a-create-a-user-handoff-notification-rule) is a rule that specifies how a user should be notified when they are handed off an incident.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@foo.test")
        phone = pagerduty.UserContactMethod("phone",
            user_id=example.id,
            type="phone_contact_method",
            country_code=1,
            address="2025550199",
            label="Work")
        example_oncall_offcall = pagerduty.UserHandoffNotificationRule("example-oncall-offcall",
            user_id=example.id,
            handoff_type="both",
            notify_advance_in_minutes=180,
            contact_method={
                "id": phone.id,
                "type": phone.type,
            })
        ```

        ## Import

        User handoff notification rules can be imported using the `user_id` and `id` separated by a dot, e.g.

        ```sh
        $ pulumi import pagerduty:index/userHandoffNotificationRule:UserHandoffNotificationRule main PX4IAP4.PULREBP
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['UserHandoffNotificationRuleContactMethodArgs', 'UserHandoffNotificationRuleContactMethodArgsDict']] contact_method: The contact method to notify the user. Contact method documented below.
        :param pulumi.Input[_builtins.str] handoff_type: The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        :param pulumi.Input[_builtins.int] notify_advance_in_minutes: The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserHandoffNotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An [user handoff notification rule](https://developer.pagerduty.com/api-reference/f2ab7a3c1418a-create-a-user-handoff-notification-rule) is a rule that specifies how a user should be notified when they are handed off an incident.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.User("example",
            name="Earline Greenholt",
            email="125.greenholt.earline@foo.test")
        phone = pagerduty.UserContactMethod("phone",
            user_id=example.id,
            type="phone_contact_method",
            country_code=1,
            address="2025550199",
            label="Work")
        example_oncall_offcall = pagerduty.UserHandoffNotificationRule("example-oncall-offcall",
            user_id=example.id,
            handoff_type="both",
            notify_advance_in_minutes=180,
            contact_method={
                "id": phone.id,
                "type": phone.type,
            })
        ```

        ## Import

        User handoff notification rules can be imported using the `user_id` and `id` separated by a dot, e.g.

        ```sh
        $ pulumi import pagerduty:index/userHandoffNotificationRule:UserHandoffNotificationRule main PX4IAP4.PULREBP
        ```

        :param str resource_name: The name of the resource.
        :param UserHandoffNotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserHandoffNotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_method: Optional[pulumi.Input[Union['UserHandoffNotificationRuleContactMethodArgs', 'UserHandoffNotificationRuleContactMethodArgsDict']]] = None,
                 handoff_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_advance_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserHandoffNotificationRuleArgs.__new__(UserHandoffNotificationRuleArgs)

            if contact_method is None and not opts.urn:
                raise TypeError("Missing required property 'contact_method'")
            __props__.__dict__["contact_method"] = contact_method
            __props__.__dict__["handoff_type"] = handoff_type
            if notify_advance_in_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'notify_advance_in_minutes'")
            __props__.__dict__["notify_advance_in_minutes"] = notify_advance_in_minutes
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserHandoffNotificationRule, __self__).__init__(
            'pagerduty:index/userHandoffNotificationRule:UserHandoffNotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_method: Optional[pulumi.Input[Union['UserHandoffNotificationRuleContactMethodArgs', 'UserHandoffNotificationRuleContactMethodArgsDict']]] = None,
            handoff_type: Optional[pulumi.Input[_builtins.str]] = None,
            notify_advance_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserHandoffNotificationRule':
        """
        Get an existing UserHandoffNotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['UserHandoffNotificationRuleContactMethodArgs', 'UserHandoffNotificationRuleContactMethodArgsDict']] contact_method: The contact method to notify the user. Contact method documented below.
        :param pulumi.Input[_builtins.str] handoff_type: The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        :param pulumi.Input[_builtins.int] notify_advance_in_minutes: The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserHandoffNotificationRuleState.__new__(_UserHandoffNotificationRuleState)

        __props__.__dict__["contact_method"] = contact_method
        __props__.__dict__["handoff_type"] = handoff_type
        __props__.__dict__["notify_advance_in_minutes"] = notify_advance_in_minutes
        __props__.__dict__["user_id"] = user_id
        return UserHandoffNotificationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contactMethod")
    def contact_method(self) -> pulumi.Output['outputs.UserHandoffNotificationRuleContactMethod']:
        """
        The contact method to notify the user. Contact method documented below.
        """
        return pulumi.get(self, "contact_method")

    @_builtins.property
    @pulumi.getter(name="handoffType")
    def handoff_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of handoff to notify the user about. Possible values are `oncall`, `offcall`, `both`.
        """
        return pulumi.get(self, "handoff_type")

    @_builtins.property
    @pulumi.getter(name="notifyAdvanceInMinutes")
    def notify_advance_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        The number of minutes before the handoff that the user should be notified. Must be a positive integer greater than or equal to 0.
        """
        return pulumi.get(self, "notify_advance_in_minutes")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

