# AI-eBash!

[![Python Version](https://img.shields.io/badge/python-3.11+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![PyPI Version](https://img.shields.io/pypi/v/ai-ebash.svg)](https://pypi.org/project/ai-ebash/)
[![GitHub Stars](https://img.shields.io/github/stars/Vivatist/ai-ebash.svg)](https://github.com/Vivatist/ai-ebash/stargazers)

> **Консольная утилита для интеграции искусственного интеллекта в ваш терминал.** Задавайте вопросы ИИ и выполняйте предложенные скрипты и команды прямо из командной строки. Идеально подходит для новичков в администрировании Linux и Windows.

🌍 **Available in:** [English](../../README.md) | [Русский](README_ru.md)


## Содержание

- [AI-eBash!](#ai-ebash)
  - [Содержание](#содержание)
  - [Возможности](#возможности)
  - [Установка](#установка)
    - [Linux (pipx)](#linux-pipx)
    - [Linux (DEB пакет)](#linux-deb-пакет)
    - [Windows (Экспериментально)](#windows-экспериментально)
  - [Использование](#использование)
    - [Базовое использование](#базовое-использование)
    - [Режим диалога](#режим-диалога)
    - [Выполнение кода](#выполнение-кода)
  - [Конфигурация](#конфигурация)
    - [Первоначальная настройка](#первоначальная-настройка)
    - [Поддерживаемые провайдеры ИИ](#поддерживаемые-провайдеры-ии)
    - [Файл конфигурации](#файл-конфигурации)
  - [Безопасность](#безопасность)
    - [Лучшие практики](#лучшие-практики)
  - [Содействие](#содействие)
    - [Настройка среды разработки](#настройка-среды-разработки)
    - [Правила содействия](#правила-содействия)
    - [Области для содействия](#области-для-содействия)
  - [Лицензия](#лицензия)
  - [Контакты](#контакты)

## Возможности

- **Быстрые запросы к ИИ** - Получайте мгновенные ответы от моделей ИИ через командную строку
- **Интерактивный режим диалога** - Общайтесь с ИИ в режиме диалога с сохранением контекста беседы
- **Выполнение кода** - Выполняйте предложенные ИИ скрипты и команды
- **Дружелюбный интерфейс** - Форматированный вывод с подсветкой синтаксиса
- **Множество провайдеров ИИ** - Поддержка OpenAI, Anthropic и других провайдеров
- **Готова к локализации** - Поддержка нескольких языков (в разработке)


## Установка

### Linux (pipx)

**Рекомендуемый способ установки для Linux**

1. **Установите pipx** (если еще не установлен):
   ```bash
   sudo apt update
   sudo apt install pipx python3-venv -y
   pipx ensurepath
   ```

2. **Перезапустите терминал**

3. **Установите AI-eBash**:
   ```bash
   pipx install ai-ebash
   ```

> **Примечание:** Если pipx не работает, вы можете установить через pip:
> ```bash
> pip install ai-ebash
> ```

### Linux (DEB пакет)

1. **Скачайте последний DEB пакет**:
   ```bash
   wget -qO ai-ebash.deb $(wget -qO- https://api.github.com/repos/Vivatist/ai-ebash/releases/latest \
     | grep "browser_download_url.*\.deb" | cut -d '"' -f 4)
   ```

2. **Установите пакет**:
   ```bash
   sudo dpkg -i ./ai-ebash.deb
   sudo apt-get install -f -y
   ```

3. **Перезапустите терминал**

### Windows (Экспериментально)

1. **Установите Python 3.11+** (если еще не установлен)

2. **Установите AI-eBash**:
   ```cmd
   pip install ai-ebash
   ```

3. **Перезапустите терминал**

## Использование

### Базовое использование

```bash
# Простой вопрос
ai Какое сегодня число?

# Получить справку
ai --help
```

### Режим диалога

```bash
# Начать интерактивный разговор
ai -d "Помоги мне изучить Python"

# В режиме диалога вы можете:
# - Задавать уточняющие вопросы
# - Выполнять блоки кода, предложенные ИИ
# - Получать объяснения команд
```

### Выполнение кода

В режиме диалога ответы ИИ могут содержать исполняемые блоки кода:

```bash
ai -d Покажи как создать Python скрипт
```

Затем выполните предложенный код, введя номер блока:


[Код #1]
```python
print("Привет, Мир!")
```



## Конфигурация

### Первоначальная настройка

Запустите режим настройки для настройки провайдера ИИ:

```bash
ai -s
```

### Поддерживаемые провайдеры ИИ

- **OpenAI** (GPT-3.5, GPT-4)
- **Anthropic** (Claude)
- **OpenRouter** (Множество моделей)
- **Локальные модели** (Ollama, LM Studio)

### Файл конфигурации

Настройки хранятся в:
- **Linux:** `~/.config/ai-ebash/config.json`
- **Windows:** `%APPDATA%\ai-ebash\config.json`

## Безопасность

> ⚠️ **ПРЕДУПРЕЖДЕНИЕ:** Никогда не выполняйте код из ненадежных источников без проверки!


### Лучшие практики

1. **Проверяйте код перед выполнением**
   ```bash
   # Всегда проверяйте что предлагает ИИ
   ai "Удалить все файлы из /tmp"  # Не выполняйте это слепо!
   ```

2. **Используйте безопасные команды**
   ```bash
   # Предпочитайте эти вместо деструктивных операций
   ai Показать использование диска
   ai Показать запущенные процессы
   ```

## Содействие

Буду рад помощи! Вот как начать:

### Настройка среды разработки

1. **Форкните репозиторий**
2. **Клонируйте ваш форк**:
   ```bash
   git clone https://github.com/your-username/ai-ebash.git
   cd ai-ebash
   ```

3. **Настройте среду разработки**:
   ```bash
   python -m venv venv
   source venv/bin/activate  # На Windows: venv\Scripts\activate
   pip install -r requirements.txt
   pip install -e .
   ```

### Правила содействия

- 📝 **Стиль кода**: Следуйте PEP 8
- 🧪 **Тестирование**: Добавляйте тесты для новых функций
- 📚 **Документация**: Обновляйте README для новых функций
- 🔄 **Pull Requests**: Используйте понятные сообщения коммитов

### Области для содействия

- 🌍 **Локализация** - Добавьте поддержку новых языков
- 🤖 **Провайдеры ИИ** - Интегрируйте новые сервисы ИИ
- 🎨 **UI/UX** - Улучшите интерфейс терминала
- 📊 **Аналитика** - Добавьте статистику использования
- 🔧 **Инструменты** - Создайте дополнительные утилиты

## Лицензия

Этот проект лицензирован под MIT License.

## Контакты

- **Автор**: Andrey Bochkarev
- **Email**: andrey.bch.1976@gmail.com
- **GitHub Issues**: [Сообщить об ошибках или запросить функции](https://github.com/Vivatist/ai-ebash/issues)
- **Обсуждения**: [Присоединиться к обсуждениям сообщества](https://github.com/Vivatist/ai-ebash/discussions)

---

<div align="center">

**Создано с ❤️ для Linux сообщества**

[⭐ Поставьте звезду на GitHub](https://github.com/Vivatist/ai-ebash) • [🐛 Сообщить о проблемах](https://github.com/Vivatist/ai-ebash/issues) • [💬 Присоединиться к обсуждениям](https://github.com/Vivatist/ai-ebash/discussions)

</div>