import json
SCHEMAS = json.loads(r'''[{"$id":"apse/db/nist-jarvis/2024.3.13/atoms","$schema":"http://json-schema.org/draft-07/schema#","title":"NIST JARVIS Atoms schema","description":"NIST J.A.R.V.I.S. db entry `atoms` key schema. Based on https://figshare.com/articles/dataset/Monolayer_data_for_heterostructure/22344571","additionalProperties":false,"type":"object","properties":{"lattice_mat":{"type":"array","description":"Crystal lattice vectors as a 3x3 matrix, in Angstroms","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3},"coords":{"type":"array","description":"Atomic coordinates for each atom in the unit cell","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":1},"elements":{"type":"array","description":"Atomic elements for each atom in the unit cell in the same order as `coords`","items":{"type":"string"},"minItems":1},"abc":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"angles":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"cartesian":{"type":"boolean","description":"True if the coordinates are in Cartesian space, false if in fractional space"},"props":{"type":"array","items":{"type":"string"},"description":"Additional properties for each of the atoms"}}},{"$id":"apse/db/nist-jarvis/2024.3.13/db-entry","$schema":"http://json-schema.org/draft-07/schema#","title":"NIST JARVIS db entry schema","description":"NIST J.A.R.V.I.S. db entry `atoms` key schema. Based on https://figshare.com/articles/dataset/Monolayer_data_for_heterostructure/22344571","additionalProperties":true,"type":"object","properties":{"atoms":{"$schema":"http://json-schema.org/draft-07/schema#","title":"NIST JARVIS Atoms schema","description":"NIST J.A.R.V.I.S. db entry `atoms` key schema. Based on https://figshare.com/articles/dataset/Monolayer_data_for_heterostructure/22344571","additionalProperties":false,"type":"object","properties":{"lattice_mat":{"type":"array","description":"Crystal lattice vectors as a 3x3 matrix, in Angstroms","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3},"coords":{"type":"array","description":"Atomic coordinates for each atom in the unit cell","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":1},"elements":{"type":"array","description":"Atomic elements for each atom in the unit cell in the same order as `coords`","items":{"type":"string"},"minItems":1},"abc":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"angles":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"cartesian":{"type":"boolean","description":"True if the coordinates are in Cartesian space, false if in fractional space"},"props":{"type":"array","items":{"type":"string"},"description":"Additional properties for each of the atoms"}}},"jid":{"type":"string","description":"The id of the entry in the database, e.g. JVASP-677"}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/atomic-positions","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic positions schema","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1493","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["alat","bohr","angstrom","crystal","crystal_sg"],"default":"alat"},"values":{"type":"array","items":{"type":"object","additionalProperties":false,"properties":{"X":{"type":"string","description":"label of the atom as specified in ATOMIC_SPECIES"},"x":{"type":"number","description":"atomic positions"},"y":{"type":"number","description":"atomic positions"},"z":{"type":"number","description":"atomic positions"},"if_pos(1)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1},"if_pos(2)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1},"if_pos(3)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1}},"required":["x","y","z"]}}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/atomic-species","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic species schema","type":"object","additionalProperties":false,"properties":{"values":{"type":"array","items":{"type":"object","additionalProperties":false,"properties":{"X":{"type":"string","description":"label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in \"Xn\" (e.g. Fe1) or \"X_*\" or \"X-*\" (e.g. C1, C_h; max total length cannot exceed 3 characters)"},"Mass_X":{"type":"number","description":"mass of the atomic species [amu: mass of C = 12]. Used only when performing Molecular Dynamics run or structural optimization runs using Damped MD. Not actually used in all other cases (but stored in data files, so phonon calculations will use these values unless other values are provided)"},"PseudoPot_X":{"type":"string","description":"PseudoPot_X"}}}}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/cell","$schema":"http://json-schema.org/draft-07/schema#","title":"cell schema","type":"object","additionalProperties":false,"oneOf":[{"type":"object","additionalProperties":false,"properties":{"cell_dynamics":{"type":"string","enum":["none","sd","damp-pr","damp-w","bfgs"],"default":"bfgs","description":"CASE ( calculation == 'vc-relax' )"}}},{"type":"object","additionalProperties":false,"properties":{"cell_dynamics":{"type":"string","enum":["none","pr","w"],"description":"CASE ( calculation == 'vc-md' )"}}}],"properties":{"press":{"type":"number","description":"Target pressure [KBar] in a variable-cell md or relaxation run.","default":0},"wmass":{"type":"number","description":"Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD"},"cell_factor":{"type":"number","description":"Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise"},"press_conv_thr":{"type":"number","default":0.5,"description":"Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well)."},"cell_dofree":{"type":"string","enum":["all","ibrav","a","b","c","fixa","fixb","fixc","x","y","xy","xz","xyz","shape","volume","2Dxy","2Dshape","epitaxial_ab","epitaxial_ac","epitaxial_bc"],"default":"all","description":"Select which of the cell parameters should be moved"}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/cell-parameters","$schema":"http://json-schema.org/draft-07/schema#","title":"cell parameters schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["alat","bohr","angstrom"],"description":"label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in \"Xn\" (e.g. Fe1) or \"X_*\" or \"X-*\" (e.g. C1, C_h; max total length cannot exceed 3 characters)"},"values":{"type":"object","additionalProperties":false,"properties":{"v1":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"v2":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"v3":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}}}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/control","$schema":"http://json-schema.org/draft-07/schema#","title":"control schema","type":"object","additionalProperties":false,"properties":{"calculation":{"description":"A string describing the task to be performed","type":"string","enum":["scf","nscf","bands","relax","md","vc-relax","vc-md"],"default":"scf"},"title":{"description":"reprinted on output.","type":"string","default":""},"verbosity":{"description":"Currently two verbosity levels are implemented: high, low. 'debug' and 'medium' have the same effect as 'high'; 'default' and 'minimal' as 'low'","type":"string","enum":["high","low","debug","medium","minimal","default"],"default":"low"},"restart_mode":{"type":"string","enum":["from_scratch","restart"],"default":"from_scratch"},"wf_collect":{"type":"boolean","description":"OBSOLETE - NO LONGER IMPLEMENTED"},"nstep":{"description":"Default: 1 if calculation == 'scf', 'nscf', 'bands'; 50 for the other cases; Number of molecular-dynamics or structural optimization steps performed in this run. If set to 0, the code performs a quick \"dry run\", stopping just after initialization. This is useful to check for input correctness and to have the summary printed. NOTE: in MD calculations, the code will perform \"nstep\" steps even if restarting from a previously interrupted calculation.","type":"number","default":1},"iprint":{"description":"band energies are written every iprint iterations","type":"number"},"tstress":{"type":"boolean","default":false,"description":"calculate stress. It is set to .TRUE. automatically if calculation == 'vc-md' or 'vc-relax'"},"tprnfor":{"type":"boolean","description":"calculate forces. It is set to .TRUE. automatically if calculation == 'relax','md','vc-md'"},"dt":{"type":"number","description":"time step for molecular dynamics, in Rydberg atomic units (1 a.u.=4.8378 * 10^-17 s : beware, the CP code uses Hartree atomic units, half that much!!!)","default":20},"outdir":{"type":"string","description":"input, temporary, output files are found in this directory, see also wfcdir"},"wfcdir":{"type":"string","description":"This directory specifies where to store files generated by each processor (*.wfc{N}, *.igk{N}, etc.). Useful for machines without a parallel file system: set wfcdir to a local file system, while outdir should be a parallel or network file system, visible to all processors. Beware: in order to restart from interrupted runs, or to perform further calculations using the produced data files, you may need to copy files to outdir. Works only for pw.x."},"prefix":{"type":"string","description":"prepended to input/output filenames: prefix.wfc, prefix.rho, etc.","default":"pwscf"},"lkpoint_dir":{"type":"boolean","description":"OBSOLETE - NO LONGER IMPLEMENTED"},"max_seconds":{"type":"number","default":10000000,"description":"Jobs stops after max_seconds CPU time. Use this option in conjunction with option restart_mode if you need to split a job too long to complete into shorter jobs that fit into your batch queues."},"etot_conv_thr":{"type":"number","default":0.0001,"description":"Convergence threshold on total energy (a.u) for ionic minimization: the convergence criterion is satisfied when the total energy changes less than etot_conv_thr between two consecutive scf steps. Note that etot_conv_thr is extensive, like the total energy. See also forc_conv_thr - both criteria must be satisfied"},"forc_conv_thr":{"type":"number","default":0.001,"description":"Convergence threshold on forces (a.u) for ionic minimization: the convergence criterion is satisfied when all components of all forces are smaller than forc_conv_thr. See also etot_conv_thr - both criteria must be satisfied"},"disk_io":{"type":"string","enum":["high","medium","low","nowf","none"],"description":"Specifies the amount of disk I/O activity: (only for binary files and xml data file in data directory; other files printed at each molecular dynamics / structural optimization step are not controlled by this option )"},"pseudo_dir":{"type":"string","description":"directory containing pseudopotential files. Default: value of the $ESPRESSO_PSEUDO environment variable if set; '$HOME/espresso/pseudo/' otherwise"},"tefield":{"type":"boolean","default":false,"description":"If .TRUE. a saw-like potential simulating an electric field is added to the bare ionic potential. See variables edir, eamp, emaxpos, eopreg for the form and size of the added potential."},"dipfield":{"type":"boolean","default":false,"description":"If .TRUE. and tefield==.TRUE. a dipole correction is also added to the bare ionic potential - implements the recipe of L. Bengtsson, PRB 59, 12301 (1999). See variables edir, emaxpos, eopreg for the form of the correction. Must be used ONLY in a slab geometry, for surface calculations, with the discontinuity FALLING IN THE EMPTY SPACE."},"lelfield":{"type":"boolean","default":false,"description":"If .TRUE. a homogeneous finite electric field described through the modern theory of the polarization is applied. This is different from tefield == .true. !"},"nberrycyc":{"type":"integer","default":1,"description":"In the case of a finite electric field  ( lelfield == .TRUE. ) it defines the number of iterations for converging the wavefunctions in the electric field Hamiltonian, for each external iteration on the charge density"},"lorbm":{"type":"boolean","default":false,"description":"If .TRUE. perform orbital magnetization calculation."},"lberry":{"type":"boolean","default":false,"description":"If .TRUE. perform a Berry phase calculation. See the header of PW/src/bp_c_phase.f90 for documentation"},"gdir":{"type":"number","description":"For Berry phase calculation: direction of the k-point strings in reciprocal space. Allowed values: 1, 2, 3 1=first, 2=second, 3=third reciprocal lattice vector For calculations with finite electric fields (lelfield==.true.) \"gdir\" is the direction of the field."},"nppstr":{"type":"number","description":"For Berry phase calculation: number of k-points to be calculated along each symmetry-reduced string. The same for calculation with finite electric fields (lelfield==.true.)."},"gate":{"type":"boolean","default":false,"description":"In the case of charged cells (tot_charge .ne. 0) setting gate = .TRUE. represents the counter charge (i.e. -tot_charge) not by a homogeneous background charge but with a charged plate, which is placed at zgate (see below). Details of the gate potential can be found in T. Brumme, M. Calandra, F. Mauri; PRB 89, 245406 (2014). Note, that in systems which are not symmetric with respect to the plate, one needs to enable the dipole correction! (dipfield=.true.). Currently, symmetry can be used with gate=.true. but carefully check that no symmetry is included which maps z to -z even if in principle one could still use them for symmetric systems (i.e. no dipole correction). For nosym=.false. verbosity is set to 'high'. Note: this option was called \"monopole\" in v6.0 and 6.1 of pw.x"},"twochem":{"type":"boolean","default":false,"description":"IF .TRUE. , a two chemical potential calculation for the simulation of photoexcited systems is performed, constraining a fraction of the electrons in the conduction manifold."},"lfcp":{"type":"boolean","default":false,"description":"If .TRUE. perform a constant bias potential (constant-mu) calculation for a system with ESM method. See the header of PW/src/fcp_module.f90 for documentation. To perform the calculation, you must set a namelist FCP."},"trism":{"type":"boolean","default":false,"description":"If .TRUE. perform a 3D-RISM-SCF calculation [for details see H.Sato et al., JCP 112, 9463 (2000), doi:10.1063/1.481564]. The solvent's distributions are calculated by 3D-RISM, though solute is treated as SCF. The charge density and the atomic positions are optimized, simultaneously with the solvents. To perform the calculation, you must set a namelist RISM and a card SOLVENTS. If assume_isolated = 'esm' and esm_bc = 'bc1', Laue-RISM is calculated instead of 3D-RISM and coupled with ESM method (i.e. ESM-RISM). [for details see S.Nishihara and M.Otani, PRB 96, 115429 (2017)]. The default of mixing_beta is 0.2 for both 3D-RISM and Laue-RISM. For structural relaxation with BFGS, ignore_wolfe is always .TRUE. ."}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/electrons","$schema":"http://json-schema.org/draft-07/schema#","title":"electrons schema","type":"object","additionalProperties":false,"properties":{"electron_maxstep":{"type":"integer","default":100,"description":"maximum number of iterations in a scf step. If exact exchange is active, this will affect the inner loops."},"exx_maxstep":{"type":"integer","default":100,"description":"maximum number of outer iterations in a scf calculation with exact exchange."},"scf_must_converge":{"type":"boolean","default":true,"description":"If .false. do not stop molecular dynamics or ionic relaxation when electron_maxstep is reached. Use with care."},"conv_thr":{"type":"number"},"adaptive_thr":{"type":"boolean","default":false,"description":"If .TRUE. this turns on the use of an adaptive conv_thr for the inner scf loops when using EXX."},"conv_thr_init":{"type":"number","description":"When adaptive_thr = .TRUE. this is the convergence threshold used for the first scf cycle."},"conv_thr_multi":{"type":"number","description":"When adaptive_thr = .TRUE. the convergence threshold for each scf cycle is given by: max( conv_thr, conv_thr_multi * dexx )"},"mixing_mode":{"type":"string","enum":["plain","TF","local-TF"],"default":"plain"},"mixing_beta":{"type":"number","description":"mixing factor for self-consistency"},"mixing_ndim":{"type":"integer","default":8,"description":"number of iterations used in mixing scheme"},"mixing_fixed_ns":{"type":"integer","default":0,"description":"For DFT+U : number of iterations with fixed ns ( ns is the atomic density appearing in the Hubbard term )."},"diagonalization":{"type":"string","enum":["david","cg","ppcg","paro","ParO","rmm-davidson","rmm-paro"],"default":"david"},"diago_thr_init":{"type":"number","description":"Convergence threshold (ethr) for iterative diagonalization (the check is on eigenvalue convergence)."},"diago_cg_maxiter":{"type":"integer","description":"For conjugate gradient diagonalization:  max number of iterations"},"diago_ppcg_maxiter":{"type":"integer","description":"For ppcg diagonalization:  max number of iterations"},"diago_david_ndim":{"type":"integer","default":2,"description":"For Davidson diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed)."},"diago_rmm_ndim":{"type":"integer","default":4,"description":"For RMM-DIIS diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed)."},"diago_rmm_conv":{"type":"boolean","default":false,"description":"If .TRUE., RMM-DIIS is performed up to converge. If .FALSE., RMM-DIIS is performed only once."},"diago_gs_nblock":{"type":"integer","default":16,"description":"For RMM-DIIS diagonalization: blocking size of Gram-Schmidt orthogonalization"},"diago_full_acc":{"type":"boolean","default":false,"description":"If .TRUE. all the empty states are diagonalized at the same level of accuracy of the occupied ones. Otherwise the empty states are diagonalized using a larger threshold (this should not affect total energy, forces, and other ground-state properties)."},"efield":{"type":"number","description":"Amplitude of the finite electric field (in Ry a.u.; 1 a.u. = 36.3609*10^10 V/m). Used only if lelfield==.TRUE. and if k-points (K_POINTS card) are not automatic."},"efield_cart":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"efield_phase":{"type":"string","enum":["read","write","none"],"default":"none"},"startingpot":{"type":"string","enum":["atomic","file"]},"startingwfc":{"type":"string","enum":["atomic","atomic+random","random","file"],"default":"atomic+random"},"tqr":{"type":"boolean","default":false,"description":"If .true., use a real-space algorithm for augmentation charges of ultrasoft pseudopotentials and PAWsets. Faster but numerically less accurate than the default G-space algorithm. Use with care and after testing!"},"real_space":{"type":"boolean","default":false,"description":"If .true., exploit real-space localization to compute matrix elements for nonlocal projectors. Faster and in principle better scaling than the default G-space algorithm, but numerically less accurate, may lead to some loss of translational invariance. Use with care and after testing!"}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/hubbard","$schema":"http://json-schema.org/draft-07/schema#","title":"hubbard schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["atomic","ortho-atomic","norm-atomic","wf","pseudo"]},"values":{"oneOf":[{"description":"IF DFT+U","type":"array","items":{"oneOf":[{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1764","additionalProperties":false,"properties":{"U":{"type":"string","enum":["U"],"description":"string constant \"U\"; indicates the specs for the U parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"u_val":{"type":"number","description":"value of the U parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1784","additionalProperties":false,"properties":{"J0":{"type":"string","enum":["J0"],"description":"string constant \"J0\"; indicates the specs for the J0 parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"j0_val":{"type":"number","description":"value of the J0 parameter (in eV)"}}}]}},{"description":"IF DFT+U+J","type":"array","items":{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1817","additionalProperties":false,"properties":{"paramType":{"type":"string","enum":["U","J","B","E2","E3"],"description":"character describing the type of Hubbard parameter allowed values: U, J and either B (for d-orbitals) or E2 and E3 (for f-orbitals)"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"paramValue":{"type":"number","description":"value of the J0 parameter (in eV)"}}}},{"description":"IF DFT+U+V","type":"array","items":{"oneOf":[{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1847","additionalProperties":false,"properties":{"U":{"type":"string","enum":["U"],"description":"string constant \"U\"; indicates the specs for the U parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"u_val":{"type":"number","description":"value of the U parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1865","additionalProperties":false,"properties":{"J0":{"type":"string","enum":["J0"],"description":"string constant \"J0\"; indicates the specs for the J0 parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"j0_val":{"type":"number","description":"value of the J0 parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1884","additionalProperties":false,"properties":{"V":{"type":"string","enum":["V"],"description":"string constant \"V\"; indicates the specs for the V parameter will be given"},"label(I)":{"type":"string","description":"label of the atom I (as defined in ATOMIC_SPECIES)"},"manifold(I)":{"type":"string","description":"specs of the manifold for atom I (e.g., 3d, 2p...)"},"label(J)":{"type":"string","description":"label of the atom J (as defined in ATOMIC_SPECIES)"},"manifold(J)":{"type":"string","description":"specs of the manifold for atom J (e.g., 3d, 2p...)"},"I":{"type":"integer","description":"index of the atom I"},"J":{"type":"integer","description":"index of the atom J"},"v_val(I,J)":{"type":"number","description":"value of the V parameter for the atom pair I,J (in eV)"}}}]}}]}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/ions","$schema":"http://json-schema.org/draft-07/schema#","title":"ions schema","type":"object","additionalProperties":false,"oneOf":[{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["bfgs","damp","fire"],"default":"bfgs","description":"CASE: calculation == 'relax'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["verlet","langevin","langevin-smc"],"default":"verlet","description":"CASE: calculation == 'md'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["bfgs","damp"],"default":"bfgs","description":"CASE: calculation == 'vc-relax'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["beeman"],"default":"beeman","description":"CASE: calculation == 'vc-md'"}}}],"properties":{"ion_positions":{"type":"string","enum":["default","from_input"],"default":"default"},"ion_velocities":{"type":"string","enum":["default","from_input"],"default":"default"},"pot_extrapolation":{"type":"string","enum":["none","atomic","first_order","second_order"],"default":"atomic","description":"Used to extrapolate the potential from preceding ionic steps."},"wfc_extrapolation":{"type":"string","enum":["none","first_order","second_order"],"default":"none","description":"Used to extrapolate the wavefunctions from preceding ionic steps."},"remove_rigid_rot":{"type":"boolean","default":false,"description":"This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells."},"ion_temperature":{"type":"string","enum":["rescaling","rescale-v","rescale-T","reduce-T","berendsen","andersen","svr","initial","not_controlled"],"default":"not_controlled"},"tempw":{"type":"number","description":"Starting temperature (Kelvin) in MD runs target temperature for most thermostats.","default":300},"tolp":{"type":"number","description":"Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.","default":100},"delta_t":{"type":"number","default":1},"nraise":{"type":"integer","default":1},"refold_pos":{"type":"boolean","default":false,"description":"This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell."},"upscale":{"type":"number","description":"Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.","default":100},"bfgs_ndim":{"type":"integer","default":1,"description":"Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm."},"trust_radius_max":{"type":"number","description":"Maximum ionic displacement in the structural relaxation. (bfgs only)","default":0.8},"trust_radius_min":{"type":"number","description":"Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)","default":0.001},"trust_radius_ini":{"type":"number","description":"Initial ionic displacement in the structural relaxation. (bfgs only)","default":0.5},"w_1":{"type":"number","default":0.01},"w_2":{"type":"number","description":"Parameters used in line search based on the Wolfe conditions. (bfgs only)","default":0.5},"fire_alpha_init":{"type":"number","description":"Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3","default":0.2},"fire_falpha":{"type":"number","description":"Scaling of the alpha mixing parameter for steps with P > 0;","default":0.99},"fire_nmin":{"type":"integer","default":5,"description":"Minimum number of steps with P > 0 before increase of dt"},"fire_f_inc":{"type":"number","description":"Factor for increasing dt","default":1.1},"fire_f_dec":{"type":"number","description":"Factor for decreasing dt","default":0.5},"fire_dtmax":{"type":"number","description":"Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt","default":10}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/k-points","$schema":"http://json-schema.org/draft-07/schema#","title":"k points schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["tpiba","automatic","crystal","gamma","tpiba_b","crystal_b","tpiba_c","crystal_c"]},"values":{"oneOf":[{"type":"array","description":"K_POINTS tpiba | crystal | tpiba_b | crystal_b | tpiba_c | crystal_c","items":{"type":"object","additionalProperties":false,"properties":{"nks":{"type":"integer","description":"Number of supplied special k-points."},"xk_x":{"type":"number"},"xk_y":{"type":"number"},"xk_z":{"type":"number"},"wk":{"type":"number"}}}},{"type":"object","description":"K_POINTS automatic","additionalProperties":false,"properties":{"nk1":{"type":"integer","description":"Number of supplied special k-points."},"nk2":{"type":"integer","description":"Number of supplied special k-points."},"nk3":{"type":"integer","description":"Number of supplied special k-points."},"sk1":{"type":"integer","description":"Number of supplied special k-points."},"sk2":{"type":"integer","description":"Number of supplied special k-points."},"sk3":{"type":"integer","description":"Number of supplied special k-points."}}},{"type":"null","description":"K_POINTS gamma"}]}}},{"$id":"apse/file/applications/espresso/7.2/pw.x/system","$schema":"http://json-schema.org/draft-07/schema#","title":"system schema","type":"object","additionalProperties":false,"anyOf":[{"properties":{"celldm":{"type":"array","items":{"type":"number"},"minItems":6,"maxItems":6}}},{"properties":{"A":{"type":"number"},"B":{"type":"number"},"C":{"type":"number"},"cosAB":{"type":"number"},"cosAC":{"type":"number"},"cosBC":{"type":"number"}}}],"properties":{"ibrav":{"type":"integer"},"nat":{"type":"integer","description":"number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)"},"ntyp":{"type":"integer","description":"number of types of atoms in the unit cell"},"nbnd":{"type":"integer","description":"Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)"},"nbnd_cond":{"type":"integer","description":"Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case."},"tot_charge":{"type":"number","default":0},"starting_charge":{"type":"number","default":0,"description":"starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'."},"tot_magnetization":{"type":"number","default":-10000,"description":"Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle."},"starting_magnetization":{"type":"array","items":{"type":"number","default":0,"minimum":-1,"maximum":1}},"ecutwfc":{"type":"number","description":"kinetic energy cutoff (Ry) for wavefunctions"},"ecutrho":{"type":"number","description":"Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc"},"ecutfock":{"type":"number","description":"Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials."},"nr1":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr2":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr3":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr1s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nr2s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nr3s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nosym":{"type":"boolean","default":false},"nosym_evc":{"type":"boolean","default":false},"noinv":{"type":"boolean","default":false,"description":"if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation"},"no_t_rev":{"type":"boolean","default":false,"description":"if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal."},"force_symmorphic":{"type":"boolean","default":false,"description":"if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation"},"use_all_frac":{"type":"boolean","default":false},"occupations":{"type":"string","enum":["smearing","tetrahedra","tetrahedra_lin","tetrahedra_opt","fixed","from_input"]},"one_atom_occupations":{"type":"boolean","default":false},"starting_spin_angle":{"type":"boolean","default":false},"degauss_cond":{"type":"number","default":0,"description":"value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.)."},"nelec_cond":{"type":"number","default":0,"description":"Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold."},"degauss":{"type":"number","default":0,"description":"value of the gaussian spreading (Ry) for brillouin-zone integration in metals."},"smearing":{"type":"string","enum":["gaussian","gauss","methfessel-paxton","m-p","mp","marzari-vanderbilt","cold","m-v","mv","fermi-dirac","f-d","fd"],"default":"gaussian"},"nspin":{"type":"integer","default":1},"sic_gamma":{"type":"number","default":0,"description":"Strength of the gammaDFT potential."},"pol_type":{"type":"string","enum":["e","h"],"description":"Type of polaron in gammaDFT."},"sic_energy":{"type":"boolean","default":false,"description":"Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost."},"sci_vb":{"type":"number","default":0,"description":"Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted."},"sci_cb":{"type":"number","default":0,"description":"Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted."},"noncolin":{"type":"boolean","default":false,"description":"if .true. the program will perform a noncollinear calculation."},"ecfixed":{"type":"number","default":0},"qcutz":{"type":"number","default":0},"q2sigma":{"type":"number","default":0.1},"input_dft":{"type":"string","description":"Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!"},"ace":{"type":"boolean","default":true,"description":"Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092"},"exx_fraction":{"type":"number","description":"Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20."},"screening_parameter":{"type":"number","default":0.106,"description":"screening_parameter for HSE like hybrid functionals."},"exxdiv_treatment":{"type":"string","default":"gygi-baldereschi","enum":["gygi-baldereschi","vcut_spherical","vcut_ws","none"]},"x_gamma_extrapolation":{"type":"boolean","default":true,"description":"Specific for EXX. If .true., extrapolate the G=0 term of the potential"},"ecutvcut":{"type":"number","description":"Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors."},"nqx1":{"type":"integer","default":0,"description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"nqx2":{"type":"integer","description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"nqx3":{"type":"integer","description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"localization_thr":{"type":"number","default":0,"description":"Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation"},"Hubbard_occ":{"type":"array","items":{"type":"array","items":[{"type":"integer","minimum":1},{"type":"integer","minimum":1,"maximum":3},{"type":"number"}],"minItems":3,"maxItems":3}},"Hubbard_alpha":{"type":"array","items":{"type":"number","default":0}},"Hubbard_beta":{"type":"array","items":{"type":"number","default":0}},"starting_ns_eigenvalue":{"type":"array","items":{"type":"array","items":{"type":"array","items":{"type":"number"}}}},"dmft":{"type":"boolean","default":false,"description":"If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1."},"dmft_prefix":{"type":"string","description":"prepended to hdf5 archive: dmft_prefix.h5"},"ensemble_energies":{"type":"boolean","default":false,"description":"If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation."},"edir":{"type":"integer","description":"The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE."},"emaxpos":{"type":"number","default":0.5,"description":"Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE."},"eopreg":{"type":"number","default":0.1,"description":"Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE."},"eamp":{"type":"number","default":0.001},"angle1":{"type":"array","items":{"type":"number"},"maxItems":1,"minItems":1,"description":"The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types."},"angle2":{"type":"array","items":{"type":"number"},"maxItems":1,"minItems":1,"description":"The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only."},"lforcet":{"type":"boolean","description":"When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1"},"constrained_magnetization":{"type":"string","enum":["none","total","atomic","total direction","atomic direction"],"default":"none","description":"Used to perform constrained calculations in magnetic systems."},"fixed_magnetization":{"type":"array","items":{"type":"number","default":0},"maxItems":3,"minItems":3},"lambda":{"type":"number","default":1,"description":"parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda"},"report":{"type":"integer","default":-1,"description":"determines when atomic magnetic moments are printed on output"},"lspinorb":{"type":"boolean","description":"if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit."},"assume_isolated":{"type":"string","enum":["none","makov-payne","m-p","mp","martyna-tuckerman","m-t","mt","esm","2D"],"default":"none","description":"Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)"},"esm_bc":{"type":"string","enum":["pbc","bc1","bc2","bc3"],"default":"pbc","description":"If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab."},"esm_w":{"type":"number","default":0,"description":"If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] )."},"esm_efield":{"type":"number","default":0,"description":"If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes."},"esm_nfit":{"type":"integer","default":4,"description":"If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge."},"lgcscf":{"type":"boolean","default":false,"description":"If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF."},"gcscf_mu":{"type":"number","description":"The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge"},"gcscf_conv_thr":{"type":"number","default":0.01,"description":"Convergence threshold of Fermi energy (eV) for GC-SCF."},"gcscf_beta":{"type":"number","default":0.05,"description":"Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite."},"vdw_corr":{"type":"string","enum":["none","grimme-d2","Grimme-D2","DFT-D","dft-d","grimme-d3","Grimme-D3","DFT-D3","dft-d3","TS","ts","ts-vdw","ts-vdW","tkatchenko-scheffler","MBD","mbd","many-body-dispersion","mbd_vdw","XDM","xdm"],"default":"none","description":"Type of Van der Waals correction"},"london":{"type":"boolean","default":false,"description":"OBSOLESCENT, same as vdw_corr='DFT-D'"},"london_s6":{"type":"number","default":0.75,"description":"global scaling parameter for DFT-D. Default is good for PBE."},"london_c6":{"type":"number","description":"atomic C6 coefficient of each atom type"},"london_rvdw":{"type":"number","description":"atomic vdw radii of each atom type"},"london_rcut":{"type":"number","default":200,"description":"cutoff radius (a.u.) for dispersion interactions"},"dftd3_version":{"type":"integer","default":3,"minimum":2,"maximum":6,"description":"Version of Grimme implementation of Grimme-D3"},"dftd3_threebody":{"type":"boolean","default":true,"description":"Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled."},"ts_vdw_econv_thr":{"type":"number","default":0.000001,"description":"Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it"},"ts_vdw_isolated":{"type":"boolean","default":false,"description":"Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system."},"xdm":{"type":"boolean","default":false,"description":"OBSOLESCENT, same as vdw_corr='xdm'"},"xdm_a1":{"type":"number","default":0.6836,"description":"Damping function parameter a1 (adimensional)"},"xdm_a2":{"type":"number","default":1.5045,"description":"Damping function parameter a2 (angstrom)"},"space_group":{"type":"integer","default":0,"description":"The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)"},"uniqueb":{"type":"boolean","default":false,"description":"Used only for monoclinic lattices"},"origin_choice":{"type":"integer","default":1,"description":"Used only for space groups that in the ITA allow the use of two different origins"},"rhombohedral":{"type":"boolean","default":true,"description":"Used only for rhombohedral space groups."},"zgate":{"type":"number","default":0.5,"description":"used only if gate = .TRUE."},"relaxz":{"type":"boolean","default":false,"description":"used only if gate = .TRUE."},"block":{"type":"boolean","default":false,"description":"used only if gate = .TRUE."},"block_1":{"type":"number","default":0.45,"description":"used only if gate = .TRUE. and block = .TRUE."},"block_2":{"type":"number","default":0.55,"description":"used only if gate = .TRUE. and block = .TRUE."},"block_height":{"type":"number","default":0.1,"description":"used only if gate = .TRUE. and block = .TRUE."},"nextffield":{"type":"integer","default":0,"description":"Number of activated external ionic force fields."}},"required":["ibrav","nat","ntyp","ecutwfc"]},{"$id":"apse/file/applications/espresso/7.2/pw.x","$schema":"http://json-schema.org/draft-07/schema#","title":"pwx main schema","additionalProperties":false,"type":"object","properties":{"&CONTROL":{"$schema":"http://json-schema.org/draft-07/schema#","title":"control schema","type":"object","additionalProperties":false,"properties":{"calculation":{"description":"A string describing the task to be performed","type":"string","enum":["scf","nscf","bands","relax","md","vc-relax","vc-md"],"default":"scf"},"title":{"description":"reprinted on output.","type":"string","default":""},"verbosity":{"description":"Currently two verbosity levels are implemented: high, low. 'debug' and 'medium' have the same effect as 'high'; 'default' and 'minimal' as 'low'","type":"string","enum":["high","low","debug","medium","minimal","default"],"default":"low"},"restart_mode":{"type":"string","enum":["from_scratch","restart"],"default":"from_scratch"},"wf_collect":{"type":"boolean","description":"OBSOLETE - NO LONGER IMPLEMENTED"},"nstep":{"description":"Default: 1 if calculation == 'scf', 'nscf', 'bands'; 50 for the other cases; Number of molecular-dynamics or structural optimization steps performed in this run. If set to 0, the code performs a quick \"dry run\", stopping just after initialization. This is useful to check for input correctness and to have the summary printed. NOTE: in MD calculations, the code will perform \"nstep\" steps even if restarting from a previously interrupted calculation.","type":"number","default":1},"iprint":{"description":"band energies are written every iprint iterations","type":"number"},"tstress":{"type":"boolean","default":false,"description":"calculate stress. It is set to .TRUE. automatically if calculation == 'vc-md' or 'vc-relax'"},"tprnfor":{"type":"boolean","description":"calculate forces. It is set to .TRUE. automatically if calculation == 'relax','md','vc-md'"},"dt":{"type":"number","description":"time step for molecular dynamics, in Rydberg atomic units (1 a.u.=4.8378 * 10^-17 s : beware, the CP code uses Hartree atomic units, half that much!!!)","default":20},"outdir":{"type":"string","description":"input, temporary, output files are found in this directory, see also wfcdir"},"wfcdir":{"type":"string","description":"This directory specifies where to store files generated by each processor (*.wfc{N}, *.igk{N}, etc.). Useful for machines without a parallel file system: set wfcdir to a local file system, while outdir should be a parallel or network file system, visible to all processors. Beware: in order to restart from interrupted runs, or to perform further calculations using the produced data files, you may need to copy files to outdir. Works only for pw.x."},"prefix":{"type":"string","description":"prepended to input/output filenames: prefix.wfc, prefix.rho, etc.","default":"pwscf"},"lkpoint_dir":{"type":"boolean","description":"OBSOLETE - NO LONGER IMPLEMENTED"},"max_seconds":{"type":"number","default":10000000,"description":"Jobs stops after max_seconds CPU time. Use this option in conjunction with option restart_mode if you need to split a job too long to complete into shorter jobs that fit into your batch queues."},"etot_conv_thr":{"type":"number","default":0.0001,"description":"Convergence threshold on total energy (a.u) for ionic minimization: the convergence criterion is satisfied when the total energy changes less than etot_conv_thr between two consecutive scf steps. Note that etot_conv_thr is extensive, like the total energy. See also forc_conv_thr - both criteria must be satisfied"},"forc_conv_thr":{"type":"number","default":0.001,"description":"Convergence threshold on forces (a.u) for ionic minimization: the convergence criterion is satisfied when all components of all forces are smaller than forc_conv_thr. See also etot_conv_thr - both criteria must be satisfied"},"disk_io":{"type":"string","enum":["high","medium","low","nowf","none"],"description":"Specifies the amount of disk I/O activity: (only for binary files and xml data file in data directory; other files printed at each molecular dynamics / structural optimization step are not controlled by this option )"},"pseudo_dir":{"type":"string","description":"directory containing pseudopotential files. Default: value of the $ESPRESSO_PSEUDO environment variable if set; '$HOME/espresso/pseudo/' otherwise"},"tefield":{"type":"boolean","default":false,"description":"If .TRUE. a saw-like potential simulating an electric field is added to the bare ionic potential. See variables edir, eamp, emaxpos, eopreg for the form and size of the added potential."},"dipfield":{"type":"boolean","default":false,"description":"If .TRUE. and tefield==.TRUE. a dipole correction is also added to the bare ionic potential - implements the recipe of L. Bengtsson, PRB 59, 12301 (1999). See variables edir, emaxpos, eopreg for the form of the correction. Must be used ONLY in a slab geometry, for surface calculations, with the discontinuity FALLING IN THE EMPTY SPACE."},"lelfield":{"type":"boolean","default":false,"description":"If .TRUE. a homogeneous finite electric field described through the modern theory of the polarization is applied. This is different from tefield == .true. !"},"nberrycyc":{"type":"integer","default":1,"description":"In the case of a finite electric field  ( lelfield == .TRUE. ) it defines the number of iterations for converging the wavefunctions in the electric field Hamiltonian, for each external iteration on the charge density"},"lorbm":{"type":"boolean","default":false,"description":"If .TRUE. perform orbital magnetization calculation."},"lberry":{"type":"boolean","default":false,"description":"If .TRUE. perform a Berry phase calculation. See the header of PW/src/bp_c_phase.f90 for documentation"},"gdir":{"type":"number","description":"For Berry phase calculation: direction of the k-point strings in reciprocal space. Allowed values: 1, 2, 3 1=first, 2=second, 3=third reciprocal lattice vector For calculations with finite electric fields (lelfield==.true.) \"gdir\" is the direction of the field."},"nppstr":{"type":"number","description":"For Berry phase calculation: number of k-points to be calculated along each symmetry-reduced string. The same for calculation with finite electric fields (lelfield==.true.)."},"gate":{"type":"boolean","default":false,"description":"In the case of charged cells (tot_charge .ne. 0) setting gate = .TRUE. represents the counter charge (i.e. -tot_charge) not by a homogeneous background charge but with a charged plate, which is placed at zgate (see below). Details of the gate potential can be found in T. Brumme, M. Calandra, F. Mauri; PRB 89, 245406 (2014). Note, that in systems which are not symmetric with respect to the plate, one needs to enable the dipole correction! (dipfield=.true.). Currently, symmetry can be used with gate=.true. but carefully check that no symmetry is included which maps z to -z even if in principle one could still use them for symmetric systems (i.e. no dipole correction). For nosym=.false. verbosity is set to 'high'. Note: this option was called \"monopole\" in v6.0 and 6.1 of pw.x"},"twochem":{"type":"boolean","default":false,"description":"IF .TRUE. , a two chemical potential calculation for the simulation of photoexcited systems is performed, constraining a fraction of the electrons in the conduction manifold."},"lfcp":{"type":"boolean","default":false,"description":"If .TRUE. perform a constant bias potential (constant-mu) calculation for a system with ESM method. See the header of PW/src/fcp_module.f90 for documentation. To perform the calculation, you must set a namelist FCP."},"trism":{"type":"boolean","default":false,"description":"If .TRUE. perform a 3D-RISM-SCF calculation [for details see H.Sato et al., JCP 112, 9463 (2000), doi:10.1063/1.481564]. The solvent's distributions are calculated by 3D-RISM, though solute is treated as SCF. The charge density and the atomic positions are optimized, simultaneously with the solvents. To perform the calculation, you must set a namelist RISM and a card SOLVENTS. If assume_isolated = 'esm' and esm_bc = 'bc1', Laue-RISM is calculated instead of 3D-RISM and coupled with ESM method (i.e. ESM-RISM). [for details see S.Nishihara and M.Otani, PRB 96, 115429 (2017)]. The default of mixing_beta is 0.2 for both 3D-RISM and Laue-RISM. For structural relaxation with BFGS, ignore_wolfe is always .TRUE. ."}}},"&SYSTEM":{"$schema":"http://json-schema.org/draft-07/schema#","title":"system schema","type":"object","additionalProperties":false,"anyOf":[{"properties":{"celldm":{"type":"array","items":{"type":"number"},"minItems":6,"maxItems":6}}},{"properties":{"A":{"type":"number"},"B":{"type":"number"},"C":{"type":"number"},"cosAB":{"type":"number"},"cosAC":{"type":"number"},"cosBC":{"type":"number"}}}],"properties":{"ibrav":{"type":"integer"},"nat":{"type":"integer","description":"number of atoms in the unit cell (ALL atoms, except if space_group is set, in which case, INEQUIVALENT atoms)"},"ntyp":{"type":"integer","description":"number of types of atoms in the unit cell"},"nbnd":{"type":"integer","description":"Default: for an insulator, nbnd = number of valence bands (nbnd = # of electrons /2); for a metal, 20% more (minimum 4 more)"},"nbnd_cond":{"type":"integer","description":"Default: nbnd_cond = nbnd - # of electrons / 2 in the collinear case; nbnd_cond = nbnd - # of electrons in the noncollinear case."},"tot_charge":{"type":"number","default":0},"starting_charge":{"type":"number","default":0,"description":"starting charge on atomic type 'i', to create starting potential with startingpot = 'atomic'."},"tot_magnetization":{"type":"number","default":-10000,"description":"Total majority spin charge - minority spin charge. Used to impose a specific total electronic magnetization. If unspecified then tot_magnetization variable is ignored and the amount of electronic magnetization is determined during the self-consistent cycle."},"starting_magnetization":{"type":"array","items":{"type":"number","default":0,"minimum":-1,"maximum":1}},"ecutwfc":{"type":"number","description":"kinetic energy cutoff (Ry) for wavefunctions"},"ecutrho":{"type":"number","description":"Kinetic energy cutoff (Ry) for charge density and potential For norm-conserving pseudopotential you should stick to the default value, you can reduce it by a little but it will introduce noise especially on forces and stress. Default: 4 * ecutwfc"},"ecutfock":{"type":"number","description":"Kinetic energy cutoff (Ry) for the exact exchange operator in EXX type calculations. By default this is the same as ecutrho but in some EXX calculations, a significant speed-up can be obtained by reducing ecutfock, at the expense of some loss in accuracy. Must be .gt. ecutwfc. Not implemented for stress calculation and for US-PP and PAW pseudopotentials."},"nr1":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr2":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr3":{"type":"integer","description":"Three-dimensional FFT mesh (hard grid) for charge density (and scf potential). If not specified the grid is calculated based on the cutoff for charge density (see also ecutrho)"},"nr1s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nr2s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nr3s":{"type":"integer","description":"Three-dimensional mesh for wavefunction FFT and for the smooth part of charge density ( smooth grid ). Coincides with nr1, nr2, nr3 if ecutrho = 4 * ecutwfc ( default )"},"nosym":{"type":"boolean","default":false},"nosym_evc":{"type":"boolean","default":false},"noinv":{"type":"boolean","default":false,"description":"if (.TRUE.) disable the usage of k => -k symmetry (time reversal) in k-point generation"},"no_t_rev":{"type":"boolean","default":false,"description":"if (.TRUE.) disable the usage of magnetic symmetry operations that consist in a rotation + time reversal."},"force_symmorphic":{"type":"boolean","default":false,"description":"if (.TRUE.) force the symmetry group to be symmorphic by disabling symmetry operations having an associated fractionary translation"},"use_all_frac":{"type":"boolean","default":false},"occupations":{"type":"string","enum":["smearing","tetrahedra","tetrahedra_lin","tetrahedra_opt","fixed","from_input"]},"one_atom_occupations":{"type":"boolean","default":false},"starting_spin_angle":{"type":"boolean","default":false},"degauss_cond":{"type":"number","default":0,"description":"value of the gaussian spreading (Ry) for brillouin-zone integration in the conduction manifold in a two-chemical potential calculation (twochem=.true.)."},"nelec_cond":{"type":"number","default":0,"description":"Number of electrons placed in the conduction manifold in a two-chemical potential calculation (twochem=.true.). Of the total # of electrons nelec, nelec-nelec_cond will occupy the valence manifold and nelec_cond will be constrained in the conduction manifold."},"degauss":{"type":"number","default":0,"description":"value of the gaussian spreading (Ry) for brillouin-zone integration in metals."},"smearing":{"type":"string","enum":["gaussian","gauss","methfessel-paxton","m-p","mp","marzari-vanderbilt","cold","m-v","mv","fermi-dirac","f-d","fd"],"default":"gaussian"},"nspin":{"type":"integer","default":1},"sic_gamma":{"type":"number","default":0,"description":"Strength of the gammaDFT potential."},"pol_type":{"type":"string","enum":["e","h"],"description":"Type of polaron in gammaDFT."},"sic_energy":{"type":"boolean","default":false,"description":"Enable the calculation of the total energy in gammaDFT. When .true., a preliminary calculation is performed to calculate the electron density in the absence of the polaron. When .false., the total energy printed in output should not be considered. For structural relaxations, it is recommended to use .false. to avoid doubling the computational cost."},"sci_vb":{"type":"number","default":0,"description":"Valence band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted."},"sci_cb":{"type":"number","default":0,"description":"Conduction band band shift (in eV) through self-consistent scissor operator. When performing gammaDFT calculations of polarons, the polaron level is not shifted."},"noncolin":{"type":"boolean","default":false,"description":"if .true. the program will perform a noncollinear calculation."},"ecfixed":{"type":"number","default":0},"qcutz":{"type":"number","default":0},"q2sigma":{"type":"number","default":0.1},"input_dft":{"type":"string","description":"Exchange-correlation functional: eg 'PBE', 'BLYP' etc See Modules/funct.f90 for allowed values. Overrides the value read from pseudopotential files. Use with care and if you know what you are doing!"},"ace":{"type":"boolean","default":true,"description":"Use Adaptively Compressed Exchange operator as in Lin Lin, J. Chem. Theory Comput. 2016, 12, 2242--2249, doi:10.1021/acs.jctc.6b00092"},"exx_fraction":{"type":"number","description":"Fraction of EXX for hybrid functional calculations. In the case of input_dft='PBE0', the default value is 0.25, while for input_dft='B3LYP' the exx_fraction default value is 0.20."},"screening_parameter":{"type":"number","default":0.106,"description":"screening_parameter for HSE like hybrid functionals."},"exxdiv_treatment":{"type":"string","default":"gygi-baldereschi","enum":["gygi-baldereschi","vcut_spherical","vcut_ws","none"]},"x_gamma_extrapolation":{"type":"boolean","default":true,"description":"Specific for EXX. If .true., extrapolate the G=0 term of the potential"},"ecutvcut":{"type":"number","description":"Reciprocal space cutoff for correcting Coulomb potential divergencies at small q vectors."},"nqx1":{"type":"integer","default":0,"description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"nqx2":{"type":"integer","description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"nqx3":{"type":"integer","description":"Three-dimensional mesh for q (k1-k2) sampling of the Fock operator (EXX). Can be smaller than the number of k-points."},"localization_thr":{"type":"number","default":0,"description":"Overlap threshold over which the exchange integral over a pair of localized orbitals is included in the evaluation of EXX operator. Any value greater than 0.0 triggers the SCDM localization and the evaluation on EXX using the localized orbitals. Very small value of the threshold should yield the same result as the default EXX evaluation"},"Hubbard_occ":{"type":"array","items":{"type":"array","items":[{"type":"integer","minimum":1},{"type":"integer","minimum":1,"maximum":3},{"type":"number"}],"minItems":3,"maxItems":3}},"Hubbard_alpha":{"type":"array","items":{"type":"number","default":0}},"Hubbard_beta":{"type":"array","items":{"type":"number","default":0}},"starting_ns_eigenvalue":{"type":"array","items":{"type":"array","items":{"type":"array","items":{"type":"number"}}}},"dmft":{"type":"boolean","default":false,"description":"If true, nscf calculation will exit in restart mode, scf calculation will restart from there if DMFT updates are provided as hdf5 archive. Scf calculation should be used only with electron_maxstep = 1."},"dmft_prefix":{"type":"string","description":"prepended to hdf5 archive: dmft_prefix.h5"},"ensemble_energies":{"type":"boolean","default":false,"description":"If ensemble_energies = .true., an ensemble of xc energies is calculated non-selfconsistently for perturbed exchange-enhancement factors and LDA vs. PBE correlation ratios after each converged electronic ground state calculation."},"edir":{"type":"integer","description":"The direction of the electric field or dipole correction is parallel to the bg(:,edir) reciprocal lattice vector, so the potential is constant in planes defined by FFT grid points; edir = 1, 2 or 3. Used only if tefield is .TRUE."},"emaxpos":{"type":"number","default":0.5,"description":"Position of the maximum of the saw-like potential along crystal axis edir, within the  unit cell (see below), 0 < emaxpos < 1 Used only if tefield is .TRUE."},"eopreg":{"type":"number","default":0.1,"description":"Zone in the unit cell where the saw-like potential decreases. ( see below, 0 < eopreg < 1 ). Used only if tefield is .TRUE."},"eamp":{"type":"number","default":0.001},"angle1":{"type":"array","items":{"type":"number"},"maxItems":1,"minItems":1,"description":"The angle expressed in degrees between the initial magnetization and the z-axis. For noncollinear calculations only; index i runs over the atom types."},"angle2":{"type":"array","items":{"type":"number"},"maxItems":1,"minItems":1,"description":"The angle expressed in degrees between the projection of the initial magnetization on x-y plane and the x-axis. For noncollinear calculations only."},"lforcet":{"type":"boolean","description":"When starting a non collinear calculation using an existing density file from a collinear lsda calculation assumes previous density points in z direction and rotates it in the direction described by angle1 and angle2 variables for atomic type 1"},"constrained_magnetization":{"type":"string","enum":["none","total","atomic","total direction","atomic direction"],"default":"none","description":"Used to perform constrained calculations in magnetic systems."},"fixed_magnetization":{"type":"array","items":{"type":"number","default":0},"maxItems":3,"minItems":3},"lambda":{"type":"number","default":1,"description":"parameter used for constrained_magnetization calculations N.B.: if the scf calculation does not converge, try to reduce lambda to obtain convergence, then restart the run with a larger lambda"},"report":{"type":"integer","default":-1,"description":"determines when atomic magnetic moments are printed on output"},"lspinorb":{"type":"boolean","description":"if .TRUE. the noncollinear code can use a pseudopotential with spin-orbit."},"assume_isolated":{"type":"string","enum":["none","makov-payne","m-p","mp","martyna-tuckerman","m-t","mt","esm","2D"],"default":"none","description":"Used to perform calculation assuming the system to be isolated (a molecule or a cluster in a 3D supercell)"},"esm_bc":{"type":"string","enum":["pbc","bc1","bc2","bc3"],"default":"pbc","description":"If assume_isolated = 'esm', determines the boundary conditions used for either side of the slab."},"esm_w":{"type":"number","default":0,"description":"If assume_isolated = 'esm', determines the position offset [in a.u.] of the start of the effective screening region, measured relative to the cell edge. (ESM region begins at z = +/- [L_z/2 + esm_w] )."},"esm_efield":{"type":"number","default":0,"description":"If assume_isolated = 'esm' and esm_bc = 'bc2', gives the magnitude of the electric field [Ry/a.u.] to be applied between semi-infinite ESM electrodes."},"esm_nfit":{"type":"integer","default":4,"description":"If assume_isolated = 'esm', gives the number of z-grid points for the polynomial fit along the cell edge."},"lgcscf":{"type":"boolean","default":false,"description":"If .TRUE. perform a constant bias potential (constant-mu) calculation with Grand-Canonical SCF."},"gcscf_mu":{"type":"number","description":"The target Fermi energy (eV) of GC-SCF. One can start with appropriate total charge of the system by giving tot_charge"},"gcscf_conv_thr":{"type":"number","default":0.01,"description":"Convergence threshold of Fermi energy (eV) for GC-SCF."},"gcscf_beta":{"type":"number","default":0.05,"description":"Mixing factor for GC-SCF. Larger values are recommended, if systems with small DOS on Fermi surface as graphite."},"vdw_corr":{"type":"string","enum":["none","grimme-d2","Grimme-D2","DFT-D","dft-d","grimme-d3","Grimme-D3","DFT-D3","dft-d3","TS","ts","ts-vdw","ts-vdW","tkatchenko-scheffler","MBD","mbd","many-body-dispersion","mbd_vdw","XDM","xdm"],"default":"none","description":"Type of Van der Waals correction"},"london":{"type":"boolean","default":false,"description":"OBSOLESCENT, same as vdw_corr='DFT-D'"},"london_s6":{"type":"number","default":0.75,"description":"global scaling parameter for DFT-D. Default is good for PBE."},"london_c6":{"type":"number","description":"atomic C6 coefficient of each atom type"},"london_rvdw":{"type":"number","description":"atomic vdw radii of each atom type"},"london_rcut":{"type":"number","default":200,"description":"cutoff radius (a.u.) for dispersion interactions"},"dftd3_version":{"type":"integer","default":3,"minimum":2,"maximum":6,"description":"Version of Grimme implementation of Grimme-D3"},"dftd3_threebody":{"type":"boolean","default":true,"description":"Turn three-body terms in Grimme-D3 on. If .false. two-body contributions only are computed, using two-body parameters of Grimme-D3. If dftd3_version=2, three-body contribution is always disabled."},"ts_vdw_econv_thr":{"type":"number","default":0.000001,"description":"Optional: controls the convergence of the vdW energy (and forces). The default value is a safe choice, likely too safe, but you do not gain much in increasing it"},"ts_vdw_isolated":{"type":"boolean","default":false,"description":"Optional: set it to .TRUE. when computing the Tkatchenko-Scheffler vdW energy or the Many-Body dispersion (MBD) energy for an isolated (non-periodic) system."},"xdm":{"type":"boolean","default":false,"description":"OBSOLESCENT, same as vdw_corr='xdm'"},"xdm_a1":{"type":"number","default":0.6836,"description":"Damping function parameter a1 (adimensional)"},"xdm_a2":{"type":"number","default":1.5045,"description":"Damping function parameter a2 (angstrom)"},"space_group":{"type":"integer","default":0,"description":"The number of the space group of the crystal, as given in the International Tables of Crystallography A (ITA)"},"uniqueb":{"type":"boolean","default":false,"description":"Used only for monoclinic lattices"},"origin_choice":{"type":"integer","default":1,"description":"Used only for space groups that in the ITA allow the use of two different origins"},"rhombohedral":{"type":"boolean","default":true,"description":"Used only for rhombohedral space groups."},"zgate":{"type":"number","default":0.5,"description":"used only if gate = .TRUE."},"relaxz":{"type":"boolean","default":false,"description":"used only if gate = .TRUE."},"block":{"type":"boolean","default":false,"description":"used only if gate = .TRUE."},"block_1":{"type":"number","default":0.45,"description":"used only if gate = .TRUE. and block = .TRUE."},"block_2":{"type":"number","default":0.55,"description":"used only if gate = .TRUE. and block = .TRUE."},"block_height":{"type":"number","default":0.1,"description":"used only if gate = .TRUE. and block = .TRUE."},"nextffield":{"type":"integer","default":0,"description":"Number of activated external ionic force fields."}},"required":["ibrav","nat","ntyp","ecutwfc"]},"&ELECTRONS":{"$schema":"http://json-schema.org/draft-07/schema#","title":"electrons schema","type":"object","additionalProperties":false,"properties":{"electron_maxstep":{"type":"integer","default":100,"description":"maximum number of iterations in a scf step. If exact exchange is active, this will affect the inner loops."},"exx_maxstep":{"type":"integer","default":100,"description":"maximum number of outer iterations in a scf calculation with exact exchange."},"scf_must_converge":{"type":"boolean","default":true,"description":"If .false. do not stop molecular dynamics or ionic relaxation when electron_maxstep is reached. Use with care."},"conv_thr":{"type":"number"},"adaptive_thr":{"type":"boolean","default":false,"description":"If .TRUE. this turns on the use of an adaptive conv_thr for the inner scf loops when using EXX."},"conv_thr_init":{"type":"number","description":"When adaptive_thr = .TRUE. this is the convergence threshold used for the first scf cycle."},"conv_thr_multi":{"type":"number","description":"When adaptive_thr = .TRUE. the convergence threshold for each scf cycle is given by: max( conv_thr, conv_thr_multi * dexx )"},"mixing_mode":{"type":"string","enum":["plain","TF","local-TF"],"default":"plain"},"mixing_beta":{"type":"number","description":"mixing factor for self-consistency"},"mixing_ndim":{"type":"integer","default":8,"description":"number of iterations used in mixing scheme"},"mixing_fixed_ns":{"type":"integer","default":0,"description":"For DFT+U : number of iterations with fixed ns ( ns is the atomic density appearing in the Hubbard term )."},"diagonalization":{"type":"string","enum":["david","cg","ppcg","paro","ParO","rmm-davidson","rmm-paro"],"default":"david"},"diago_thr_init":{"type":"number","description":"Convergence threshold (ethr) for iterative diagonalization (the check is on eigenvalue convergence)."},"diago_cg_maxiter":{"type":"integer","description":"For conjugate gradient diagonalization:  max number of iterations"},"diago_ppcg_maxiter":{"type":"integer","description":"For ppcg diagonalization:  max number of iterations"},"diago_david_ndim":{"type":"integer","default":2,"description":"For Davidson diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed)."},"diago_rmm_ndim":{"type":"integer","default":4,"description":"For RMM-DIIS diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed)."},"diago_rmm_conv":{"type":"boolean","default":false,"description":"If .TRUE., RMM-DIIS is performed up to converge. If .FALSE., RMM-DIIS is performed only once."},"diago_gs_nblock":{"type":"integer","default":16,"description":"For RMM-DIIS diagonalization: blocking size of Gram-Schmidt orthogonalization"},"diago_full_acc":{"type":"boolean","default":false,"description":"If .TRUE. all the empty states are diagonalized at the same level of accuracy of the occupied ones. Otherwise the empty states are diagonalized using a larger threshold (this should not affect total energy, forces, and other ground-state properties)."},"efield":{"type":"number","description":"Amplitude of the finite electric field (in Ry a.u.; 1 a.u. = 36.3609*10^10 V/m). Used only if lelfield==.TRUE. and if k-points (K_POINTS card) are not automatic."},"efield_cart":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"efield_phase":{"type":"string","enum":["read","write","none"],"default":"none"},"startingpot":{"type":"string","enum":["atomic","file"]},"startingwfc":{"type":"string","enum":["atomic","atomic+random","random","file"],"default":"atomic+random"},"tqr":{"type":"boolean","default":false,"description":"If .true., use a real-space algorithm for augmentation charges of ultrasoft pseudopotentials and PAWsets. Faster but numerically less accurate than the default G-space algorithm. Use with care and after testing!"},"real_space":{"type":"boolean","default":false,"description":"If .true., exploit real-space localization to compute matrix elements for nonlocal projectors. Faster and in principle better scaling than the default G-space algorithm, but numerically less accurate, may lead to some loss of translational invariance. Use with care and after testing!"}}},"&IONS":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"ions schema","type":"object","additionalProperties":false,"oneOf":[{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["bfgs","damp","fire"],"default":"bfgs","description":"CASE: calculation == 'relax'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["verlet","langevin","langevin-smc"],"default":"verlet","description":"CASE: calculation == 'md'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["bfgs","damp"],"default":"bfgs","description":"CASE: calculation == 'vc-relax'"}}},{"type":"object","additionalProperties":false,"properties":{"ion_dynamics":{"type":"string","enum":["beeman"],"default":"beeman","description":"CASE: calculation == 'vc-md'"}}}],"properties":{"ion_positions":{"type":"string","enum":["default","from_input"],"default":"default"},"ion_velocities":{"type":"string","enum":["default","from_input"],"default":"default"},"pot_extrapolation":{"type":"string","enum":["none","atomic","first_order","second_order"],"default":"atomic","description":"Used to extrapolate the potential from preceding ionic steps."},"wfc_extrapolation":{"type":"string","enum":["none","first_order","second_order"],"default":"none","description":"Used to extrapolate the wavefunctions from preceding ionic steps."},"remove_rigid_rot":{"type":"boolean","default":false,"description":"This keyword is useful when simulating the dynamics and/or the thermodynamics of an isolated system. If set to true the total torque of the internal forces is set to zero by adding new forces that compensate the spurious interaction with the periodic images. This allows for the use of smaller supercells."},"ion_temperature":{"type":"string","enum":["rescaling","rescale-v","rescale-T","reduce-T","berendsen","andersen","svr","initial","not_controlled"],"default":"not_controlled"},"tempw":{"type":"number","description":"Starting temperature (Kelvin) in MD runs target temperature for most thermostats.","default":300},"tolp":{"type":"number","description":"Tolerance for velocity rescaling. Velocities are rescaled if the run-averaged and target temperature differ more than tolp.","default":100},"delta_t":{"type":"number","default":1},"nraise":{"type":"integer","default":1},"refold_pos":{"type":"boolean","default":false,"description":"This keyword applies only in the case of molecular dynamics or damped dynamics. If true the ions are refolded at each step into the supercell."},"upscale":{"type":"number","description":"Max reduction factor for conv_thr during structural optimization conv_thr is automatically reduced when the relaxation approaches convergence so that forces are still accurate, but conv_thr will not be reduced to less that conv_thr / upscale.","default":100},"bfgs_ndim":{"type":"integer","default":1,"description":"Number of old forces and displacements vectors used in the PULAY mixing of the residual vectors obtained on the basis of the inverse hessian matrix given by the BFGS algorithm."},"trust_radius_max":{"type":"number","description":"Maximum ionic displacement in the structural relaxation. (bfgs only)","default":0.8},"trust_radius_min":{"type":"number","description":"Minimum ionic displacement in the structural relaxation BFGS is reset when trust_radius < trust_radius_min. (bfgs only)","default":0.001},"trust_radius_ini":{"type":"number","description":"Initial ionic displacement in the structural relaxation. (bfgs only)","default":0.5},"w_1":{"type":"number","default":0.01},"w_2":{"type":"number","description":"Parameters used in line search based on the Wolfe conditions. (bfgs only)","default":0.5},"fire_alpha_init":{"type":"number","description":"Initial value of the alpha mixing factor in the FIRE minimization scheme; recommended values are between 0.1 and 0.3","default":0.2},"fire_falpha":{"type":"number","description":"Scaling of the alpha mixing parameter for steps with P > 0;","default":0.99},"fire_nmin":{"type":"integer","default":5,"description":"Minimum number of steps with P > 0 before increase of dt"},"fire_f_inc":{"type":"number","description":"Factor for increasing dt","default":1.1},"fire_f_dec":{"type":"number","description":"Factor for decreasing dt","default":0.5},"fire_dtmax":{"type":"number","description":"Determines the maximum value of dt in the FIRE minimization; dtmax = fire_dtmax*dt","default":10}}},{"type":"null"}]},"&CELL":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"cell schema","type":"object","additionalProperties":false,"oneOf":[{"type":"object","additionalProperties":false,"properties":{"cell_dynamics":{"type":"string","enum":["none","sd","damp-pr","damp-w","bfgs"],"default":"bfgs","description":"CASE ( calculation == 'vc-relax' )"}}},{"type":"object","additionalProperties":false,"properties":{"cell_dynamics":{"type":"string","enum":["none","pr","w"],"description":"CASE ( calculation == 'vc-md' )"}}}],"properties":{"press":{"type":"number","description":"Target pressure [KBar] in a variable-cell md or relaxation run.","default":0},"wmass":{"type":"number","description":"Fictitious cell mass [amu] for variable-cell simulations (both 'vc-md' and 'vc-relax'). Default: 0.75*Tot_Mass/pi**2 for Parrinello-Rahman MD; 0.75*Tot_Mass/pi**2/Omega**(2/3) for Wentzcovitch MD"},"cell_factor":{"type":"number","description":"Used in the construction of the pseudopotential tables. It should exceed the maximum linear contraction of the cell during a simulation. Default: 2.0 for variable-cell calculations, 1.0 otherwise"},"press_conv_thr":{"type":"number","default":0.5,"description":"Convergence threshold on the pressure for variable cell relaxation ('vc-relax' : note that the other convergence thresholds for ionic relaxation apply as well)."},"cell_dofree":{"type":"string","enum":["all","ibrav","a","b","c","fixa","fixb","fixc","x","y","xy","xz","xyz","shape","volume","2Dxy","2Dshape","epitaxial_ab","epitaxial_ac","epitaxial_bc"],"default":"all","description":"Select which of the cell parameters should be moved"}}},{"type":"null"}]},"ATOMIC_SPECIES":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic species schema","type":"object","additionalProperties":false,"properties":{"values":{"type":"array","items":{"type":"object","additionalProperties":false,"properties":{"X":{"type":"string","description":"label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in \"Xn\" (e.g. Fe1) or \"X_*\" or \"X-*\" (e.g. C1, C_h; max total length cannot exceed 3 characters)"},"Mass_X":{"type":"number","description":"mass of the atomic species [amu: mass of C = 12]. Used only when performing Molecular Dynamics run or structural optimization runs using Damped MD. Not actually used in all other cases (but stored in data files, so phonon calculations will use these values unless other values are provided)"},"PseudoPot_X":{"type":"string","description":"PseudoPot_X"}}}}}},"ATOMIC_POSITIONS":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic positions schema","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1493","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["alat","bohr","angstrom","crystal","crystal_sg"],"default":"alat"},"values":{"type":"array","items":{"type":"object","additionalProperties":false,"properties":{"X":{"type":"string","description":"label of the atom as specified in ATOMIC_SPECIES"},"x":{"type":"number","description":"atomic positions"},"y":{"type":"number","description":"atomic positions"},"z":{"type":"number","description":"atomic positions"},"if_pos(1)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1},"if_pos(2)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1},"if_pos(3)":{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1}},"required":["x","y","z"]}}}},"K_POINTS":{"$schema":"http://json-schema.org/draft-07/schema#","title":"k points schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["tpiba","automatic","crystal","gamma","tpiba_b","crystal_b","tpiba_c","crystal_c"]},"values":{"oneOf":[{"type":"array","description":"K_POINTS tpiba | crystal | tpiba_b | crystal_b | tpiba_c | crystal_c","items":{"type":"object","additionalProperties":false,"properties":{"nks":{"type":"integer","description":"Number of supplied special k-points."},"xk_x":{"type":"number"},"xk_y":{"type":"number"},"xk_z":{"type":"number"},"wk":{"type":"number"}}}},{"type":"object","description":"K_POINTS automatic","additionalProperties":false,"properties":{"nk1":{"type":"integer","description":"Number of supplied special k-points."},"nk2":{"type":"integer","description":"Number of supplied special k-points."},"nk3":{"type":"integer","description":"Number of supplied special k-points."},"sk1":{"type":"integer","description":"Number of supplied special k-points."},"sk2":{"type":"integer","description":"Number of supplied special k-points."},"sk3":{"type":"integer","description":"Number of supplied special k-points."}}},{"type":"null","description":"K_POINTS gamma"}]}}},"CELL_PARAMETERS":{"$schema":"http://json-schema.org/draft-07/schema#","title":"cell parameters schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["alat","bohr","angstrom"],"description":"label of the atom. Acceptable syntax: chemical symbol X (1 or 2 characters, case-insensitive) or chemical symbol plus a number or a letter, as in \"Xn\" (e.g. Fe1) or \"X_*\" or \"X-*\" (e.g. C1, C_h; max total length cannot exceed 3 characters)"},"values":{"type":"object","additionalProperties":false,"properties":{"v1":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"v2":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"v3":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}}}}},"HUBBARD":{"$schema":"http://json-schema.org/draft-07/schema#","title":"hubbard schema","type":"object","additionalProperties":false,"properties":{"card_option":{"type":"string","enum":["atomic","ortho-atomic","norm-atomic","wf","pseudo"]},"values":{"oneOf":[{"description":"IF DFT+U","type":"array","items":{"oneOf":[{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1764","additionalProperties":false,"properties":{"U":{"type":"string","enum":["U"],"description":"string constant \"U\"; indicates the specs for the U parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"u_val":{"type":"number","description":"value of the U parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1784","additionalProperties":false,"properties":{"J0":{"type":"string","enum":["J0"],"description":"string constant \"J0\"; indicates the specs for the J0 parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"j0_val":{"type":"number","description":"value of the J0 parameter (in eV)"}}}]}},{"description":"IF DFT+U+J","type":"array","items":{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1817","additionalProperties":false,"properties":{"paramType":{"type":"string","enum":["U","J","B","E2","E3"],"description":"character describing the type of Hubbard parameter allowed values: U, J and either B (for d-orbitals) or E2 and E3 (for f-orbitals)"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"paramValue":{"type":"number","description":"value of the J0 parameter (in eV)"}}}},{"description":"IF DFT+U+V","type":"array","items":{"oneOf":[{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1847","additionalProperties":false,"properties":{"U":{"type":"string","enum":["U"],"description":"string constant \"U\"; indicates the specs for the U parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"u_val":{"type":"number","description":"value of the U parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1865","additionalProperties":false,"properties":{"J0":{"type":"string","enum":["J0"],"description":"string constant \"J0\"; indicates the specs for the J0 parameter will be given"},"label":{"type":"string","description":"label of the atom (as defined in ATOMIC_SPECIES)"},"manifold":{"type":"string","description":"specs of the manifold (e.g., 3d, 2p...)"},"j0_val":{"type":"number","description":"value of the J0 parameter (in eV)"}}},{"type":"object","description":"https://www.quantum-espresso.org/Doc/INPUT_PW.html#idm1884","additionalProperties":false,"properties":{"V":{"type":"string","enum":["V"],"description":"string constant \"V\"; indicates the specs for the V parameter will be given"},"label(I)":{"type":"string","description":"label of the atom I (as defined in ATOMIC_SPECIES)"},"manifold(I)":{"type":"string","description":"specs of the manifold for atom I (e.g., 3d, 2p...)"},"label(J)":{"type":"string","description":"label of the atom J (as defined in ATOMIC_SPECIES)"},"manifold(J)":{"type":"string","description":"specs of the manifold for atom J (e.g., 3d, 2p...)"},"I":{"type":"integer","description":"index of the atom I"},"J":{"type":"integer","description":"index of the atom J"},"v_val(I,J)":{"type":"number","description":"value of the V parameter for the atom pair I,J (in eV)"}}}]}}]}}}}},{"$id":"apse/materials/builders/slab/pymatgen/parameters","$schema":"http://json-schema.org/draft-07/schema#","title":"Pymatgen Slab Generator Parameters Schema","description":"Parameters for the Pymatgen slab generator. https://github.com/materialsproject/pymatgen/blob/585bb673c4aa222669c4b0d72ffeec3dbf092630/pymatgen/core/surface.py#L1187","type":"object","properties":{"min_vacuum_size":{"description":"Minimum size of the vacuum in layers or angstroms","type":["integer","number"],"minimum":0,"default":0},"in_unit_planes":{"description":"Whether to use unit planes for the vacuum and slab size","type":"boolean","default":true},"reorient_lattice":{"description":"Whether to reorient the lattice to have c vector along the z-axis","type":"boolean","default":true},"symmetrize":{"description":"Whether to symmetrize the slab","type":"boolean","default":true}}},{"$id":"core/abstract/2d-data","$schema":"http://json-schema.org/draft-07/schema#","title":"2 dimension data schema","type":"object","properties":{"xDataArray":{"description":"array containing values of x Axis","type":"array"},"yDataSeries":{"$schema":"http://json-schema.org/draft-07/schema#","title":"1 dimension data series schema","type":"array","items":{"type":"array","minItems":1,"items":{"type":["number","string"]}}}},"required":["xDataArray","yDataSeries"]},{"$id":"core/abstract/2d-plot","$schema":"http://json-schema.org/draft-07/schema#","title":"2 dimension plot schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"2 dimension data schema","type":"object","properties":{"xDataArray":{"description":"array containing values of x Axis","type":"array"},"yDataSeries":{"$schema":"http://json-schema.org/draft-07/schema#","title":"1 dimension data series schema","type":"array","items":{"type":"array","minItems":1,"items":{"type":["number","string"]}}}},"required":["xDataArray","yDataSeries"]}],"properties":{"xAxis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"axis schema","type":"object","properties":{"label":{"description":"label of an axis object","type":"string"},"units":{"description":"units for an axis","type":"string"}},"required":["label"]},"yAxis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"axis schema","type":"object","properties":{"label":{"description":"label of an axis object","type":"string"},"units":{"description":"units for an axis","type":"string"}},"required":["label"]},"legend":{"description":"Legend of y Axis data series","minItems":1,"type":"array"}},"required":["xAxis","yAxis"]},{"$id":"core/abstract/3d-grid","$schema":"http://json-schema.org/draft-07/schema#","title":"3 dimensional grid schema","type":"object","properties":{"dimensions":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"shifts":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}},"required":["dimensions","shifts"]},{"$id":"core/abstract/coordinate-2d","$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 2d schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},{"$id":"core/abstract/coordinate-3d","$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},{"$id":"core/abstract/matrix-3x3","$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3},{"$id":"core/abstract/vector-2d","$schema":"http://json-schema.org/draft-07/schema#","title":"vector 2d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2}]},{"$id":"core/abstract/vector-3d","$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},{"$id":"core/abstract/vector-boolean-3d","$schema":"http://json-schema.org/draft-07/schema#","title":"vector boolean 3d schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 boolean elements schema","type":"array","items":{"type":"boolean"},"minItems":3,"maxItems":3}]},{"$id":"core/primitive/1d-data-series","$schema":"http://json-schema.org/draft-07/schema#","title":"1 dimension data series schema","type":"array","items":{"type":"array","minItems":1,"items":{"type":["number","string"]}}},{"$id":"core/primitive/array-of-2-numbers","$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},{"$id":"core/primitive/array-of-3-booleans","$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 boolean elements schema","type":"array","items":{"type":"boolean"},"minItems":3,"maxItems":3},{"$id":"core/primitive/array-of-3-integers","$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3},{"$id":"core/primitive/array-of-3-numbers","$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},{"$id":"core/primitive/array-of-ids","$schema":"http://json-schema.org/draft-07/schema#","title":"array of ids","description":"array of objects containing integer id each","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}},{"$id":"core/primitive/array-of-strings","$schema":"http://json-schema.org/draft-07/schema#","title":"array of strings","description":"array of strings, e.g. metadata tags","type":"array","items":{"type":"string","uniqueItems":true}},{"$id":"core/primitive/axis","$schema":"http://json-schema.org/draft-07/schema#","title":"axis schema","type":"object","properties":{"label":{"description":"label of an axis object","type":"string"},"units":{"description":"units for an axis","type":"string"}},"required":["label"]},{"$id":"core/reusable/axis-enum","$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},{"$id":"core/primitive/group-info","$schema":"http://json-schema.org/draft-07/schema#","title":"Group info schema for nodes in a graph","type":"object","properties":{"groupName":{"description":"Human-readable name of group of nodes","type":"string"},"groupId":{"description":"Unique identifier of the group a node belongs to","type":"string"}}},{"$id":"core/primitive/integer-one-or-zero","$schema":"http://json-schema.org/draft-07/schema#","title":"integer one or zero","type":"integer","minimum":0,"maximum":1},{"$id":"core/primitive/integer-positive-single-digit","$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9},{"$id":"core/primitive/linked-list/base-node","$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$id":"core/primitive/linked-list/named-node","$schema":"http://json-schema.org/draft-07/schema#","title":"Named node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}}]},{"$id":"core/primitive/linked-list/named-node-in-group","$schema":"http://json-schema.org/draft-07/schema#","title":"Named node in group schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Group info schema for nodes in a graph","type":"object","properties":{"groupName":{"description":"Human-readable name of group of nodes","type":"string"},"groupId":{"description":"Unique identifier of the group a node belongs to","type":"string"}}}]},{"$id":"core/primitive/linked-list/node-with-type","$schema":"http://json-schema.org/draft-07/schema#","title":"Typed node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}}],"properties":{"type":{"type":"string"}}},{"$id":"core/primitive/linked-list","$schema":"http://json-schema.org/draft-07/schema#","title":"linked list schema","type":"array","items":{"type":"object","anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named node in group schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Group info schema for nodes in a graph","type":"object","properties":{"groupName":{"description":"Human-readable name of group of nodes","type":"string"},"groupId":{"description":"Unique identifier of the group a node belongs to","type":"string"}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Typed node schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"basic node schema (linked list)","type":"object","allOf":[{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}],"properties":{"next":{"description":"Flowchart ID of next node","type":"string"},"head":{"description":"Whether node is head node or not","type":"boolean"}},"definitions":{"flowchart-id":{"properties":{"flowchartId":{"description":"Unique flowchart ID of node","type":"string"}},"required":["flowchartId"]}}}],"properties":{"type":{"type":"string"}}}],"uniqueItems":true}},{"$id":"core/primitive/object-with-id","$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]},{"$id":"core/primitive/object-with-id-and-value","$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]},{"$id":"core/primitive/scalar","$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]},{"$id":"core/primitive/slugified-entry","$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"$id":"core/primitive/slugified-entry-or-slug","$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]},{"$id":"core/primitive/string","$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]},{"$id":"core/reference/exabyte","$schema":"http://json-schema.org/draft-07/schema#","type":"object","properties":{"materialId":{"description":"Material's identity. Used for protoProperties.","type":"string"},"jobId":{"description":"Job's identity","type":"string"},"unitId":{"description":"Id of the unit that extracted the result","type":"string"}}},{"$id":"core/reference/experiment/condition","$schema":"http://json-schema.org/draft-07/schema#","title":"condition schema","type":"object","properties":{"units":{"description":"condition unit","type":"string"},"scalar":{"description":"array of condition values","type":"array","items":{"type":"object","properties":{"value":{"type":"string"}}}},"name":{"description":"human-readable name of the condition","type":"string"}},"required":["name"]},{"$id":"core/reference/experiment/location","$schema":"http://json-schema.org/draft-07/schema#","title":"location schema","type":"object","properties":{"latitude":{"description":"location latitude","type":"number"},"longitude":{"description":"location longitude","type":"number"}},"required":["latitude","longitude"]},{"$id":"core/reference/experiment","$schema":"http://json-schema.org/draft-07/schema#","title":"info for characteristic obtained by experiment","type":"object","properties":{"type":{"enum":["experiment"]},"authors":{"description":"experiment authors","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"title":{"type":"string","description":"experiment title"},"method":{"type":"string","description":"method used in experiment"},"conditions":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"condition schema","type":"object","properties":{"units":{"description":"condition unit","type":"string"},"scalar":{"description":"array of condition values","type":"array","items":{"type":"object","properties":{"value":{"type":"string"}}}},"name":{"description":"human-readable name of the condition","type":"string"}},"required":["name"]}},"location":{"$schema":"http://json-schema.org/draft-07/schema#","title":"location schema","type":"object","properties":{"latitude":{"description":"location latitude","type":"number"},"longitude":{"description":"location longitude","type":"number"}},"required":["latitude","longitude"]},"timestamp":{"description":"epoch time.","type":"number"},"note":{"description":"Note about experiment","type":"string"},"references":{"type":"array","description":"references to literature articles","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"literature reference schema","type":"object","properties":{"type":{"enum":["literature"]},"doi":{"type":"string","description":"Digital Object Identifier of the reference."},"isbn":{"type":"string","description":"International Standard Book Number of the reference."},"issn":{"type":"string","description":"International Standard Serial Number of the reference."},"url":{"type":"string","description":"Internet address of the reference."},"title":{"type":"string","description":"Title of the work."},"publisher":{"type":"string","description":"Publisher of the work."},"journal":{"type":"string","description":"Journal in which the work appeared."},"volume":{"type":"string","description":"Volume of the series in which the work appeared."},"year":{"type":"string","description":"Year in which the reference was published."},"issue":{"type":"string","description":"Issue of the collection in which the work appeared."},"pages":{"type":"object","description":"Start and end pages of the work.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"pages schema","type":"object","properties":{"start":{"type":"string"},"end":{"type":"string"}},"required":["start"]}]},"authors":{"type":"array","description":"List of authors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"editors":{"type":"array","description":"List of editors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"reference":{"type":"array","items":{"type":"object"},"description":"References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published."}}}}},"required":["conditions","authors","title","method","timestamp"]},{"$id":"core/reference/literature/name","$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]},{"$id":"core/reference/literature/pages","$schema":"http://json-schema.org/draft-07/schema#","title":"pages schema","type":"object","properties":{"start":{"type":"string"},"end":{"type":"string"}},"required":["start"]},{"$id":"core/reference/literature","$schema":"http://json-schema.org/draft-07/schema#","title":"literature reference schema","type":"object","properties":{"type":{"enum":["literature"]},"doi":{"type":"string","description":"Digital Object Identifier of the reference."},"isbn":{"type":"string","description":"International Standard Book Number of the reference."},"issn":{"type":"string","description":"International Standard Serial Number of the reference."},"url":{"type":"string","description":"Internet address of the reference."},"title":{"type":"string","description":"Title of the work."},"publisher":{"type":"string","description":"Publisher of the work."},"journal":{"type":"string","description":"Journal in which the work appeared."},"volume":{"type":"string","description":"Volume of the series in which the work appeared."},"year":{"type":"string","description":"Year in which the reference was published."},"issue":{"type":"string","description":"Issue of the collection in which the work appeared."},"pages":{"type":"object","description":"Start and end pages of the work.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"pages schema","type":"object","properties":{"start":{"type":"string"},"end":{"type":"string"}},"required":["start"]}]},"authors":{"type":"array","description":"List of authors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"editors":{"type":"array","description":"List of editors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"reference":{"type":"array","items":{"type":"object"},"description":"References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published."}}},{"$id":"core/reference/modeling/exabyte","$schema":"http://json-schema.org/draft-07/schema#","title":"info for characteristic obtained by exabyte calculation","type":"object","properties":{"type":{"enum":["exabyte"]},"title":{"description":"Human-readable title of the job","type":"string","maxLength":300},"_id":{"description":"job identifier","type":"string"},"owner":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]}},"required":["title","_id","owner"]},{"$id":"core/reference/modeling","$schema":"http://json-schema.org/draft-07/schema#","title":"info for property obtained by modeling, only supports exabyte-originated data atm, but easily extendable","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"info for characteristic obtained by exabyte calculation","type":"object","properties":{"type":{"enum":["exabyte"]},"title":{"description":"Human-readable title of the job","type":"string","maxLength":300},"_id":{"description":"job identifier","type":"string"},"owner":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]}},"required":["title","_id","owner"]}]},{"$id":"core/reference","$schema":"http://json-schema.org/draft-07/schema#","title":"reference schema (using `anyOf` instead of `oneOf` below b/c current reference schemas overlap)","anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"info for property obtained by modeling, only supports exabyte-originated data atm, but easily extendable","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"info for characteristic obtained by exabyte calculation","type":"object","properties":{"type":{"enum":["exabyte"]},"title":{"description":"Human-readable title of the job","type":"string","maxLength":300},"_id":{"description":"job identifier","type":"string"},"owner":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]}},"required":["title","_id","owner"]}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"info for characteristic obtained by experiment","type":"object","properties":{"type":{"enum":["experiment"]},"authors":{"description":"experiment authors","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"title":{"type":"string","description":"experiment title"},"method":{"type":"string","description":"method used in experiment"},"conditions":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"condition schema","type":"object","properties":{"units":{"description":"condition unit","type":"string"},"scalar":{"description":"array of condition values","type":"array","items":{"type":"object","properties":{"value":{"type":"string"}}}},"name":{"description":"human-readable name of the condition","type":"string"}},"required":["name"]}},"location":{"$schema":"http://json-schema.org/draft-07/schema#","title":"location schema","type":"object","properties":{"latitude":{"description":"location latitude","type":"number"},"longitude":{"description":"location longitude","type":"number"}},"required":["latitude","longitude"]},"timestamp":{"description":"epoch time.","type":"number"},"note":{"description":"Note about experiment","type":"string"},"references":{"type":"array","description":"references to literature articles","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"literature reference schema","type":"object","properties":{"type":{"enum":["literature"]},"doi":{"type":"string","description":"Digital Object Identifier of the reference."},"isbn":{"type":"string","description":"International Standard Book Number of the reference."},"issn":{"type":"string","description":"International Standard Serial Number of the reference."},"url":{"type":"string","description":"Internet address of the reference."},"title":{"type":"string","description":"Title of the work."},"publisher":{"type":"string","description":"Publisher of the work."},"journal":{"type":"string","description":"Journal in which the work appeared."},"volume":{"type":"string","description":"Volume of the series in which the work appeared."},"year":{"type":"string","description":"Year in which the reference was published."},"issue":{"type":"string","description":"Issue of the collection in which the work appeared."},"pages":{"type":"object","description":"Start and end pages of the work.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"pages schema","type":"object","properties":{"start":{"type":"string"},"end":{"type":"string"}},"required":["start"]}]},"authors":{"type":"array","description":"List of authors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"editors":{"type":"array","description":"List of editors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"reference":{"type":"array","items":{"type":"object"},"description":"References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published."}}}}},"required":["conditions","authors","title","method","timestamp"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"literature reference schema","type":"object","properties":{"type":{"enum":["literature"]},"doi":{"type":"string","description":"Digital Object Identifier of the reference."},"isbn":{"type":"string","description":"International Standard Book Number of the reference."},"issn":{"type":"string","description":"International Standard Serial Number of the reference."},"url":{"type":"string","description":"Internet address of the reference."},"title":{"type":"string","description":"Title of the work."},"publisher":{"type":"string","description":"Publisher of the work."},"journal":{"type":"string","description":"Journal in which the work appeared."},"volume":{"type":"string","description":"Volume of the series in which the work appeared."},"year":{"type":"string","description":"Year in which the reference was published."},"issue":{"type":"string","description":"Issue of the collection in which the work appeared."},"pages":{"type":"object","description":"Start and end pages of the work.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"pages schema","type":"object","properties":{"start":{"type":"string"},"end":{"type":"string"}},"required":["start"]}]},"authors":{"type":"array","description":"List of authors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"editors":{"type":"array","description":"List of editors of the work.","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"experiment author schema","type":"object","properties":{"first":{"type":"string"},"middle":{"type":"string"},"last":{"type":"string"},"affiliation":{"type":"string"}},"required":["first","last"]}},"reference":{"type":"array","items":{"type":"object"},"description":"References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published."}}}]},{"$id":"core/reusable/atomic-data/per-orbital","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital","description":"Atomic properties per orbital e.g., Hubbard U parameters.","type":"object","properties":{"id":{"type":"integer","description":"Site number or index in the lattice"},"atomicSpecies":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co1, Mn"},"orbitalName":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"}}},{"$id":"core/reusable/atomic-data/per-orbital-pair","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital pair","description":"Atomic properties per orbital pair e.g., Hubbard V parameters.","type":"object","properties":{"id":{"type":"integer","description":"Site number or index in the lattice"},"id2":{"type":"integer","description":"Site number or index in the lattice of second site"},"atomicSpecies":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co1, Mn"},"atomicSpecies2":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co2, O"},"orbitalName":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"},"orbitalName2":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"},"distance":{"type":"number","description":"Distance between two sites in Bohr."}}},{"$id":"core/reusable/atomic-data/value-number","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data numeric properties","description":"Numeric value specific to atomic data","type":"object","properties":{"value":{"type":"number","description":"Value related to a specific property, e.g., Hubbard U, V etc."}}},{"$id":"core/reusable/atomic-data/value-string","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data string properties","description":"String value specific to atomic data","type":"object","properties":{"value":{"type":"string","description":"String value specific to atomic data"}}},{"$id":"core/reusable/atomic-data-per-orbital-numeric","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital numeric","description":"Atomic properties per orbital pair with numeric value e.g., Hubbard V parameters.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital","description":"Atomic properties per orbital e.g., Hubbard U parameters.","type":"object","properties":{"id":{"type":"integer","description":"Site number or index in the lattice"},"atomicSpecies":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co1, Mn"},"orbitalName":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data numeric properties","description":"Numeric value specific to atomic data","type":"object","properties":{"value":{"type":"number","description":"Value related to a specific property, e.g., Hubbard U, V etc."}}}]},{"$id":"core/reusable/atomic-data-per-orbital-pair-numeric","$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital pair numeric","description":"Atomic properties per orbital pair with numeric value e.g., Hubbard V parameters.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data per orbital pair","description":"Atomic properties per orbital pair e.g., Hubbard V parameters.","type":"object","properties":{"id":{"type":"integer","description":"Site number or index in the lattice"},"id2":{"type":"integer","description":"Site number or index in the lattice of second site"},"atomicSpecies":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co1, Mn"},"atomicSpecies2":{"type":"string","pattern":"^[a-zA-Z]{1,2}[\\d+]?$","description":"Example: Co2, O"},"orbitalName":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"},"orbitalName2":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"},"distance":{"type":"number","description":"Distance between two sites in Bohr."}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic data numeric properties","description":"Numeric value specific to atomic data","type":"object","properties":{"value":{"type":"number","description":"Value related to a specific property, e.g., Hubbard U, V etc."}}}]},{"$id":"core/reusable/atomic-orbital","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic orbital schema","type":"object","properties":{"orbitalName":{"type":"string","pattern":"^[1-7][sSpPdDfF]$"},"orbitalIndex":{"type":"integer","minimum":1},"principalNumber":{"type":"integer","minimum":1,"maximum":7},"angularMomentum":{"type":"integer","minimum":0,"maximum":3},"occupation":{"type":"number","description":"Shell occupation","minimum":0,"maximum":14}}},{"$id":"core/reusable/atomic-scalars","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic scalars vectors schema","type":"array","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of ids","description":"array of objects containing integer id each","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}}],"items":{"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}}}},{"$id":"core/reusable/atomic-string","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}},{"$id":"core/reusable/atomic-vector","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic vector schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}},{"$id":"core/reusable/atomic-vectors","$schema":"http://json-schema.org/draft-07/schema#","title":"atomic vectors schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic vector schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},{"$id":"core/reusable/band-gap","$schema":"http://json-schema.org/draft-07/schema#","title":"band gap schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"kpointConduction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"kpoint schema","description":"A k-point is a point in reciprocal space of a crystal.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}]},"kpointValence":{"$schema":"http://json-schema.org/draft-07/schema#","title":"kpoint schema","description":"A k-point is a point in reciprocal space of a crystal.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}]},"eigenvalueConduction":{"description":"eigenvalue at k-point in conduction band","type":"number"},"eigenvalueValence":{"description":"eigenvalue at k-point in valence band","type":"number"},"spin":{"type":"number"},"type":{"type":"string","enum":["direct","indirect"]},"units":{"enum":["kJ/mol","eV","J/mol","hartree","cm-1","Ry","eV/atom"]}},"required":["type"]},{"$id":"core/reusable/categories","$schema":"http://json-schema.org/draft-07/schema#","title":"Reusable categories schema","description":"Used to categorize entities such as models and methods","type":"object","properties":{"tier1":{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]},"tier2":{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]},"tier3":{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]},"subtype":{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry or slug","description":"contains either object with slugified entry or slug only as a string","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"slugified entry","description":"container for machine- and human-readable identifier","type":"object","properties":{"name":{"description":"descriptive human-readable name of entry","type":"string"},"slug":{"description":"machine-readable identifier","type":"string"}},"required":["name","slug"]},{"type":"string"}]}}},{"$id":"core/reusable/category-path","$schema":"http://json-schema.org/draft-07/schema#","title":"category path schema","description":"TODO: Use regex once schema draft version has been updated","type":"string"},{"$id":"core/reusable/coordinate-conditions/base","$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]},{"$id":"core/reusable/coordinate-conditions/box","$schema":"http://json-schema.org/draft-07/schema#","title":"Box Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"box","default":"box"},"min_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"max_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}},"required":["min_coordinate","max_coordinate"]},{"$id":"core/reusable/coordinate-conditions/cylinder","$schema":"http://json-schema.org/draft-07/schema#","title":"Cylinder Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"cylinder","default":"cylinder"},"radius":{"type":"number","minimum":0},"min_z":{"type":"number"},"max_z":{"type":"number"}},"required":["radius","min_z","max_z"]},{"$id":"core/reusable/coordinate-conditions/enum","$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]},{"$id":"core/reusable/coordinate-conditions","$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Conditions Schema","description":"Combined schema for all coordinate condition types","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Box Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"box","default":"box"},"min_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"max_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}},"required":["min_coordinate","max_coordinate"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Sphere Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"sphere","default":"sphere"},"radius":{"type":"number","minimum":0}},"required":["radius"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Cylinder Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"cylinder","default":"cylinder"},"radius":{"type":"number","minimum":0},"min_z":{"type":"number"},"max_z":{"type":"number"}},"required":["radius","min_z","max_z"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Triangular Prism Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"triangular_prism","default":"triangular_prism"},"position_on_surface_1":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"position_on_surface_2":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"position_on_surface_3":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"min_z":{"type":"number"},"max_z":{"type":"number"}},"required":["position_on_surface_1","position_on_surface_2","position_on_surface_3","min_z","max_z"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Plane Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"plane","default":"plane"},"plane_normal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"plane_point_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}},"required":["plane_normal","plane_point_coordinate"]}]},{"$id":"core/reusable/coordinate-conditions/plane","$schema":"http://json-schema.org/draft-07/schema#","title":"Plane Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"plane","default":"plane"},"plane_normal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"plane_point_coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}},"required":["plane_normal","plane_point_coordinate"]},{"$id":"core/reusable/coordinate-conditions/sphere","$schema":"http://json-schema.org/draft-07/schema#","title":"Sphere Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"sphere","default":"sphere"},"radius":{"type":"number","minimum":0}},"required":["radius"]},{"$id":"core/reusable/coordinate-conditions/triangular-prism","$schema":"http://json-schema.org/draft-07/schema#","title":"Triangular Prism Coordinate Condition Schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Condition Schema","description":"Base interface for coordinate shape filters","type":"object","properties":{"shape":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Coordinate Shape Enum","type":"string","enum":["cylinder","sphere","box","triangular_prism","plane"]}},"required":["shape"]}],"properties":{"shape":{"const":"triangular_prism","default":"triangular_prism"},"position_on_surface_1":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"position_on_surface_2":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"position_on_surface_3":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2},"min_z":{"type":"number"},"max_z":{"type":"number"}},"required":["position_on_surface_1","position_on_surface_2","position_on_surface_3","min_z","max_z"]},{"$id":"core/reusable/dielectric-tensor-component","$schema":"http://json-schema.org/draft-07/schema#","title":"Dielectric Tensor","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"","description":"Schema for a function of frequency yielding a nx3 matrix","type":"object","properties":{"frequencies":{"description":"Frequencies","type":"array","items":{"type":"number"}},"components":{"description":"Matrix with 3 columns, e.g. x, y, z","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}}}}],"properties":{"part":{"description":"Real or imaginary part of the dielectric tensor component","type":"string","enum":["real","imaginary"]},"spin":{"type":"number"}},"required":["part","frequencies","components"]},{"$id":"core/reusable/energy","$schema":"http://json-schema.org/draft-07/schema#","title":"energy schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"type":"string"},"units":{"anyOf":[{"enum":["kJ/mol","eV","J/mol","hartree","cm-1","Ry","eV/atom"]},{"enum":["eV/A^2"]}]}},"required":["name","units"]},{"$id":"core/reusable/energy-accuracy-levels","$schema":"http://json-schema.org/draft-07/schema#","title":"Reusable schema for energy value with unit corresponding to a specific accuracy level, e.g., used for suggested wavefunction and charge density cutoffs","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Reusable schema for scalar values with accuracy levels","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"accuracy_level":{"description":"Accuracy level determines suggested scalar value.","type":"string","enum":["standard","low","high"]}},"required":["accuracy_level"]}],"properties":{"unit":{"description":"Unit of the energy value corresponding to a accuracy_level. The values are expressed in Ry.","type":"string","enum":["Ry"]}},"required":["unit"]},{"$id":"core/reusable/file-metadata","$schema":"http://json-schema.org/draft-07/schema#","title":"file_metadata","type":"object","properties":{"pathname":{"description":"Relative path to the directory that contains the file.","type":"string"},"basename":{"description":"Basename of the file","type":"string","$comment":"isGenerative:true"},"filetype":{"description":"What kind of file this is, e.g. image / text","type":"string"}}},{"$id":"core/reusable/frequency-function-matrix","$schema":"http://json-schema.org/draft-07/schema#","title":"","description":"Schema for a function of frequency yielding a nx3 matrix","type":"object","properties":{"frequencies":{"description":"Frequencies","type":"array","items":{"type":"number"}},"components":{"description":"Matrix with 3 columns, e.g. x, y, z","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}}}},{"$id":"core/abstract/kpoint","$schema":"http://json-schema.org/draft-07/schema#","title":"kpoint schema","description":"A k-point is a point in reciprocal space of a crystal.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}]},{"$id":"core/reusable/object-storage-container-data","$schema":"http://json-schema.org/draft-07/schema#","title":"Object Storage Container Data","type":"object","properties":{"CONTAINER":{"description":"Object storage container for the file","type":"string"},"NAME":{"description":"Name of the file inside the object storage bucket","type":"string"},"PROVIDER":{"description":"Object storage provider","type":"string"},"REGION":{"description":"Region for the object container specified in Container","type":"string"},"SIZE":{"description":"Size of the file in bytes","type":"integer"},"TIMESTAMP":{"description":"Unix timestamp showing when the file was last modified","type":"string"}}},{"$id":"core/reusable/scalar-with-accuracy-levels","$schema":"http://json-schema.org/draft-07/schema#","title":"Reusable schema for scalar values with accuracy levels","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"accuracy_level":{"description":"Accuracy level determines suggested scalar value.","type":"string","enum":["standard","low","high"]}},"required":["accuracy_level"]},{"$id":"definitions/chemical-elements","title":"Chemical Element Symbols","periodic_table":{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},"extra":{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]},"all":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}},{"$id":"definitions/constants","title":"fundamental constants","description":"Fundamental physical constants, 2022 NIST CODATA (https://doi.org/10.48550/arXiv.2409.03787)","type":"object","properties":{"c":{"description":"speed of light in vacuum, \"units\": \"m/s\"","type":"number","default":299792458},"h":{"description":"Planck constant, \"units\": \"J s\"","type":"number","default":6.62607015e-34},"e":{"description":"elementary charge, \"units\": \"C\"","type":"number","default":1.602176634e-19},"G":{"description":"Newtonian constant of gravitation, \"units\": \"m^3/kg/s^2\"","type":"number","default":6.6743015e-11},"me":{"description":"electron mass \"units\": \"kg\"","type":"number","default":9.109383713928e-31},"eps0":{"description":"vacuum permittivity, \"units\": \"F/m\"","type":"number","default":8.854187818814e-12},"mu0":{"description":"vacuum permeability, \"units\": \"N/A^2\"","type":"number","default":0.000001256637061272}},"required":["c","h","e","G","me","eps0","mu0"]},{"$id":"definitions/materials","title":"Materials Definitions","form_factor":{"description":"Form factor of the material","enum":["bulk","slab","monolayer","nanoribbon"]},"dimensionality":{"description":"Dimensionality of the material","enum":["zero-dimensional","one-dimensional","two-dimensional","three-dimensional"]}},{"$id":"definitions/units","title":"all units definitions","angle":{"enum":["degree","radian"],"default":"degree"},"coordinates_basis":{"enum":["crystal","cartesian"],"default":"crystal"},"coordinates_lattice_reciprocal":{"enum":["crystal","cartesian"],"default":"crystal"},"length":{"enum":["km","m","cm","mm","um","nm","angstrom","a.u.","bohr","pm"]},"length_atomic":{"enum":["angstrom","bohr"],"default":"angstrom"},"energy":{"enum":["kJ/mol","eV","J/mol","hartree","cm-1","Ry","eV/atom"]},"energy_atomic":{"enum":["eV","hartree","rydberg"],"default":"eV"},"surface_energy":{"enum":["eV/A^2"]},"force":{"enum":["eV/bohr","eV/angstrom","Ry/a.u.","newton","kg*m/s^2","eV/a.u."]},"volume":{"enum":["cm^3","angstrom^3"]},"numberDensity":{"enum":["1/angstrom^3"]},"density":{"enum":["g/cm^3"]},"frequency":{"enum":["cm-1","THz","meV"]},"pressure":{"enum":["kbar","pa"]},"phononDOS":{"enum":["states/cm-1","states/THz","states/meV"]},"electronicDOS":{"enum":["states/unitcell"]},"magnetic":{"enum":["uB"]},"chargeDensity":{"enum":["e/A"]},"spectralIntensity":{"enum":["(debye/angstrom)^2","km/mol","m/mol","a.u."]}},{"$id":"element","$schema":"http://json-schema.org/draft-07/schema#","title":"element schema","type":"object","properties":{"symbol":{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},"properties":{"type":"array","description":"list of elemental properties","items":{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic radius","description":"atomic radius","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["atomic_radius"]},"units":{"enum":["km","m","cm","mm","um","nm","angstrom","a.u.","bohr","pm"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"electronegativity","description":"electronegativity for the element (Pauling scale)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["electronegativity"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"ionization potential","description":"ionization potential for the element","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["ionization_potential"]},"units":{"enum":["kJ/mol","eV","J/mol","hartree","cm-1","Ry","eV/atom"]}}}]}}}},{"$id":"in-memory-entity/base","$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$id":"in-memory-entity/defaultable","$schema":"http://json-schema.org/draft-07/schema#","title":"Defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}}]},{"$id":"in-memory-entity/has-consistency-check-has-metadata-named-defaultable","$schema":"http://json-schema.org/draft-07/schema#","title":"has consistency check has metadata named defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Has consistency check schema","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}}}}]},{"$id":"in-memory-entity/named","$schema":"http://json-schema.org/draft-07/schema#","title":"Named in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}}]},{"$id":"in-memory-entity/named-defaultable","$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}}]},{"$id":"in-memory-entity/named-defaultable-has-metadata","$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]},{"$id":"in-memory-entity/named-defaultable-runtime-items","$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$id":"job/base","$schema":"http://json-schema.org/draft-07/schema#","title":"job base schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"rmsId":{"description":"Identity used to track jobs originated from command-line","type":"string"},"status":{"description":"job status","enum":["pre-submission","queued","submitted","active","finished","terminate-queued","terminated","error","deleted","timeout"]},"startTime":{"description":"Approximate start time of the job. e.g. within 10 min","type":"string"},"workDir":{"description":"The path to the working directory of this job, when the job originates from command-line","type":"string"},"compute":{"$schema":"http://json-schema.org/draft-07/schema#","title":"compute arguments schema","description":"Custom keywords prefixed with validate correspond to custom validation methods implemented downstream","type":"object","properties":{"queue":{"description":"Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.","type":"string","enum":["D","OR","OF","OFplus","SR","SF","SFplus","GPOF","GP2OF","GP4OF","GPSF","GP2SF","GP4SF","OR4","OR8","OR16","SR4","SR8","SR16","GOF","G4OF","G8OF","GSF","G4SF","G8SF"]},"nodes":{"description":"number of nodes used for the job inside the RMS.","type":"integer"},"ppn":{"description":"number of CPUs used for the job inside the RMS.","type":"integer"},"timeLimit":{"description":"Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'","type":"string"},"timeLimitType":{"description":"Convention to use when reasoning about time limits","type":"string","default":"per single attempt","enum":["per single attempt","compound"]},"isRestartable":{"description":"Job is allowed to restart on termination.","type":"boolean","default":true},"notify":{"description":"Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.","type":"string"},"email":{"description":"Email address to notify about job execution.","type":"string"},"maxCPU":{"description":"Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.","type":"integer"},"arguments":{"description":"Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"quantum espresso arguments schema","type":"object","properties":{"nimage":{"description":"Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.","type":"integer","default":1,"minimum":1,"maximum":100},"npools":{"description":"Each image can be subpartitioned into `pools`, each taking care of a group of k-points.","type":"integer","default":1,"minimum":1,"maximum":100},"nband":{"description":"Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).","type":"integer","default":1,"minimum":1,"maximum":100},"ntg":{"description":"In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.","type":"integer","default":1,"minimum":1,"maximum":100},"ndiag":{"description":"A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.","type":"integer","default":1,"minimum":1,"maximum":100}},"additionalProperties":false}],"default":{}},"cluster":{"description":"Cluster where the job is executed. Optional on create. Required on job submission.","type":"object","properties":{"fqdn":{"description":"FQDN of the cluster. e.g. master-1-staging.exabyte.io","type":"string"},"jid":{"description":"Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io","type":"string"}}},"errors":{"description":"Computation error. Optional. Appears only if something happens on jobs execution.","type":"array","items":{"type":"object","properties":{"domain":{"description":"Domain of the error appearance (internal).","type":"string","enum":["rupy","alfred","celim","webapp"]},"reason":{"description":"Should be a short, unique, machine-readable error code string. e.g. FileNotFound","type":"string"},"message":{"description":"Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'","type":"string"},"traceback":{"description":"Full machine-readable error traceback. e.g. FileNotFound","type":"string"}}}},"excludeFilesPattern":{"description":"A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix","type":"string"}},"required":["queue","nodes","ppn","timeLimit"]},"_project":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"_material":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"parent":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"runtimeContext":{"description":"Context variables that the job will have access to at runtime","type":"object"},"scopeTrack":{"description":"history of the workflow scope on each update","type":"array","items":{"type":"object","properties":{"repetition":{"type":"number"},"scope":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow scope schema","type":"object","properties":{"global":{"type":"object","additionalProperties":true},"local":{"type":"object","additionalProperties":true}},"required":["global","local"]}}}}},"required":["status","compute","_project"]},{"$id":"job/compute","$schema":"http://json-schema.org/draft-07/schema#","title":"compute arguments schema","description":"Custom keywords prefixed with validate correspond to custom validation methods implemented downstream","type":"object","properties":{"queue":{"description":"Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.","type":"string","enum":["D","OR","OF","OFplus","SR","SF","SFplus","GPOF","GP2OF","GP4OF","GPSF","GP2SF","GP4SF","OR4","OR8","OR16","SR4","SR8","SR16","GOF","G4OF","G8OF","GSF","G4SF","G8SF"]},"nodes":{"description":"number of nodes used for the job inside the RMS.","type":"integer"},"ppn":{"description":"number of CPUs used for the job inside the RMS.","type":"integer"},"timeLimit":{"description":"Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'","type":"string"},"timeLimitType":{"description":"Convention to use when reasoning about time limits","type":"string","default":"per single attempt","enum":["per single attempt","compound"]},"isRestartable":{"description":"Job is allowed to restart on termination.","type":"boolean","default":true},"notify":{"description":"Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.","type":"string"},"email":{"description":"Email address to notify about job execution.","type":"string"},"maxCPU":{"description":"Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.","type":"integer"},"arguments":{"description":"Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"quantum espresso arguments schema","type":"object","properties":{"nimage":{"description":"Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.","type":"integer","default":1,"minimum":1,"maximum":100},"npools":{"description":"Each image can be subpartitioned into `pools`, each taking care of a group of k-points.","type":"integer","default":1,"minimum":1,"maximum":100},"nband":{"description":"Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).","type":"integer","default":1,"minimum":1,"maximum":100},"ntg":{"description":"In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.","type":"integer","default":1,"minimum":1,"maximum":100},"ndiag":{"description":"A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.","type":"integer","default":1,"minimum":1,"maximum":100}},"additionalProperties":false}],"default":{}},"cluster":{"description":"Cluster where the job is executed. Optional on create. Required on job submission.","type":"object","properties":{"fqdn":{"description":"FQDN of the cluster. e.g. master-1-staging.exabyte.io","type":"string"},"jid":{"description":"Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io","type":"string"}}},"errors":{"description":"Computation error. Optional. Appears only if something happens on jobs execution.","type":"array","items":{"type":"object","properties":{"domain":{"description":"Domain of the error appearance (internal).","type":"string","enum":["rupy","alfred","celim","webapp"]},"reason":{"description":"Should be a short, unique, machine-readable error code string. e.g. FileNotFound","type":"string"},"message":{"description":"Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'","type":"string"},"traceback":{"description":"Full machine-readable error traceback. e.g. FileNotFound","type":"string"}}}},"excludeFilesPattern":{"description":"A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix","type":"string"}},"required":["queue","nodes","ppn","timeLimit"]},{"$id":"job","$schema":"http://json-schema.org/draft-07/schema#","title":"job schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"job base schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"rmsId":{"description":"Identity used to track jobs originated from command-line","type":"string"},"status":{"description":"job status","enum":["pre-submission","queued","submitted","active","finished","terminate-queued","terminated","error","deleted","timeout"]},"startTime":{"description":"Approximate start time of the job. e.g. within 10 min","type":"string"},"workDir":{"description":"The path to the working directory of this job, when the job originates from command-line","type":"string"},"compute":{"$schema":"http://json-schema.org/draft-07/schema#","title":"compute arguments schema","description":"Custom keywords prefixed with validate correspond to custom validation methods implemented downstream","type":"object","properties":{"queue":{"description":"Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.","type":"string","enum":["D","OR","OF","OFplus","SR","SF","SFplus","GPOF","GP2OF","GP4OF","GPSF","GP2SF","GP4SF","OR4","OR8","OR16","SR4","SR8","SR16","GOF","G4OF","G8OF","GSF","G4SF","G8SF"]},"nodes":{"description":"number of nodes used for the job inside the RMS.","type":"integer"},"ppn":{"description":"number of CPUs used for the job inside the RMS.","type":"integer"},"timeLimit":{"description":"Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'","type":"string"},"timeLimitType":{"description":"Convention to use when reasoning about time limits","type":"string","default":"per single attempt","enum":["per single attempt","compound"]},"isRestartable":{"description":"Job is allowed to restart on termination.","type":"boolean","default":true},"notify":{"description":"Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.","type":"string"},"email":{"description":"Email address to notify about job execution.","type":"string"},"maxCPU":{"description":"Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.","type":"integer"},"arguments":{"description":"Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"quantum espresso arguments schema","type":"object","properties":{"nimage":{"description":"Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.","type":"integer","default":1,"minimum":1,"maximum":100},"npools":{"description":"Each image can be subpartitioned into `pools`, each taking care of a group of k-points.","type":"integer","default":1,"minimum":1,"maximum":100},"nband":{"description":"Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).","type":"integer","default":1,"minimum":1,"maximum":100},"ntg":{"description":"In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.","type":"integer","default":1,"minimum":1,"maximum":100},"ndiag":{"description":"A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.","type":"integer","default":1,"minimum":1,"maximum":100}},"additionalProperties":false}],"default":{}},"cluster":{"description":"Cluster where the job is executed. Optional on create. Required on job submission.","type":"object","properties":{"fqdn":{"description":"FQDN of the cluster. e.g. master-1-staging.exabyte.io","type":"string"},"jid":{"description":"Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io","type":"string"}}},"errors":{"description":"Computation error. Optional. Appears only if something happens on jobs execution.","type":"array","items":{"type":"object","properties":{"domain":{"description":"Domain of the error appearance (internal).","type":"string","enum":["rupy","alfred","celim","webapp"]},"reason":{"description":"Should be a short, unique, machine-readable error code string. e.g. FileNotFound","type":"string"},"message":{"description":"Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'","type":"string"},"traceback":{"description":"Full machine-readable error traceback. e.g. FileNotFound","type":"string"}}}},"excludeFilesPattern":{"description":"A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix","type":"string"}},"required":["queue","nodes","ppn","timeLimit"]},"_project":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"_material":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"parent":{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity reference schema","type":"object","properties":{"_id":{"description":"entity identity","type":"string"},"cls":{"description":"entity class","type":"string"},"slug":{"description":"entity slug","type":"string"}},"required":["_id"]},"runtimeContext":{"description":"Context variables that the job will have access to at runtime","type":"object"},"scopeTrack":{"description":"history of the workflow scope on each update","type":"array","items":{"type":"object","properties":{"repetition":{"type":"number"},"scope":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow scope schema","type":"object","properties":{"global":{"type":"object","additionalProperties":true},"local":{"type":"object","additionalProperties":true}},"required":["global","local"]}}}}},"required":["status","compute","_project"]}],"properties":{"workflow":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"base workflow schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"properties":{"description":"Array of characteristic properties calculated by this workflow (TODO: add enums)","type":"array","items":{"description":"property names, eg. `band_gaps`, `band_structure`","oneOf":[{"type":"string"},{"type":"object"}]}},"isUsingDataset":{"description":"Whether to use the dataset tab in the job designer. Mutually exclusive with using the materials tab.","type":"boolean"},"workflows":{"description":"Array of workflows with the same schema as the current one.","type":"array","items":{"type":"object"}}}}],"properties":{"subworkflows":{"description":"Array of subworkflows. Subworkflow can be an instance of workflow to allow for nesting","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Subworkflow","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"BaseFlow","type":"object","properties":{"_id":{"description":"subworkflow identity","type":"string"},"name":{"description":"Human-readable name of the subworkflow. e.g. Total-energy","type":"string"},"properties":{"description":"Array of characteristic properties calculated by this subworkflow","type":"array","items":{"description":"property names, eg. `band_gaps`, `band_structure`","oneOf":[{"type":"string"},{"type":"object"}]}},"compute":{"description":"compute parameters","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"compute arguments schema","description":"Custom keywords prefixed with validate correspond to custom validation methods implemented downstream","type":"object","properties":{"queue":{"description":"Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.","type":"string","enum":["D","OR","OF","OFplus","SR","SF","SFplus","GPOF","GP2OF","GP4OF","GPSF","GP2SF","GP4SF","OR4","OR8","OR16","SR4","SR8","SR16","GOF","G4OF","G8OF","GSF","G4SF","G8SF"]},"nodes":{"description":"number of nodes used for the job inside the RMS.","type":"integer"},"ppn":{"description":"number of CPUs used for the job inside the RMS.","type":"integer"},"timeLimit":{"description":"Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'","type":"string"},"timeLimitType":{"description":"Convention to use when reasoning about time limits","type":"string","default":"per single attempt","enum":["per single attempt","compound"]},"isRestartable":{"description":"Job is allowed to restart on termination.","type":"boolean","default":true},"notify":{"description":"Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.","type":"string"},"email":{"description":"Email address to notify about job execution.","type":"string"},"maxCPU":{"description":"Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.","type":"integer"},"arguments":{"description":"Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"quantum espresso arguments schema","type":"object","properties":{"nimage":{"description":"Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.","type":"integer","default":1,"minimum":1,"maximum":100},"npools":{"description":"Each image can be subpartitioned into `pools`, each taking care of a group of k-points.","type":"integer","default":1,"minimum":1,"maximum":100},"nband":{"description":"Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).","type":"integer","default":1,"minimum":1,"maximum":100},"ntg":{"description":"In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.","type":"integer","default":1,"minimum":1,"maximum":100},"ndiag":{"description":"A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.","type":"integer","default":1,"minimum":1,"maximum":100}},"additionalProperties":false}],"default":{}},"cluster":{"description":"Cluster where the job is executed. Optional on create. Required on job submission.","type":"object","properties":{"fqdn":{"description":"FQDN of the cluster. e.g. master-1-staging.exabyte.io","type":"string"},"jid":{"description":"Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io","type":"string"}}},"errors":{"description":"Computation error. Optional. Appears only if something happens on jobs execution.","type":"array","items":{"type":"object","properties":{"domain":{"description":"Domain of the error appearance (internal).","type":"string","enum":["rupy","alfred","celim","webapp"]},"reason":{"description":"Should be a short, unique, machine-readable error code string. e.g. FileNotFound","type":"string"},"message":{"description":"Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'","type":"string"},"traceback":{"description":"Full machine-readable error traceback. e.g. FileNotFound","type":"string"}}}},"excludeFilesPattern":{"description":"A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix","type":"string"}},"required":["queue","nodes","ppn","timeLimit"]},{"type":"null"}]}},"required":["name","units"]}],"properties":{"units":{"description":"Contains the Units of the subworkflow","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow subworkflow unit schema","type":"object","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["io"]},"subtype":{"enum":["input","output","dataFrame"]},"source":{"enum":["api","db","object_storage"]},"input":{"type":"array","items":{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO rest API input schema","type":"object","properties":{"endpoint":{"description":"rest API endpoint","type":"string"},"endpoint_options":{"description":"rest API endpoint options","type":"object"},"name":{"description":"the name of the variable in local scope to save the data under","type":"string"}},"required":["endpoint","endpoint_options"],"additionalProperties":true},{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO database input/output schema","type":"object","oneOf":[{"properties":{"ids":{"description":"IDs of item to retrieve from db","type":"array","items":{"type":"string"}}},"required":["ids"],"additionalProperties":true},{"properties":{"collection":{"description":"db collection name","type":"string"},"draft":{"description":"whether the result should be saved as draft","type":"boolean","default":true}},"required":["collection","draft"],"additionalProperties":true}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"object_storage io schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"file_metadata","type":"object","properties":{"pathname":{"description":"Relative path to the directory that contains the file.","type":"string"},"basename":{"description":"Basename of the file","type":"string","$comment":"isGenerative:true"},"filetype":{"description":"What kind of file this is, e.g. image / text","type":"string"}}}],"properties":{"objectData":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Object Storage Container Data","type":"object","properties":{"CONTAINER":{"description":"Object storage container for the file","type":"string"},"NAME":{"description":"Name of the file inside the object storage bucket","type":"string"},"PROVIDER":{"description":"Object storage provider","type":"string"},"REGION":{"description":"Region for the object container specified in Container","type":"string"},"SIZE":{"description":"Size of the file in bytes","type":"integer"},"TIMESTAMP":{"description":"Unix timestamp showing when the file was last modified","type":"string"}}},"overwrite":{"description":"if a file with the same filename already exists, whether to overwrite the old file","type":"boolean","default":false}},"required":["objectData"],"additionalProperties":true}]}}},"required":["subtype","source","input"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"reduce unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["reduce"]},"mapFlowchartId":{"description":"corresponding map unit flowchart ID","type":"string"},"input":{"description":"input information for reduce unit","type":"array","items":{"type":"object","properties":{"operation":{"description":"reduce operation, e.g. aggregate","type":"string"},"arguments":{"description":"arguments which are passed to reduce operation function","type":"array","items":{"type":"string"}}},"required":["operation","arguments"]}}},"required":["mapFlowchartId","input"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"condition unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["condition"]},"input":{"description":"Input information for condition.","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow unit input schema","type":"object","properties":{"scope":{"description":"Scope of the variable. e.g. 'global' or 'flowchart_id_2'","type":"string"},"name":{"description":"Name of the input data. e.g. total_energy","type":"string"}},"required":["scope","name"]}},"statement":{"description":"Condition statement. e.g. 'abs(x-total_energy) < 1e-5'","type":"string"},"then":{"description":"Flowchart ID reference for `then` part of the condition.","type":"string"},"else":{"description":"Flowchart ID reference for `else` part of the condition.","type":"string"},"maxOccurrences":{"description":"Maximum occurrence of the condition, usable for loops.","type":"integer"},"throwException":{"description":"Throw exception on reaching to maximum occurence.","type":"boolean"}},"required":["input","statement","then","else","maxOccurrences"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"assertion unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["assertion"]},"statement":{"type":"string","description":"The statement to be evaluated"},"errorMessage":{"type":"string","description":"The error message to be displayed if the assertion fails"}},"required":["name","statement"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"execution unit schema (base)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}],"properties":{"type":{"enum":["execution"]},"application":{"$schema":"http://json-schema.org/draft-07/schema#","title":"application schema (base)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}}]}],"properties":{"shortName":{"description":"The short name of the application. e.g. qe","type":"string"},"summary":{"description":"Application's short description.","type":"string"},"version":{"description":"Application version. e.g. 5.3.5","type":"string"},"build":{"description":"Application build. e.g. VTST","type":"string"},"hasAdvancedComputeOptions":{"description":"Whether advanced compute options are present","type":"boolean"},"isLicensed":{"description":"Whether licensing is present","type":"boolean"}},"additionalProperties":true},"executable":{"$schema":"http://json-schema.org/draft-07/schema#","title":"executable schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]}],"properties":{"name":{"description":"The name of the executable. e.g. pw.x","type":"string"},"applicationId":{"description":"_ids of the application this executable belongs to","type":"array","items":{"type":"string"}},"hasAdvancedComputeOptions":{"description":"Whether advanced compute options are present","type":"boolean"}},"required":["name"]},"flavor":{"$schema":"http://json-schema.org/draft-07/schema#","title":"flavor schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]}],"properties":{"executableId":{"description":"_id of the executable this flavor belongs to","type":"string"},"executableName":{"description":"name of the executable this flavor belongs to","type":"string"},"applicationName":{"description":"name of the application this flavor belongs to","type":"string"},"input":{"title":"execution unit input schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"execution unit input id item schema for physics-based simulation engines","type":"object","properties":{"templateId":{"type":"string"},"templateName":{"type":"string"},"name":{"description":"name of the resulting input file, if different than template name","type":"string"}},"additionalProperties":false}},"supportedApplicationVersions":{"description":"list of application versions this flavor supports","type":"array","items":{"type":"string"}}}},"input":{"description":"unit input (type to be specified by the application's execution unit)"}},"required":["input","application"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"assignment unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"scope schema","type":"object","properties":{"scope":{"type":"string"}}}],"properties":{"type":{"enum":["assignment"]},"input":{"description":"Input information for assignment. if omitted, means that it is an initialization unit, otherwise it is an assignment.","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow unit input schema","type":"object","properties":{"scope":{"description":"Scope of the variable. e.g. 'global' or 'flowchart_id_2'","type":"string"},"name":{"description":"Name of the input data. e.g. total_energy","type":"string"}},"required":["scope","name"]}},"operand":{"description":"Name of the global variable. e.g. 'x'","type":"string"},"value":{"description":"Value of the variable. The value content could be a simple integer, string or a python expression. e.g. '0' (initialization), 'sin(x)+1' (expression)","oneOf":[{"type":"string"},{"type":"boolean"},{"type":"number"}]}},"required":["name","operand","value"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"processing unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["processing"]},"operation":{"description":"Contains information about the operation used.","type":"string"},"operationType":{"description":"Contains information about the specific type of the operation used.","type":"string"},"inputData":{"description":"unit input (type to be specified by the child units)"}},"required":["operation","operationType","inputData"]}],"discriminator":{"propertyName":"type"},"required":["type"]}},"model":{"$schema":"http://json-schema.org/draft-07/schema#","title":"base model","type":"object","properties":{"type":{"description":"general type of the model, eg. `dft`","type":"string"},"subtype":{"description":"general subtype of the model, eg. `lda`","type":"string"},"method":{"$schema":"http://json-schema.org/draft-07/schema#","title":"base method","type":"object","properties":{"type":{"description":"general type of this method, eg. `pseudopotential`","type":"string"},"subtype":{"description":"general subtype of this method, eg. `ultra-soft`","type":"string"},"precision":{"description":"Object showing the actual possible precision based on theory and implementation","type":"object"},"data":{"description":"additional data specific to method, eg. array of pseudopotentials","type":"object"}},"required":["type","subtype"]}},"additionalProperties":true,"required":["type","subtype","method"]},"application":{"$schema":"http://json-schema.org/draft-07/schema#","title":"application schema (base)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}}]}],"properties":{"shortName":{"description":"The short name of the application. e.g. qe","type":"string"},"summary":{"description":"Application's short description.","type":"string"},"version":{"description":"Application version. e.g. 5.3.5","type":"string"},"build":{"description":"Application build. e.g. VTST","type":"string"},"hasAdvancedComputeOptions":{"description":"Whether advanced compute options are present","type":"boolean"},"isLicensed":{"description":"Whether licensing is present","type":"boolean"}},"additionalProperties":true},"isDraft":{"description":"Defines whether to store the results/properties extracted in this unit to properties collection","type":"boolean","default":false}},"required":["model","application"]}]}},"units":{"description":"Contains the Units of the Workflow","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow unit schema","type":"object","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["io"]},"subtype":{"enum":["input","output","dataFrame"]},"source":{"enum":["api","db","object_storage"]},"input":{"type":"array","items":{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO rest API input schema","type":"object","properties":{"endpoint":{"description":"rest API endpoint","type":"string"},"endpoint_options":{"description":"rest API endpoint options","type":"object"},"name":{"description":"the name of the variable in local scope to save the data under","type":"string"}},"required":["endpoint","endpoint_options"],"additionalProperties":true},{"$schema":"http://json-schema.org/draft-07/schema#","title":"data IO database input/output schema","type":"object","oneOf":[{"properties":{"ids":{"description":"IDs of item to retrieve from db","type":"array","items":{"type":"string"}}},"required":["ids"],"additionalProperties":true},{"properties":{"collection":{"description":"db collection name","type":"string"},"draft":{"description":"whether the result should be saved as draft","type":"boolean","default":true}},"required":["collection","draft"],"additionalProperties":true}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"object_storage io schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"file_metadata","type":"object","properties":{"pathname":{"description":"Relative path to the directory that contains the file.","type":"string"},"basename":{"description":"Basename of the file","type":"string","$comment":"isGenerative:true"},"filetype":{"description":"What kind of file this is, e.g. image / text","type":"string"}}}],"properties":{"objectData":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Object Storage Container Data","type":"object","properties":{"CONTAINER":{"description":"Object storage container for the file","type":"string"},"NAME":{"description":"Name of the file inside the object storage bucket","type":"string"},"PROVIDER":{"description":"Object storage provider","type":"string"},"REGION":{"description":"Region for the object container specified in Container","type":"string"},"SIZE":{"description":"Size of the file in bytes","type":"integer"},"TIMESTAMP":{"description":"Unix timestamp showing when the file was last modified","type":"string"}}},"overwrite":{"description":"if a file with the same filename already exists, whether to overwrite the old file","type":"boolean","default":false}},"required":["objectData"],"additionalProperties":true}]}}},"required":["subtype","source","input"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"reduce unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["reduce"]},"mapFlowchartId":{"description":"corresponding map unit flowchart ID","type":"string"},"input":{"description":"input information for reduce unit","type":"array","items":{"type":"object","properties":{"operation":{"description":"reduce operation, e.g. aggregate","type":"string"},"arguments":{"description":"arguments which are passed to reduce operation function","type":"array","items":{"type":"string"}}},"required":["operation","arguments"]}}},"required":["mapFlowchartId","input"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"condition unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["condition"]},"input":{"description":"Input information for condition.","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow unit input schema","type":"object","properties":{"scope":{"description":"Scope of the variable. e.g. 'global' or 'flowchart_id_2'","type":"string"},"name":{"description":"Name of the input data. e.g. total_energy","type":"string"}},"required":["scope","name"]}},"statement":{"description":"Condition statement. e.g. 'abs(x-total_energy) < 1e-5'","type":"string"},"then":{"description":"Flowchart ID reference for `then` part of the condition.","type":"string"},"else":{"description":"Flowchart ID reference for `else` part of the condition.","type":"string"},"maxOccurrences":{"description":"Maximum occurrence of the condition, usable for loops.","type":"integer"},"throwException":{"description":"Throw exception on reaching to maximum occurence.","type":"boolean"}},"required":["input","statement","then","else","maxOccurrences"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"assertion unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["assertion"]},"statement":{"type":"string","description":"The statement to be evaluated"},"errorMessage":{"type":"string","description":"The error message to be displayed if the assertion fails"}},"required":["name","statement"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"execution unit schema (base)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}],"properties":{"type":{"enum":["execution"]},"application":{"$schema":"http://json-schema.org/draft-07/schema#","title":"application schema (base)","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}}]}],"properties":{"shortName":{"description":"The short name of the application. e.g. qe","type":"string"},"summary":{"description":"Application's short description.","type":"string"},"version":{"description":"Application version. e.g. 5.3.5","type":"string"},"build":{"description":"Application build. e.g. VTST","type":"string"},"hasAdvancedComputeOptions":{"description":"Whether advanced compute options are present","type":"boolean"},"isLicensed":{"description":"Whether licensing is present","type":"boolean"}},"additionalProperties":true},"executable":{"$schema":"http://json-schema.org/draft-07/schema#","title":"executable schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]}],"properties":{"name":{"description":"The name of the executable. e.g. pw.x","type":"string"},"applicationId":{"description":"_ids of the application this executable belongs to","type":"array","items":{"type":"string"}},"hasAdvancedComputeOptions":{"description":"Whether advanced compute options are present","type":"boolean"}},"required":["name"]},"flavor":{"$schema":"http://json-schema.org/draft-07/schema#","title":"flavor schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]}],"properties":{"executableId":{"description":"_id of the executable this flavor belongs to","type":"string"},"executableName":{"description":"name of the executable this flavor belongs to","type":"string"},"applicationName":{"description":"name of the application this flavor belongs to","type":"string"},"input":{"title":"execution unit input schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"execution unit input id item schema for physics-based simulation engines","type":"object","properties":{"templateId":{"type":"string"},"templateName":{"type":"string"},"name":{"description":"name of the resulting input file, if different than template name","type":"string"}},"additionalProperties":false}},"supportedApplicationVersions":{"description":"list of application versions this flavor supports","type":"array","items":{"type":"string"}}}},"input":{"description":"unit input (type to be specified by the application's execution unit)"}},"required":["input","application"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"assignment unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"scope schema","type":"object","properties":{"scope":{"type":"string"}}}],"properties":{"type":{"enum":["assignment"]},"input":{"description":"Input information for assignment. if omitted, means that it is an initialization unit, otherwise it is an assignment.","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow unit input schema","type":"object","properties":{"scope":{"description":"Scope of the variable. e.g. 'global' or 'flowchart_id_2'","type":"string"},"name":{"description":"Name of the input data. e.g. total_energy","type":"string"}},"required":["scope","name"]}},"operand":{"description":"Name of the global variable. e.g. 'x'","type":"string"},"value":{"description":"Value of the variable. The value content could be a simple integer, string or a python expression. e.g. '0' (initialization), 'sin(x)+1' (expression)","oneOf":[{"type":"string"},{"type":"boolean"},{"type":"number"}]}},"required":["name","operand","value"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"processing unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["processing"]},"operation":{"description":"Contains information about the operation used.","type":"string"},"operationType":{"description":"Contains information about the specific type of the operation used.","type":"string"},"inputData":{"description":"unit input (type to be specified by the child units)"}},"required":["operation","operationType","inputData"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"map unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["map"]},"workflowId":{"description":"Id of workflow to run inside map","type":"string"},"input":{"description":"Input information for map.","type":"object","properties":{"target":{"description":"Name of the target variable to substitute using the values below. e.g. K_POINTS","type":"string"},"scope":{"description":"Scope to retrieve `values` from, global or flowchartId. Optional if `values` is given.","type":"string"},"name":{"description":"Name of the variable inside the scope to retrieve `values` from. Optional if `values` is given.","type":"string"},"values":{"description":"Sequence of values for the target Jinja variable. Optional if `scope` and `name` are given. This can be used for map-reduce type parallel execution","type":"array","items":{"oneOf":[{"type":"string"},{"type":"number"},{"type":"object"}]}},"useValues":{"type":"boolean"}},"required":["target"]}},"required":["input","workflowId"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"subworkflow unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"workflow base unit schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable runtime items in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime items schema (pre-/post-processors, monitors, results","type":"object","properties":{"preProcessors":{"description":"names of the pre-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"postProcessors":{"description":"names of the post-processors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"monitors":{"description":"names of the monitors for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}},"results":{"description":"names of the results for this calculation","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"runtime item schema","oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"name result schema","type":"object","properties":{"name":{"description":"The name of this item. e.g. scf_accuracy","type":"string"}},"required":["name"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"RuntimeItemString","description":"name of runtime item in shortened notation","type":"string"}]}}}}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"entity tags schema","type":"object","properties":{"tags":{"description":"entity tags","type":"array","items":{"type":"string"}}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"status schema","type":"object","properties":{"status":{"type":"string"},"statusTrack":{"type":"array","items":{"type":"object","properties":{"trackedAt":{"type":"number"},"status":{"type":"string"},"repetition":{"type":"number"}},"required":["trackedAt","status"]}}}}],"properties":{"_id":{"type":"string"},"isDraft":{"type":"boolean"},"type":{"description":"type of the unit","type":"string"},"name":{"description":"name of the unit. e.g. pw_scf","type":"string"},"status":{"description":"Status of the unit.","type":"string","enum":["idle","active","warning","error","finished"]},"head":{"description":"Whether this unit is the first one to be executed.","type":"boolean"},"flowchartId":{"description":"Identity of the unit in the workflow. Used to trace the execution flow of the workflow.","type":"string"},"next":{"description":"Next unit's flowchartId. If empty, the current unit is the last.","type":"string"},"enableRender":{"description":"Whether Rupy should attempt to use Jinja templating to add context variables into the unit","type":"boolean"},"context":{"type":"object"}},"additionalProperties":true,"required":["type","flowchartId"]}],"properties":{"type":{"enum":["subworkflow"]}}}],"discriminator":{"propertyName":"type"},"required":["type"]}}},"required":["units","subworkflows"]}},"required":["workflow"]},{"$id":"material/consistency-check","$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}},{"$id":"material/conventional","$schema":"http://json-schema.org/draft-07/schema#","title":"material conventional schema","type":"object","properties":{"conventional":{"type":"object"}}},{"$id":"material","$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]},{"$id":"materials-category/compound-pristine-structures/two-dimensional/interface/configuration","$schema":"http://json-schema.org/draft-07/schema#","title":"Interface Configuration Schema","description":"A two-dimensional interface between two slabs, optionally including vacuum, with a specified stacking direction.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":3,"items":[{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}],"description":"Components of the interface: slab, slab and vacuum"},"direction":{"default":"z"},"xy_shift":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 2d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2}]}],"default":[0,0],"description":"xy shift for the film as cartesian 2D vector on the xy plane."}}},{"$id":"materials-category/defective-structures/one-dimensional/grain-boundary-linear/configuration","$schema":"http://json-schema.org/draft-07/schema#","title":"Grain Boundary Linear Configuration Schema","description":"Configuration for creating a linear grain boundary.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Interface Configuration Schema","description":"A two-dimensional interface between two slabs, optionally including vacuum, with a specified stacking direction.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":3,"items":[{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}],"description":"Components of the interface: slab, slab and vacuum"},"direction":{"default":"z"},"xy_shift":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 2d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2}]}],"default":[0,0],"description":"xy shift for the film as cartesian 2D vector on the xy plane."}}}],"properties":{"stack_components":{"maxItems":2},"direction":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]}],"default":"x"},"actual_angle":{"type":"number","description":"The actual angle between the two phases","minimum":0,"maximum":360}},"required":["stack_components","direction"]},{"$id":"materials-category/defective-structures/two-dimensional/adatom/configuration","$schema":"http://json-schema.org/draft-07/schema#","title":"Adatom Defect Configuration Schema","description":"An adatom point defect configuration where an atom is added to a surface site on a slab.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Stack Configuration Schema","description":"Base configuration for a slab stack with another component and vacuum in the z-direction.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":3,"maxItems":3,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"type":"object"},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"stack_components":{"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Point Defect Site Schema","description":"A crystal site with defect information (atom or vacancy) for point defects","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Site Schema","description":"A site in a crystal that can be populated with an atom, vacancy, or void. Should be place in a target basis.","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"coordinate":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}},"required":["crystal","coordinate"]},{"type":"object","properties":{"element":{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atom Schema","description":"A chemical element that can be placed at a crystal site","type":"object","properties":{"chemical_element":{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]}},"required":["chemical_element"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacancy Schema","description":"A chemical element that can be placed at a crystal site","type":"object","properties":{"chemical_element":{"allOf":[{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}],"default":"Vac"}},"required":["chemical_element"]}]}},"required":["element"]}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]}}},{"$id":"materials-category/defective-structures/two-dimensional/grain-boundary-planar/configuration","$schema":"http://json-schema.org/draft-07/schema#","title":"Grain Boundary Planar Configuration Schema","description":"Configuration for creating a grain boundary between two phases.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Interface Configuration Schema","description":"A two-dimensional interface between two slabs, optionally including vacuum, with a specified stacking direction.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":3,"items":[{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"anyOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Strained Supercell Configuration Schema","description":"A slab structure configuration with supercell transformation and strain matrix in the xy plane","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"xy_supercell_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Supercell Matrix 2D Schema","description":"Supercell matrix for xy plane transformations","type":"array","items":{"type":"array","items":{"type":"integer"},"minItems":2,"maxItems":2},"minItems":2,"maxItems":2,"default":[[1,0],[0,1]]},"strain_matrix":{"$schema":"http://json-schema.org/draft-07/schema#","title":"matrix 3x3 schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3},"minItems":3,"maxItems":3}},"required":["xy_supercell_matrix","strain_matrix"]}]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}],"description":"Components of the interface: slab, slab and vacuum"},"direction":{"default":"z"},"xy_shift":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 2d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 2 number elements schema","type":"array","items":{"type":"number"},"minItems":2,"maxItems":2}]}],"default":[0,0],"description":"xy shift for the film as cartesian 2D vector on the xy plane."}}}],"properties":{"direction":{"default":"z"}}},{"$id":"materials-category/defective-structures/two-dimensional/island/configuration","$schema":"http://json-schema.org/draft-07/schema#","title":"Island Defect Configuration Schema","description":"An island defect configuration where a void region is created in a slab, leaving an island of material.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Stack Configuration Schema","description":"Base configuration for a slab stack with another component and vacuum in the z-direction.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":3,"maxItems":3,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]},"use_conventional_cell":{"type":"boolean","description":"Use the conventional cell for the crystal structure","default":true}},"required":["crystal"]}],"properties":{"miller_indices":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Miller Indices Schema","description":"Miller indices [h, k, l] defining crystallographic planes","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 integer elements schema","type":"array","items":{"type":"integer"},"minItems":3,"maxItems":3}],"default":[0,0,1]}},"required":["miller_indices"]}],"properties":{"termination_top":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Termination Schema","description":"Defines a specific termination of a slab","type":"object","required":["chemical_elements","space_group_symmetry_label"],"properties":{"chemical_elements":{"title":"Chemical Elements","description":"Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')","type":"string","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"type":"string","description":"A string representing a stoichiometric formula for surface atoms of a plane, e.g. 'SrTiO', 'SrO', 'O2' or 'Hf2O'","pattern":"^([A-Z][a-z]?[0-9]*)+$"}]},"space_group_symmetry_label":{"title":"Space Group Symmetry Label","description":"Space group symmetry designation for the termination","type":"string"}}},"number_of_repetitions":{"type":"integer","minimum":1,"description":"Number of repetitions of the unique atomic layers"}},"required":["termination_top","number_of_repetitions"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}},{"type":"object"},{"$schema":"http://json-schema.org/draft-07/schema#","title":"Vacuum Configuration Schema","description":"A vacuum slab that breaks periodicity in a specified direction","type":"object","properties":{"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"size":{"type":"number","description":"Size of the vacuum slab in angstroms","minimum":0,"default":10},"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"type":"string","description":"Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'"},"name":{"type":"string","description":"Name of the consistency check that is performed, which is listed in an enum."},"severity":{"enum":["info","warning","error"],"description":"Severity level of the problem, which is used in UI to differentiate."},"message":{"type":"string","description":"Message generated by the consistency check describing the problem."}},"required":["key","name","severity","message"]}],"properties":{"name":{"type":"string","enum":["default","atomsTooClose","atomsOverlap"],"description":"Name of the consistency check that is performed, which is listed in an enum."}}}}},"required":["basis","lattice"]}]}},"required":["direction","size","crystal"]}]},"direction":{"default":"z"}}}],"properties":{"stack_components":{"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Slab Configuration Schema","description":"A slab unit cell consisting of repeated unique atomic layers and vacuum.","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Stack Schema","description":"A stack of components in a certain direction. The specific types of components should be defined by the inheriting schema.","type":"object","properties":{"stack_components":{"type":"array"},"direction":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Axis Enum","type":"string","description":"Enum for axis types","enum":["x","y","z"]},"gaps":{"description":"Gap distances between stack components as array of objects with id and value","type":"array","items":{"allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"number"}}}}},"required":["stack_components","direction"]}],"properties":{"stack_components":{"type":"array","minItems":2,"maxItems":2,"items":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Atomic Layers Unique Repeated Schema","description":"Atomic layers unique with an integer number of repetitions, forming a full periodic structure with top layer specified by the termination","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Planes Schema","description":"A set of all possible planes in a crystal defined by Miller indices","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Lattice Base Schema","description":"Base schema for crystal lattice structures defined by crystal and miller indices","type":"object","properties":{"crystal":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Crystal Schema","description":"A crystal structure, referencing the base material schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"material schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Named defaultable has metadata in-memory entity schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"Base in-memory entity schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"schema version","type":"object","properties":{"schemaVersion":{"description":"entity's schema version. Used to distinct between different schemas.","type":"string","default":"2022.8.16"}}}],"properties":{"_id":{"description":"entity identity","type":"string"},"slug":{"description":"entity slug","type":"string"},"systemName":{"type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"name entity schema","type":"object","properties":{"name":{"description":"entity name","type":"string"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"defaultable entity schema","type":"object","properties":{"isDefault":{"description":"Identifies that entity is defaultable","type":"boolean","default":false}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"metadata schema","type":"object","properties":{"metadata":{"type":"object"}}}]}],"properties":{"formula":{"description":"reduced chemical formula","type":"string"},"unitCellFormula":{"description":"chemical formula based on the number of atoms of each element in the supercell","type":"string"},"basis":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis schema","type":"object","properties":{"elements":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic elements schema","description":"atomic elements schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic element schema","description":"chemical element of an atom according to the periodic table","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic string schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"type":"string"}}}],"properties":{"value":{"description":"All elements, including extra elements","anyOf":[{"enum":["H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og"]},{"description":"Extra elements, used for convenience purposed","enum":["X","Vac"]}]}}}},"coordinates":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinates schema","description":"atomic coordinates schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic coordinate schema","description":"coordinate of an atom","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"$schema":"http://json-schema.org/draft-07/schema#","title":"coordinate 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]}}}},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"basis units enum","allOf":[{"enum":["crystal","cartesian"],"default":"crystal"}]},"labels":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic labels schema","description":"atomic labels schema","type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"atomic label schema","description":"Optional label (e.g., 1, 2, as in Fe1, Fe2) to distinguish species, e.g. to have magnetic moment.","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id and value schema","description":"object containing integer id and value each","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"object with id","description":"object containing integer id","type":"object","properties":{"id":{"description":"integer id of this entry","type":"integer"}},"required":["id"]}],"properties":{"value":{"description":"value of this entry"}},"required":["id","value"]}],"properties":{"value":{"anyOf":[{"type":["integer","string","number"]},{"$schema":"http://json-schema.org/draft-07/schema#","title":"integer positive single digit","type":"integer","minimum":1,"maximum":9}]}}}}},"required":["elements","coordinates"]},"lattice":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice schema","type":"object","properties":{"a":{"description":"length of the first lattice vector","type":"number"},"b":{"description":"length of the second lattice vector","type":"number"},"c":{"description":"length of the third lattice vector","type":"number"},"alpha":{"description":"angle between first and second lattice vector","type":"number"},"beta":{"description":"angle between second and third lattice vector","type":"number"},"gamma":{"description":"angle between first and third lattice vector","type":"number"},"vectors":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors schema","type":"object","properties":{"a":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"b":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"c":{"$schema":"http://json-schema.org/draft-07/schema#","title":"vector 3d schema","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"array of 3 number elements schema","type":"array","items":{"type":"number"},"minItems":3,"maxItems":3}]},"alat":{"description":"lattice parameter for fractional coordinates","type":"number","default":1},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice vectors units enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]}},"required":["a","b","c"]},"type":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice type enum","type":"string","enum":["CUB","BCC","FCC","TET","MCL","ORC","ORCC","ORCF","ORCI","HEX","BCT","TRI","MCLC","RHL"],"default":"TRI"},"units":{"$schema":"http://json-schema.org/draft-07/schema#","title":"Lattice units schema","type":"object","properties":{"length":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units length enum","allOf":[{"enum":["angstrom","bohr"],"default":"angstrom"}]},"angle":{"$schema":"http://json-schema.org/draft-07/schema#","title":"lattice units angle enum","allOf":[{"enum":["degree","radian"],"default":"degree"}]}},"default":{"length":"angstrom","angle":"degree"}}},"required":["a","b","c","alpha","beta","gamma"]},"derivedProperties":{"$schema":"http://json-schema.org/draft-07/schema#","title":"derived properties schema","type":"array","items":{"oneOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"volume schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["volume"]},"units":{"enum":["angstrom^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"density schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["density"]},"units":{"enum":["g/cm^3"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"symmetry schema","type":"object","properties":{"pointGroupSymbol":{"description":"point group symbol in Schoenflies notation","type":"string"},"spaceGroupSymbol":{"description":"space group symbol in Hermann–Mauguin notation","type":"string"},"tolerance":{"type":"object","description":"tolerance used for symmetry calculation","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"units":{"enum":["angstrom"]}}},"name":{"enum":["symmetry"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"elemental-ratio","description":"ration of this element in the compound","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["elemental_ratio"]},"value":{"type":"number","minimum":0,"maximum":1},"element":{"type":"string","description":"the element this ratio is for"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"p_norm","description":"https://en.wikipedia.org/wiki/Norm_(mathematics)#p-norm","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"scalar schema","type":"object","properties":{"value":{"type":"number"}},"required":["value"]}],"properties":{"name":{"enum":["p-norm"]},"degree":{"type":"integer","description":"degree of the dimensionality of the norm"}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi"]}}},{"$schema":"http://json-schema.org/draft-07/schema#","title":"InChI key representation schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"PrimitiveString","type":"object","properties":{"value":{"type":"string"}},"required":["value"]}],"properties":{"name":{"enum":["inchi_key"]}}}],"discriminator":{"propertyName":"name"},"required":["name"]}},"external":{"$schema":"http://json-schema.org/draft-07/schema#","title":"database source schema","description":"information about a database source","type":"object","properties":{"id":{"description":"ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32","oneOf":[{"type":"string"},{"type":"number"}]},"source":{"description":"Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.","type":"string"},"origin":{"description":"Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).","type":"boolean"},"data":{"description":"Original response from external source.","type":"object"},"doi":{"description":"Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506","type":"string"},"url":{"description":"The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers","type":"string"}},"required":["id","source","origin"]},"src":{"$schema":"http://json-schema.org/draft-07/schema#","title":"file source schema","description":"file source with the information inside","type":"object","properties":{"extension":{"description":"file extension","type":"string"},"filename":{"description":"file name without extension","type":"string"},"text":{"description":"file content as raw text","type":"string"},"hash":{"description":"MD5 hash based on file content","type":"string"}},"required":["filename","text","hash"]},"scaledHash":{"description":"Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).","type":"string"},"icsdId":{"description":"Corresponding ICSD id of the material","type":"integer"},"isNonPeriodic":{"description":"Whether to work in the finite molecular picture (usually with atomic orbital basis)","type":"boolean"},"consistencyChecks":{"type":"array","items":{"$schema":"http://json-schema.org/draft-07/schema#","title":"material consistency check schema","type":"object","allOf":[{"$schema":"http://json-schema.org/draft-07/schema#","title":"consistency check","type":"object","description":"The output of consistency checks performed on data adhering to JSON schema, but inconsistent with scientific or logical rules, to show problems in UI.","properties":{"key":{"ty