# generated by datamodel-codegen:
#   filename:  apse/db/nist_jarvis/2024.3.13/db_entry.json
#   version:   0.28.5

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field, RootModel


class ArrayOf3NumberElementsSchema(RootModel[List[float]]):
    root: List[float] = Field(..., title="array of 3 number elements schema")


class NISTJARVISAtomsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    lattice_mat: Optional[List[ArrayOf3NumberElementsSchema]] = Field(None, max_length=3, min_length=3)
    """
    Crystal lattice vectors as a 3x3 matrix, in Angstroms
    """
    coords: Optional[List[ArrayOf3NumberElementsSchema]] = Field(None, min_length=1)
    """
    Atomic coordinates for each atom in the unit cell
    """
    elements: Optional[List[str]] = Field(None, min_length=1)
    """
    Atomic elements for each atom in the unit cell in the same order as `coords`
    """
    abc: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="array of 3 number elements schema")
    angles: Optional[List[float]] = Field(None, max_length=3, min_length=3, title="array of 3 number elements schema")
    cartesian: Optional[bool] = None
    """
    True if the coordinates are in Cartesian space, false if in fractional space
    """
    props: Optional[List[str]] = None
    """
    Additional properties for each of the atoms
    """


class NISTJARVISDbEntrySchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    atoms: Optional[NISTJARVISAtomsSchema] = Field(None, title="NIST JARVIS Atoms schema")
    """
    NIST J.A.R.V.I.S. db entry `atoms` key schema. Based on https://figshare.com/articles/dataset/Monolayer_data_for_heterostructure/22344571
    """
    jid: Optional[str] = None
    """
    The id of the entry in the database, e.g. JVASP-677
    """
