# generated by datamodel-codegen:
#   filename:  apse/file/applications/espresso/7.2/pw.x/electrons.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field


class MixingMode(Enum):
    plain = "plain"
    TF = "TF"
    local_TF = "local-TF"


class Diagonalization(Enum):
    david = "david"
    cg = "cg"
    ppcg = "ppcg"
    paro = "paro"
    ParO = "ParO"
    rmm_davidson = "rmm-davidson"
    rmm_paro = "rmm-paro"


class EfieldPhase(Enum):
    read = "read"
    write = "write"
    none = "none"


class Startingpot(Enum):
    atomic = "atomic"
    file = "file"


class Startingwfc(Enum):
    atomic = "atomic"
    atomic_random = "atomic+random"
    random = "random"
    file = "file"


class ElectronsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    electron_maxstep: Optional[int] = 100
    """
    maximum number of iterations in a scf step. If exact exchange is active, this will affect the inner loops.
    """
    exx_maxstep: Optional[int] = 100
    """
    maximum number of outer iterations in a scf calculation with exact exchange.
    """
    scf_must_converge: Optional[bool] = True
    """
    If .false. do not stop molecular dynamics or ionic relaxation when electron_maxstep is reached. Use with care.
    """
    conv_thr: Optional[float] = None
    adaptive_thr: Optional[bool] = False
    """
    If .TRUE. this turns on the use of an adaptive conv_thr for the inner scf loops when using EXX.
    """
    conv_thr_init: Optional[float] = None
    """
    When adaptive_thr = .TRUE. this is the convergence threshold used for the first scf cycle.
    """
    conv_thr_multi: Optional[float] = None
    """
    When adaptive_thr = .TRUE. the convergence threshold for each scf cycle is given by: max( conv_thr, conv_thr_multi * dexx )
    """
    mixing_mode: Optional[MixingMode] = "plain"
    mixing_beta: Optional[float] = None
    """
    mixing factor for self-consistency
    """
    mixing_ndim: Optional[int] = 8
    """
    number of iterations used in mixing scheme
    """
    mixing_fixed_ns: Optional[int] = 0
    """
    For DFT+U : number of iterations with fixed ns ( ns is the atomic density appearing in the Hubbard term ).
    """
    diagonalization: Optional[Diagonalization] = "david"
    diago_thr_init: Optional[float] = None
    """
    Convergence threshold (ethr) for iterative diagonalization (the check is on eigenvalue convergence).
    """
    diago_cg_maxiter: Optional[int] = None
    """
    For conjugate gradient diagonalization:  max number of iterations
    """
    diago_ppcg_maxiter: Optional[int] = None
    """
    For ppcg diagonalization:  max number of iterations
    """
    diago_david_ndim: Optional[int] = 2
    """
    For Davidson diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed).
    """
    diago_rmm_ndim: Optional[int] = 4
    """
    For RMM-DIIS diagonalization: dimension of workspace (number of wavefunction packets, at least 2 needed).
    """
    diago_rmm_conv: Optional[bool] = False
    """
    If .TRUE., RMM-DIIS is performed up to converge. If .FALSE., RMM-DIIS is performed only once.
    """
    diago_gs_nblock: Optional[int] = 16
    """
    For RMM-DIIS diagonalization: blocking size of Gram-Schmidt orthogonalization
    """
    diago_full_acc: Optional[bool] = False
    """
    If .TRUE. all the empty states are diagonalized at the same level of accuracy of the occupied ones. Otherwise the empty states are diagonalized using a larger threshold (this should not affect total energy, forces, and other ground-state properties).
    """
    efield: Optional[float] = None
    """
    Amplitude of the finite electric field (in Ry a.u.; 1 a.u. = 36.3609*10^10 V/m). Used only if lelfield==.TRUE. and if k-points (K_POINTS card) are not automatic.
    """
    efield_cart: Optional[List[float]] = Field(
        None, max_length=3, min_length=3, title="array of 3 number elements schema"
    )
    efield_phase: Optional[EfieldPhase] = "none"
    startingpot: Optional[Startingpot] = None
    startingwfc: Optional[Startingwfc] = "atomic+random"
    tqr: Optional[bool] = False
    """
    If .true., use a real-space algorithm for augmentation charges of ultrasoft pseudopotentials and PAWsets. Faster but numerically less accurate than the default G-space algorithm. Use with care and after testing!
    """
    real_space: Optional[bool] = False
    """
    If .true., exploit real-space localization to compute matrix elements for nonlocal projectors. Faster and in principle better scaling than the default G-space algorithm, but numerically less accurate, may lead to some loss of translational invariance. Use with care and after testing!
    """
