# generated by datamodel-codegen:
#   filename:  core/reusable/atomic_data/per_orbital_pair.json
#   version:   0.28.5

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, constr


class AtomicDataPerOrbitalPair(BaseModel):
    id: Optional[int] = None
    """
    Site number or index in the lattice
    """
    id2: Optional[int] = None
    """
    Site number or index in the lattice of second site
    """
    atomicSpecies: Optional[constr(pattern=r"^[a-zA-Z]{1,2}[\d+]?$")] = None
    """
    Example: Co1, Mn
    """
    atomicSpecies2: Optional[constr(pattern=r"^[a-zA-Z]{1,2}[\d+]?$")] = None
    """
    Example: Co2, O
    """
    orbitalName: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    orbitalName2: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    distance: Optional[float] = None
    """
    Distance between two sites in Bohr.
    """
