# generated by datamodel-codegen:
#   filename:  job.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, conint


class Type(Enum):
    io = "io"


class Subtype(Enum):
    input = "input"
    output = "output"
    dataFrame = "dataFrame"


class Source(Enum):
    api = "api"
    db = "db"
    object_storage = "object_storage"


class DataIORestAPIInputSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    endpoint: str
    """
    rest API endpoint
    """
    endpoint_options: Dict[str, Any]
    """
    rest API endpoint options
    """
    name: Optional[str] = None
    """
    the name of the variable in local scope to save the data under
    """


class DataIODatabaseInputOutputSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    ids: List[str]
    """
    IDs of item to retrieve from db
    """


class DataIODatabaseInputOutputSchema5(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    collection: str
    """
    db collection name
    """
    draft: Optional[bool] = True
    """
    whether the result should be saved as draft
    """


class ObjectStorageContainerData(BaseModel):
    CONTAINER: Optional[str] = None
    """
    Object storage container for the file
    """
    NAME: Optional[str] = None
    """
    Name of the file inside the object storage bucket
    """
    PROVIDER: Optional[str] = None
    """
    Object storage provider
    """
    REGION: Optional[str] = None
    """
    Region for the object container specified in Container
    """
    SIZE: Optional[int] = None
    """
    Size of the file in bytes
    """
    TIMESTAMP: Optional[str] = None
    """
    Unix timestamp showing when the file was last modified
    """


class ObjectStorageIoSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    objectData: ObjectStorageContainerData = Field(..., title="Object Storage Container Data")
    overwrite: Optional[bool] = False
    """
    if a file with the same filename already exists, whether to overwrite the old file
    """
    pathname: Optional[str] = None
    """
    Relative path to the directory that contains the file.
    """
    basename: Optional[str] = None
    """
    Basename of the file
    """
    filetype: Optional[str] = None
    """
    What kind of file this is, e.g. image / text
    """


class Status(Enum):
    idle = "idle"
    active = "active"
    warning = "warning"
    error = "error"
    finished = "finished"


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class StatusTrackItem(BaseModel):
    trackedAt: float
    status: str
    repetition: Optional[float] = None


class DataIOUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    subtype: Subtype
    source: Source
    input: List[
        Union[
            DataIORestAPIInputSchema,
            Union[DataIODatabaseInputOutputSchema, DataIODatabaseInputOutputSchema5],
            ObjectStorageIoSchema,
        ]
    ]
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type26(Enum):
    reduce = "reduce"


class InputItem(BaseModel):
    operation: str
    """
    reduce operation, e.g. aggregate
    """
    arguments: List[str]
    """
    arguments which are passed to reduce operation function
    """


class ReduceUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    mapFlowchartId: str
    """
    corresponding map unit flowchart ID
    """
    input: List[InputItem]
    """
    input information for reduce unit
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type27(Enum):
    condition = "condition"


class WorkflowUnitInputSchema(BaseModel):
    scope: str
    """
    Scope of the variable. e.g. 'global' or 'flowchart_id_2'
    """
    name: str
    """
    Name of the input data. e.g. total_energy
    """


class ConditionUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["2#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    input: List[WorkflowUnitInputSchema]
    """
    Input information for condition.
    """
    statement: str
    """
    Condition statement. e.g. 'abs(x-total_energy) < 1e-5'
    """
    then: str
    """
    Flowchart ID reference for `then` part of the condition.
    """
    else_: str = Field(..., alias="else")
    """
    Flowchart ID reference for `else` part of the condition.
    """
    maxOccurrences: int
    """
    Maximum occurrence of the condition, usable for loops.
    """
    throwException: Optional[bool] = None
    """
    Throw exception on reaching to maximum occurence.
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type28(Enum):
    assertion = "assertion"


class AssertionUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    statement: str
    """
    The statement to be evaluated
    """
    errorMessage: Optional[str] = None
    """
    The error message to be displayed if the assertion fails
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type29(Enum):
    execution = "execution"


class ApplicationSchemaBase(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    summary: Optional[str] = None
    """
    Application's short description.
    """
    version: Optional[str] = None
    """
    Application version. e.g. 5.3.5
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """


class ExecutableSchema(BaseModel):
    name: str
    """
    The name of the executable. e.g. pw.x
    """
    applicationId: Optional[List[str]] = None
    """
    _ids of the application this executable belongs to
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    templateId: Optional[str] = None
    templateName: Optional[str] = None
    name: Optional[str] = None
    """
    name of the resulting input file, if different than template name
    """


class FlavorSchema(BaseModel):
    executableId: Optional[str] = None
    """
    _id of the executable this flavor belongs to
    """
    executableName: Optional[str] = None
    """
    name of the executable this flavor belongs to
    """
    applicationName: Optional[str] = None
    """
    name of the application this flavor belongs to
    """
    input: Optional[List[ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines]] = Field(
        None, title="execution unit input schema"
    )
    supportedApplicationVersions: Optional[List[str]] = None
    """
    list of application versions this flavor supports
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class ExecutionUnitSchemaBase(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    application: ApplicationSchemaBase = Field(..., title="application schema (base)")
    executable: Optional[ExecutableSchema] = Field(None, title="executable schema")
    flavor: Optional[FlavorSchema] = Field(None, title="flavor schema")
    input: Any
    """
    unit input (type to be specified by the application's execution unit)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type30(Enum):
    assignment = "assignment"


class AssignmentUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    input: List[WorkflowUnitInputSchema]
    """
    Input information for assignment. if omitted, means that it is an initialization unit, otherwise it is an assignment.
    """
    operand: str
    """
    Name of the global variable. e.g. 'x'
    """
    value: Union[str, bool, float]
    """
    Value of the variable. The value content could be a simple integer, string or a python expression. e.g. '0' (initialization), 'sin(x)+1' (expression)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None
    scope: Optional[str] = None


class Type31(Enum):
    processing = "processing"


class ProcessingUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    operation: str
    """
    Contains information about the operation used.
    """
    operationType: str
    """
    Contains information about the specific type of the operation used.
    """
    inputData: Any
    """
    unit input (type to be specified by the child units)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class WorkflowSubworkflowUnitSchema(
    RootModel[
        Union[
            DataIOUnitSchema,
            ReduceUnitSchema,
            ConditionUnitSchema,
            AssertionUnitSchema,
            ExecutionUnitSchemaBase,
            AssignmentUnitSchema,
            ProcessingUnitSchema,
        ]
    ]
):
    root: Union[
        DataIOUnitSchema,
        ReduceUnitSchema,
        ConditionUnitSchema,
        AssertionUnitSchema,
        ExecutionUnitSchemaBase,
        AssignmentUnitSchema,
        ProcessingUnitSchema,
    ] = Field(..., discriminator="type", title="workflow subworkflow unit schema")


class BaseMethod(BaseModel):
    type: str
    """
    general type of this method, eg. `pseudopotential`
    """
    subtype: str
    """
    general subtype of this method, eg. `ultra-soft`
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    data: Optional[Dict[str, Any]] = None
    """
    additional data specific to method, eg. array of pseudopotentials
    """


class BaseModelModel(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: str
    """
    general type of the model, eg. `dft`
    """
    subtype: str
    """
    general subtype of the model, eg. `lda`
    """
    method: BaseMethod = Field(..., title="base method")


class Queue(Enum):
    D = "D"
    OR = "OR"
    OF = "OF"
    OFplus = "OFplus"
    SR = "SR"
    SF = "SF"
    SFplus = "SFplus"
    GPOF = "GPOF"
    GP2OF = "GP2OF"
    GP4OF = "GP4OF"
    GPSF = "GPSF"
    GP2SF = "GP2SF"
    GP4SF = "GP4SF"
    OR4 = "OR4"
    OR8 = "OR8"
    OR16 = "OR16"
    SR4 = "SR4"
    SR8 = "SR8"
    SR16 = "SR16"
    GOF = "GOF"
    G4OF = "G4OF"
    G8OF = "G8OF"
    GSF = "GSF"
    G4SF = "G4SF"
    G8SF = "G8SF"


class TimeLimitType(Enum):
    per_single_attempt = "per single attempt"
    compound = "compound"


class QuantumEspressoArgumentsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    nimage: Optional[conint(ge=1, le=100)] = 1
    """
    Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.
    """
    npools: Optional[conint(ge=1, le=100)] = 1
    """
    Each image can be subpartitioned into `pools`, each taking care of a group of k-points.
    """
    nband: Optional[conint(ge=1, le=100)] = 1
    """
    Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).
    """
    ntg: Optional[conint(ge=1, le=100)] = 1
    """
    In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.
    """
    ndiag: Optional[conint(ge=1, le=100)] = 1
    """
    A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.
    """


class Cluster(BaseModel):
    fqdn: Optional[str] = None
    """
    FQDN of the cluster. e.g. master-1-staging.exabyte.io
    """
    jid: Optional[str] = None
    """
    Job's identity in RMS. e.g. 1234.master-1-staging.exabyte.io
    """


class Domain(Enum):
    rupy = "rupy"
    alfred = "alfred"
    celim = "celim"
    webapp = "webapp"


class Error(BaseModel):
    domain: Optional[Domain] = None
    """
    Domain of the error appearance (internal).
    """
    reason: Optional[str] = None
    """
    Should be a short, unique, machine-readable error code string. e.g. FileNotFound
    """
    message: Optional[str] = None
    """
    Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'
    """
    traceback: Optional[str] = None
    """
    Full machine-readable error traceback. e.g. FileNotFound
    """


class ComputeArgumentsSchema(BaseModel):
    queue: Queue
    """
    Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.
    """
    nodes: int
    """
    number of nodes used for the job inside the RMS.
    """
    ppn: int
    """
    number of CPUs used for the job inside the RMS.
    """
    timeLimit: str
    """
    Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'
    """
    timeLimitType: Optional[TimeLimitType] = "per single attempt"
    """
    Convention to use when reasoning about time limits
    """
    isRestartable: Optional[bool] = True
    """
    Job is allowed to restart on termination.
    """
    notify: Optional[str] = None
    """
    Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.
    """
    email: Optional[str] = None
    """
    Email address to notify about job execution.
    """
    maxCPU: Optional[int] = None
    """
    Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.
    """
    arguments: Optional[QuantumEspressoArgumentsSchema] = Field({}, title="quantum espresso arguments schema")
    """
    Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere
    """
    cluster: Optional[Cluster] = None
    """
    Cluster where the job is executed. Optional on create. Required on job submission.
    """
    errors: Optional[List[Error]] = None
    """
    Computation error. Optional. Appears only if something happens on jobs execution.
    """
    excludeFilesPattern: Optional[str] = None
    """
    A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix
    """


class Subworkflow(BaseModel):
    units: List[WorkflowSubworkflowUnitSchema]
    """
    Contains the Units of the subworkflow
    """
    model: BaseModelModel = Field(..., title="base model")
    application: ApplicationSchemaBase = Field(..., title="application schema (base)")
    isDraft: Optional[bool] = False
    """
    Defines whether to store the results/properties extracted in this unit to properties collection
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    subworkflow identity
    """
    name: str
    """
    Human-readable name of the subworkflow. e.g. Total-energy
    """
    properties: Optional[List[Union[str, Dict[str, Any]]]] = None
    """
    Array of characteristic properties calculated by this subworkflow
    """
    compute: Optional[ComputeArgumentsSchema] = None
    """
    compute parameters
    """


class Type32(Enum):
    io = "io"


class DataIODatabaseInputOutputSchema6(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    ids: List[str]
    """
    IDs of item to retrieve from db
    """


class DataIODatabaseInputOutputSchema7(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    collection: str
    """
    db collection name
    """
    draft: Optional[bool] = True
    """
    whether the result should be saved as draft
    """


class ObjectStorageIoSchema2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    objectData: ObjectStorageContainerData = Field(..., title="Object Storage Container Data")
    overwrite: Optional[bool] = False
    """
    if a file with the same filename already exists, whether to overwrite the old file
    """
    pathname: Optional[str] = None
    """
    Relative path to the directory that contains the file.
    """
    basename: Optional[str] = None
    """
    Basename of the file
    """
    filetype: Optional[str] = None
    """
    What kind of file this is, e.g. image / text
    """


class DataIOUnitSchema2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    subtype: Subtype
    source: Source
    input: List[
        Union[
            DataIORestAPIInputSchema,
            Union[DataIODatabaseInputOutputSchema6, DataIODatabaseInputOutputSchema7],
            ObjectStorageIoSchema2,
        ]
    ]
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type33(Enum):
    reduce = "reduce"


class ReduceUnitSchema1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    mapFlowchartId: str
    """
    corresponding map unit flowchart ID
    """
    input: List[InputItem]
    """
    input information for reduce unit
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type34(Enum):
    condition = "condition"


class ConditionUnitSchema2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["2#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    input: List[WorkflowUnitInputSchema]
    """
    Input information for condition.
    """
    statement: str
    """
    Condition statement. e.g. 'abs(x-total_energy) < 1e-5'
    """
    then: str
    """
    Flowchart ID reference for `then` part of the condition.
    """
    else_: str = Field(..., alias="else")
    """
    Flowchart ID reference for `else` part of the condition.
    """
    maxOccurrences: int
    """
    Maximum occurrence of the condition, usable for loops.
    """
    throwException: Optional[bool] = None
    """
    Throw exception on reaching to maximum occurence.
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type35(Enum):
    assertion = "assertion"


class AssertionUnitSchema2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    statement: str
    """
    The statement to be evaluated
    """
    errorMessage: Optional[str] = None
    """
    The error message to be displayed if the assertion fails
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type36(Enum):
    execution = "execution"


class ExecutableSchema5(BaseModel):
    name: str
    """
    The name of the executable. e.g. pw.x
    """
    applicationId: Optional[List[str]] = None
    """
    _ids of the application this executable belongs to
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class FlavorSchema5(BaseModel):
    executableId: Optional[str] = None
    """
    _id of the executable this flavor belongs to
    """
    executableName: Optional[str] = None
    """
    name of the executable this flavor belongs to
    """
    applicationName: Optional[str] = None
    """
    name of the application this flavor belongs to
    """
    input: Optional[List[ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines]] = Field(
        None, title="execution unit input schema"
    )
    supportedApplicationVersions: Optional[List[str]] = None
    """
    list of application versions this flavor supports
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """


class ExecutionUnitSchemaBase2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    application: ApplicationSchemaBase = Field(..., title="application schema (base)")
    executable: Optional[ExecutableSchema5] = Field(None, title="executable schema")
    flavor: Optional[FlavorSchema5] = Field(None, title="flavor schema")
    input: Any
    """
    unit input (type to be specified by the application's execution unit)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type37(Enum):
    assignment = "assignment"


class AssignmentUnitSchema2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    input: List[WorkflowUnitInputSchema]
    """
    Input information for assignment. if omitted, means that it is an initialization unit, otherwise it is an assignment.
    """
    operand: str
    """
    Name of the global variable. e.g. 'x'
    """
    value: Union[str, bool, float]
    """
    Value of the variable. The value content could be a simple integer, string or a python expression. e.g. '0' (initialization), 'sin(x)+1' (expression)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None
    scope: Optional[str] = None


class Type38(Enum):
    processing = "processing"


class ProcessingUnitSchema1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    operation: str
    """
    Contains information about the operation used.
    """
    operationType: str
    """
    Contains information about the specific type of the operation used.
    """
    inputData: Any
    """
    unit input (type to be specified by the child units)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type39(Enum):
    map = "map"


class Input(BaseModel):
    target: str
    """
    Name of the target variable to substitute using the values below. e.g. K_POINTS
    """
    scope: Optional[str] = None
    """
    Scope to retrieve `values` from, global or flowchartId. Optional if `values` is given.
    """
    name: Optional[str] = None
    """
    Name of the variable inside the scope to retrieve `values` from. Optional if `values` is given.
    """
    values: Optional[List[Union[str, float, Dict[str, Any]]]] = None
    """
    Sequence of values for the target Jinja variable. Optional if `scope` and `name` are given. This can be used for map-reduce type parallel execution
    """
    useValues: Optional[bool] = None


class MapUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["7#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    workflowId: str
    """
    Id of workflow to run inside map
    """
    input: Input
    """
    Input information for map.
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class Type40(Enum):
    subworkflow = "subworkflow"


class SubworkflowUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Literal["8#-datamodel-code-generator-#-object-#-special-#"]
    """
    type of the unit
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: str
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None


class WorkflowUnitSchema(
    RootModel[
        Union[
            DataIOUnitSchema2,
            ReduceUnitSchema1,
            ConditionUnitSchema2,
            AssertionUnitSchema2,
            ExecutionUnitSchemaBase2,
            AssignmentUnitSchema2,
            ProcessingUnitSchema1,
            MapUnitSchema,
            SubworkflowUnitSchema,
        ]
    ]
):
    root: Union[
        DataIOUnitSchema2,
        ReduceUnitSchema1,
        ConditionUnitSchema2,
        AssertionUnitSchema2,
        ExecutionUnitSchemaBase2,
        AssignmentUnitSchema2,
        ProcessingUnitSchema1,
        MapUnitSchema,
        SubworkflowUnitSchema,
    ] = Field(..., discriminator="type", title="workflow unit schema")


class WorkflowSchema(BaseModel):
    subworkflows: List[Subworkflow]
    """
    Array of subworkflows. Subworkflow can be an instance of workflow to allow for nesting
    """
    units: List[WorkflowUnitSchema]
    """
    Contains the Units of the Workflow
    """
    properties: Optional[List[Union[str, Dict[str, Any]]]] = None
    """
    Array of characteristic properties calculated by this workflow (TODO: add enums)
    """
    isUsingDataset: Optional[bool] = None
    """
    Whether to use the dataset tab in the job designer. Mutually exclusive with using the materials tab.
    """
    workflows: Optional[List[Dict[str, Any]]] = None
    """
    Array of workflows with the same schema as the current one.
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class Status25(Enum):
    pre_submission = "pre-submission"
    queued = "queued"
    submitted = "submitted"
    active = "active"
    finished = "finished"
    terminate_queued = "terminate-queued"
    terminated = "terminated"
    error = "error"
    deleted = "deleted"
    timeout = "timeout"


class Error4(BaseModel):
    domain: Optional[Domain] = None
    """
    Domain of the error appearance (internal).
    """
    reason: Optional[str] = None
    """
    Should be a short, unique, machine-readable error code string. e.g. FileNotFound
    """
    message: Optional[str] = None
    """
    Human-readable error message. e.g. 'File Not Found: /home/demo/data/project1/job-123/job-config.json'
    """
    traceback: Optional[str] = None
    """
    Full machine-readable error traceback. e.g. FileNotFound
    """


class ComputeArgumentsSchema4(BaseModel):
    queue: Queue
    """
    Name of the submission queues: https://docs.mat3ra.com/infrastructure/resource/queues/. Below enums are for Azure, then AWS circa 2022-08, hence the duplication.
    """
    nodes: int
    """
    number of nodes used for the job inside the RMS.
    """
    ppn: int
    """
    number of CPUs used for the job inside the RMS.
    """
    timeLimit: str
    """
    Wallclock time limit for computing a job. Clock format: 'hh:mm:ss'
    """
    timeLimitType: Optional[TimeLimitType] = "per single attempt"
    """
    Convention to use when reasoning about time limits
    """
    isRestartable: Optional[bool] = True
    """
    Job is allowed to restart on termination.
    """
    notify: Optional[str] = None
    """
    Email notification for the job: n - never, a - job aborted, b - job begins, e - job ends. Last three could be combined.
    """
    email: Optional[str] = None
    """
    Email address to notify about job execution.
    """
    maxCPU: Optional[int] = None
    """
    Maximum CPU count per node. This parameter is used to let backend job submission infrastructure know that this job is to be charged for the maximum CPU per node instead of the actual ppn. For premium/fast queues where resources are provisioned on-demand and exclusively per user.
    """
    arguments: Optional[QuantumEspressoArgumentsSchema] = Field({}, title="quantum espresso arguments schema")
    """
    Optional arguments specific to using application - VASP, Quantum Espresso, etc. Specified elsewhere
    """
    cluster: Optional[Cluster] = None
    """
    Cluster where the job is executed. Optional on create. Required on job submission.
    """
    errors: Optional[List[Error4]] = None
    """
    Computation error. Optional. Appears only if something happens on jobs execution.
    """
    excludeFilesPattern: Optional[str] = None
    """
    A Python compatible regex to exclude files from upload. e.g. ^.*.txt& excludes all files with .txt suffix
    """


class EntityReferenceSchema(BaseModel):
    field_id: str = Field(..., alias="_id")
    """
    entity identity
    """
    cls: Optional[str] = None
    """
    entity class
    """
    slug: Optional[str] = None
    """
    entity slug
    """


class WorkflowScopeSchema(BaseModel):
    global_: Dict[str, Any] = Field(..., alias="global")
    local: Dict[str, Any]


class ScopeTrackItem(BaseModel):
    repetition: Optional[float] = None
    scope: Optional[WorkflowScopeSchema] = Field(None, title="workflow scope schema")


class JobSchema(BaseModel):
    workflow: WorkflowSchema = Field(..., title="workflow schema")
    rmsId: Optional[str] = None
    """
    Identity used to track jobs originated from command-line
    """
    status: Status25
    """
    job status
    """
    startTime: Optional[str] = None
    """
    Approximate start time of the job. e.g. within 10 min
    """
    workDir: Optional[str] = None
    """
    The path to the working directory of this job, when the job originates from command-line
    """
    compute: ComputeArgumentsSchema4 = Field(..., title="compute arguments schema")
    """
    Custom keywords prefixed with validate correspond to custom validation methods implemented downstream
    """
    field_project: EntityReferenceSchema = Field(..., alias="_project", title="entity reference schema")
    field_material: Optional[EntityReferenceSchema] = Field(None, alias="_material", title="entity reference schema")
    parent: Optional[EntityReferenceSchema] = Field(None, title="entity reference schema")
    runtimeContext: Optional[Dict[str, Any]] = None
    """
    Context variables that the job will have access to at runtime
    """
    scopeTrack: Optional[List[ScopeTrackItem]] = None
    """
    history of the workflow scope on each update
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None
