# generated by datamodel-codegen:
#   filename:  materials_category/compound_pristine_structures/two_dimensional/interface/configuration.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint, constr


class ChemicalElements(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class TerminationSchema(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value85(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema(BaseModel):
    value: Union[Value, Value85]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class AtomicCoordinateSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisUnitsEnum(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AtomicLabelSchema(BaseModel):
    value: Union[Union[int, str, float], conint(ge=1, le=9)]
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema(BaseModel):
    elements: List[AtomicElementSchema] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name(Enum):
    volume = "volume"


class Units(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units] = None
    value: float


class Name312(Enum):
    density = "density"


class Units124(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units124] = None
    value: float


class Units125(Enum):
    angstrom = "angstrom"


class ScalarSchema(BaseModel):
    units: Optional[Units125] = None
    value: float


class Name313(Enum):
    symmetry = "symmetry"


class SymmetrySchema(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name314(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name315(Enum):
    p_norm = "p-norm"


class PNorm(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name316(Enum):
    inchi = "inchi"


class InChIRepresentationSchema(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name317(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema(
    RootModel[
        Union[
            VolumeSchema,
            DensitySchema,
            SymmetrySchema,
            ElementalRatio,
            PNorm,
            InChIRepresentationSchema,
            InChIKeyRepresentationSchema,
        ]
    ]
):
    root: Union[
        VolumeSchema,
        DensitySchema,
        SymmetrySchema,
        ElementalRatio,
        PNorm,
        InChIRepresentationSchema,
        InChIKeyRepresentationSchema,
    ] = Field(..., discriminator="name")


class DatabaseSourceSchema(BaseModel):
    id: Union[str, float]
    """
    ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32
    """
    source: str
    """
    Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.
    """
    origin: bool
    """
    Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).
    """
    data: Optional[Dict[str, Any]] = None
    """
    Original response from external source.
    """
    doi: Optional[str] = None
    """
    Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506
    """
    url: Optional[str] = None
    """
    The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers
    """


class FileSourceSchema(BaseModel):
    extension: Optional[str] = None
    """
    file extension
    """
    filename: str
    """
    file name without extension
    """
    text: str
    """
    file content as raw text
    """
    hash: str
    """
    MD5 hash based on file content
    """


class Name318(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class MaterialConsistencyCheckSchema(BaseModel):
    name: Name318
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema = Field(..., title="basis schema")
    lattice: LatticeSchema = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema(BaseModel):
    termination_top: TerminationSchema = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class AxisEnum(Enum):
    x = "x"
    y = "y"
    z = "z"


class Value86(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value87(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema42(BaseModel):
    value: Union[Value86, Value87]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema40(BaseModel):
    elements: List[AtomicElementSchema42] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema39(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema39(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema39(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema39] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema39] = Field(
        default_factory=lambda: LatticeUnitsSchema39.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name319(Enum):
    volume = "volume"


class Units126(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema39(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units126] = None
    value: float


class Name320(Enum):
    density = "density"


class Units127(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema39(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units127] = None
    value: float


class Units128(Enum):
    angstrom = "angstrom"


class ScalarSchema40(BaseModel):
    units: Optional[Units128] = None
    value: float


class Name321(Enum):
    symmetry = "symmetry"


class SymmetrySchema39(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema40] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name322(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio39(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name323(Enum):
    p_norm = "p-norm"


class PNorm39(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name324(Enum):
    inchi = "inchi"


class InChIRepresentationSchema39(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name325(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema39(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema39(
    RootModel[
        Union[
            VolumeSchema39,
            DensitySchema39,
            SymmetrySchema39,
            ElementalRatio39,
            PNorm39,
            InChIRepresentationSchema39,
            InChIKeyRepresentationSchema39,
        ]
    ]
):
    root: Union[
        VolumeSchema39,
        DensitySchema39,
        SymmetrySchema39,
        ElementalRatio39,
        PNorm39,
        InChIRepresentationSchema39,
        InChIKeyRepresentationSchema39,
    ] = Field(..., discriminator="name")


class Name326(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema39(BaseModel):
    name: Name326
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema39(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema40 = Field(..., title="basis schema")
    lattice: LatticeSchema39 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema39]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema39]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema39 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class ObjectWithIdAndValueSchema(BaseModel):
    value: float
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class SlabConfigurationSchema(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema, VacuumConfigurationSchema]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class SupercellMatrix2DSchemaItem(RootModel[List[int]]):
    root: List[int]


class ArrayOf3NumberElementsSchema(RootModel[List[float]]):
    root: List[float] = Field(..., title="array of 3 number elements schema")


class TerminationSchema17(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value88(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value89(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema43(BaseModel):
    value: Union[Value88, Value89]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema41(BaseModel):
    elements: List[AtomicElementSchema43] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema40(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema40(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema40(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema40] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema40] = Field(
        default_factory=lambda: LatticeUnitsSchema40.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name327(Enum):
    volume = "volume"


class Units129(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema40(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units129] = None
    value: float


class Name328(Enum):
    density = "density"


class Units130(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema40(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units130] = None
    value: float


class Units131(Enum):
    angstrom = "angstrom"


class ScalarSchema41(BaseModel):
    units: Optional[Units131] = None
    value: float


class Name329(Enum):
    symmetry = "symmetry"


class SymmetrySchema40(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema41] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name330(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio40(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name331(Enum):
    p_norm = "p-norm"


class PNorm40(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name332(Enum):
    inchi = "inchi"


class InChIRepresentationSchema40(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name333(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema40(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema40(
    RootModel[
        Union[
            VolumeSchema40,
            DensitySchema40,
            SymmetrySchema40,
            ElementalRatio40,
            PNorm40,
            InChIRepresentationSchema40,
            InChIKeyRepresentationSchema40,
        ]
    ]
):
    root: Union[
        VolumeSchema40,
        DensitySchema40,
        SymmetrySchema40,
        ElementalRatio40,
        PNorm40,
        InChIRepresentationSchema40,
        InChIKeyRepresentationSchema40,
    ] = Field(..., discriminator="name")


class Name334(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema40(BaseModel):
    name: Name334
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema40(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema41 = Field(..., title="basis schema")
    lattice: LatticeSchema40 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema40]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema40]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema15(BaseModel):
    termination_top: TerminationSchema17 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema40 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value90(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value91(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema44(BaseModel):
    value: Union[Value90, Value91]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema42(BaseModel):
    elements: List[AtomicElementSchema44] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema41(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema41(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema41(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema41] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema41] = Field(
        default_factory=lambda: LatticeUnitsSchema41.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name335(Enum):
    volume = "volume"


class Units132(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema41(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units132] = None
    value: float


class Name336(Enum):
    density = "density"


class Units133(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema41(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units133] = None
    value: float


class Units134(Enum):
    angstrom = "angstrom"


class ScalarSchema42(BaseModel):
    units: Optional[Units134] = None
    value: float


class Name337(Enum):
    symmetry = "symmetry"


class SymmetrySchema41(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema42] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name338(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio41(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name339(Enum):
    p_norm = "p-norm"


class PNorm41(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name340(Enum):
    inchi = "inchi"


class InChIRepresentationSchema41(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name341(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema41(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema41(
    RootModel[
        Union[
            VolumeSchema41,
            DensitySchema41,
            SymmetrySchema41,
            ElementalRatio41,
            PNorm41,
            InChIRepresentationSchema41,
            InChIKeyRepresentationSchema41,
        ]
    ]
):
    root: Union[
        VolumeSchema41,
        DensitySchema41,
        SymmetrySchema41,
        ElementalRatio41,
        PNorm41,
        InChIRepresentationSchema41,
        InChIKeyRepresentationSchema41,
    ] = Field(..., discriminator="name")


class Name342(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema41(BaseModel):
    name: Name342
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema41(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema42 = Field(..., title="basis schema")
    lattice: LatticeSchema41 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema41]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema41]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema19(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema41 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabStrainedSupercellConfigurationSchema(BaseModel):
    xy_supercell_matrix: Optional[List[SupercellMatrix2DSchemaItem]] = Field(
        default_factory=lambda: [SupercellMatrix2DSchemaItem.model_validate(v) for v in [[1, 0], [0, 1]]],
        max_length=2,
        min_length=2,
        title="Supercell Matrix 2D Schema",
    )
    """
    Supercell matrix for xy plane transformations
    """
    strain_matrix: List[ArrayOf3NumberElementsSchema] = Field(
        ..., max_length=3, min_length=3, title="matrix 3x3 schema"
    )
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema15, VacuumConfigurationSchema19]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema18(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value92(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value93(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema45(BaseModel):
    value: Union[Value92, Value93]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema43(BaseModel):
    elements: List[AtomicElementSchema45] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema42(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema42(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema42(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema42] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema42] = Field(
        default_factory=lambda: LatticeUnitsSchema42.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name343(Enum):
    volume = "volume"


class Units135(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema42(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units135] = None
    value: float


class Name344(Enum):
    density = "density"


class Units136(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema42(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units136] = None
    value: float


class Units137(Enum):
    angstrom = "angstrom"


class ScalarSchema43(BaseModel):
    units: Optional[Units137] = None
    value: float


class Name345(Enum):
    symmetry = "symmetry"


class SymmetrySchema42(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema43] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name346(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio42(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name347(Enum):
    p_norm = "p-norm"


class PNorm42(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name348(Enum):
    inchi = "inchi"


class InChIRepresentationSchema42(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name349(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema42(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema42(
    RootModel[
        Union[
            VolumeSchema42,
            DensitySchema42,
            SymmetrySchema42,
            ElementalRatio42,
            PNorm42,
            InChIRepresentationSchema42,
            InChIKeyRepresentationSchema42,
        ]
    ]
):
    root: Union[
        VolumeSchema42,
        DensitySchema42,
        SymmetrySchema42,
        ElementalRatio42,
        PNorm42,
        InChIRepresentationSchema42,
        InChIKeyRepresentationSchema42,
    ] = Field(..., discriminator="name")


class Name350(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema42(BaseModel):
    name: Name350
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema42(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema43 = Field(..., title="basis schema")
    lattice: LatticeSchema42 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema42]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema42]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema16(BaseModel):
    termination_top: TerminationSchema18 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema42 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value94(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value95(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema46(BaseModel):
    value: Union[Value94, Value95]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema44(BaseModel):
    elements: List[AtomicElementSchema46] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema43(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema43(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema43(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema43] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema43] = Field(
        default_factory=lambda: LatticeUnitsSchema43.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name351(Enum):
    volume = "volume"


class Units138(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema43(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units138] = None
    value: float


class Name352(Enum):
    density = "density"


class Units139(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema43(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units139] = None
    value: float


class Units140(Enum):
    angstrom = "angstrom"


class ScalarSchema44(BaseModel):
    units: Optional[Units140] = None
    value: float


class Name353(Enum):
    symmetry = "symmetry"


class SymmetrySchema43(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema44] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name354(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio43(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name355(Enum):
    p_norm = "p-norm"


class PNorm43(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name356(Enum):
    inchi = "inchi"


class InChIRepresentationSchema43(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name357(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema43(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema43(
    RootModel[
        Union[
            VolumeSchema43,
            DensitySchema43,
            SymmetrySchema43,
            ElementalRatio43,
            PNorm43,
            InChIRepresentationSchema43,
            InChIKeyRepresentationSchema43,
        ]
    ]
):
    root: Union[
        VolumeSchema43,
        DensitySchema43,
        SymmetrySchema43,
        ElementalRatio43,
        PNorm43,
        InChIRepresentationSchema43,
        InChIKeyRepresentationSchema43,
    ] = Field(..., discriminator="name")


class Name358(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema43(BaseModel):
    name: Name358
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema43(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema44 = Field(..., title="basis schema")
    lattice: LatticeSchema43 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema43]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema43]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema20(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema43 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabConfigurationSchema10(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema16, VacuumConfigurationSchema20]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema19(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value96(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value97(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema47(BaseModel):
    value: Union[Value96, Value97]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema45(BaseModel):
    elements: List[AtomicElementSchema47] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema44(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema44(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema44(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema44] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema44] = Field(
        default_factory=lambda: LatticeUnitsSchema44.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name359(Enum):
    volume = "volume"


class Units141(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema44(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units141] = None
    value: float


class Name360(Enum):
    density = "density"


class Units142(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema44(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units142] = None
    value: float


class Units143(Enum):
    angstrom = "angstrom"


class ScalarSchema45(BaseModel):
    units: Optional[Units143] = None
    value: float


class Name361(Enum):
    symmetry = "symmetry"


class SymmetrySchema44(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema45] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name362(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio44(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name363(Enum):
    p_norm = "p-norm"


class PNorm44(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name364(Enum):
    inchi = "inchi"


class InChIRepresentationSchema44(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name365(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema44(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema44(
    RootModel[
        Union[
            VolumeSchema44,
            DensitySchema44,
            SymmetrySchema44,
            ElementalRatio44,
            PNorm44,
            InChIRepresentationSchema44,
            InChIKeyRepresentationSchema44,
        ]
    ]
):
    root: Union[
        VolumeSchema44,
        DensitySchema44,
        SymmetrySchema44,
        ElementalRatio44,
        PNorm44,
        InChIRepresentationSchema44,
        InChIKeyRepresentationSchema44,
    ] = Field(..., discriminator="name")


class Name366(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema44(BaseModel):
    name: Name366
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema44(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema45 = Field(..., title="basis schema")
    lattice: LatticeSchema44 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema44]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema44]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema17(BaseModel):
    termination_top: TerminationSchema19 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema44 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value98(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value99(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema48(BaseModel):
    value: Union[Value98, Value99]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema46(BaseModel):
    elements: List[AtomicElementSchema48] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema45(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema45(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema45(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema45] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema45] = Field(
        default_factory=lambda: LatticeUnitsSchema45.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name367(Enum):
    volume = "volume"


class Units144(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema45(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units144] = None
    value: float


class Name368(Enum):
    density = "density"


class Units145(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema45(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units145] = None
    value: float


class Units146(Enum):
    angstrom = "angstrom"


class ScalarSchema46(BaseModel):
    units: Optional[Units146] = None
    value: float


class Name369(Enum):
    symmetry = "symmetry"


class SymmetrySchema45(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema46] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name370(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio45(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name371(Enum):
    p_norm = "p-norm"


class PNorm45(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name372(Enum):
    inchi = "inchi"


class InChIRepresentationSchema45(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name373(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema45(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema45(
    RootModel[
        Union[
            VolumeSchema45,
            DensitySchema45,
            SymmetrySchema45,
            ElementalRatio45,
            PNorm45,
            InChIRepresentationSchema45,
            InChIKeyRepresentationSchema45,
        ]
    ]
):
    root: Union[
        VolumeSchema45,
        DensitySchema45,
        SymmetrySchema45,
        ElementalRatio45,
        PNorm45,
        InChIRepresentationSchema45,
        InChIKeyRepresentationSchema45,
    ] = Field(..., discriminator="name")


class Name374(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema45(BaseModel):
    name: Name374
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema45(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema46 = Field(..., title="basis schema")
    lattice: LatticeSchema45 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema45]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema45]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema21(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema45 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabStrainedSupercellConfigurationSchema5(BaseModel):
    xy_supercell_matrix: Optional[List[SupercellMatrix2DSchemaItem]] = Field(
        default_factory=lambda: [SupercellMatrix2DSchemaItem.model_validate(v) for v in [[1, 0], [0, 1]]],
        max_length=2,
        min_length=2,
        title="Supercell Matrix 2D Schema",
    )
    """
    Supercell matrix for xy plane transformations
    """
    strain_matrix: List[ArrayOf3NumberElementsSchema] = Field(
        ..., max_length=3, min_length=3, title="matrix 3x3 schema"
    )
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema17, VacuumConfigurationSchema21]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class Value100(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value101(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema49(BaseModel):
    value: Union[Value100, Value101]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema47(BaseModel):
    elements: List[AtomicElementSchema49] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema46(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema46(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema46(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema46] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema46] = Field(
        default_factory=lambda: LatticeUnitsSchema46.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name375(Enum):
    volume = "volume"


class Units147(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema46(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units147] = None
    value: float


class Name376(Enum):
    density = "density"


class Units148(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema46(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units148] = None
    value: float


class Units149(Enum):
    angstrom = "angstrom"


class ScalarSchema47(BaseModel):
    units: Optional[Units149] = None
    value: float


class Name377(Enum):
    symmetry = "symmetry"


class SymmetrySchema46(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema47] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name378(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio46(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name379(Enum):
    p_norm = "p-norm"


class PNorm46(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name380(Enum):
    inchi = "inchi"


class InChIRepresentationSchema46(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name381(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema46(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema46(
    RootModel[
        Union[
            VolumeSchema46,
            DensitySchema46,
            SymmetrySchema46,
            ElementalRatio46,
            PNorm46,
            InChIRepresentationSchema46,
            InChIKeyRepresentationSchema46,
        ]
    ]
):
    root: Union[
        VolumeSchema46,
        DensitySchema46,
        SymmetrySchema46,
        ElementalRatio46,
        PNorm46,
        InChIRepresentationSchema46,
        InChIKeyRepresentationSchema46,
    ] = Field(..., discriminator="name")


class Name382(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema46(BaseModel):
    name: Name382
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema46(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema47 = Field(..., title="basis schema")
    lattice: LatticeSchema46 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema46]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema46]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema22(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema46 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class InterfaceConfigurationSchema(BaseModel):
    stack_components: List[
        Union[
            Union[SlabConfigurationSchema, SlabStrainedSupercellConfigurationSchema],
            Union[SlabConfigurationSchema10, SlabStrainedSupercellConfigurationSchema5],
            VacuumConfigurationSchema22,
        ]
    ] = Field(..., max_length=3, min_length=2)
    """
    Components of the interface: slab, slab and vacuum
    """
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    xy_shift: Optional[List[float]] = Field([0, 0], max_length=2, min_length=2, title="vector 2d schema")
    """
    xy shift for the film as cartesian 2D vector on the xy plane.
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """
