# generated by datamodel-codegen:
#   filename:  materials_category/defective_structures/two_dimensional/island/configuration.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint, constr


class ChemicalElements(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class TerminationSchema(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value55(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema(BaseModel):
    value: Union[Value, Value55]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class AtomicCoordinateSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisUnitsEnum(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AtomicLabelSchema(BaseModel):
    value: Union[Union[int, str, float], conint(ge=1, le=9)]
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema(BaseModel):
    elements: List[AtomicElementSchema] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name(Enum):
    volume = "volume"


class Units(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units] = None
    value: float


class Name192(Enum):
    density = "density"


class Units79(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units79] = None
    value: float


class Units80(Enum):
    angstrom = "angstrom"


class ScalarSchema(BaseModel):
    units: Optional[Units80] = None
    value: float


class Name193(Enum):
    symmetry = "symmetry"


class SymmetrySchema(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name194(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name195(Enum):
    p_norm = "p-norm"


class PNorm(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name196(Enum):
    inchi = "inchi"


class InChIRepresentationSchema(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name197(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema(
    RootModel[
        Union[
            VolumeSchema,
            DensitySchema,
            SymmetrySchema,
            ElementalRatio,
            PNorm,
            InChIRepresentationSchema,
            InChIKeyRepresentationSchema,
        ]
    ]
):
    root: Union[
        VolumeSchema,
        DensitySchema,
        SymmetrySchema,
        ElementalRatio,
        PNorm,
        InChIRepresentationSchema,
        InChIKeyRepresentationSchema,
    ] = Field(..., discriminator="name")


class DatabaseSourceSchema(BaseModel):
    id: Union[str, float]
    """
    ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32
    """
    source: str
    """
    Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.
    """
    origin: bool
    """
    Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).
    """
    data: Optional[Dict[str, Any]] = None
    """
    Original response from external source.
    """
    doi: Optional[str] = None
    """
    Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506
    """
    url: Optional[str] = None
    """
    The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers
    """


class FileSourceSchema(BaseModel):
    extension: Optional[str] = None
    """
    file extension
    """
    filename: str
    """
    file name without extension
    """
    text: str
    """
    file content as raw text
    """
    hash: str
    """
    MD5 hash based on file content
    """


class Name198(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class MaterialConsistencyCheckSchema(BaseModel):
    name: Name198
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema = Field(..., title="basis schema")
    lattice: LatticeSchema = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema(BaseModel):
    termination_top: TerminationSchema = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class AxisEnum(Enum):
    x = "x"
    y = "y"
    z = "z"


class Value56(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value57(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema27(BaseModel):
    value: Union[Value56, Value57]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema25(BaseModel):
    elements: List[AtomicElementSchema27] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema24(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema24(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema24(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema24] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema24] = Field(
        default_factory=lambda: LatticeUnitsSchema24.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name199(Enum):
    volume = "volume"


class Units81(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema24(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units81] = None
    value: float


class Name200(Enum):
    density = "density"


class Units82(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema24(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units82] = None
    value: float


class Units83(Enum):
    angstrom = "angstrom"


class ScalarSchema25(BaseModel):
    units: Optional[Units83] = None
    value: float


class Name201(Enum):
    symmetry = "symmetry"


class SymmetrySchema24(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema25] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name202(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio24(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name203(Enum):
    p_norm = "p-norm"


class PNorm24(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name204(Enum):
    inchi = "inchi"


class InChIRepresentationSchema24(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name205(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema24(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema24(
    RootModel[
        Union[
            VolumeSchema24,
            DensitySchema24,
            SymmetrySchema24,
            ElementalRatio24,
            PNorm24,
            InChIRepresentationSchema24,
            InChIKeyRepresentationSchema24,
        ]
    ]
):
    root: Union[
        VolumeSchema24,
        DensitySchema24,
        SymmetrySchema24,
        ElementalRatio24,
        PNorm24,
        InChIRepresentationSchema24,
        InChIKeyRepresentationSchema24,
    ] = Field(..., discriminator="name")


class Name206(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema24(BaseModel):
    name: Name206
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema24(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema25 = Field(..., title="basis schema")
    lattice: LatticeSchema24 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema24]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema24]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema24 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class ObjectWithIdAndValueSchema(BaseModel):
    value: float
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class SlabConfigurationSchema(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema, VacuumConfigurationSchema]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema11(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value58(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value59(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema28(BaseModel):
    value: Union[Value58, Value59]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema26(BaseModel):
    elements: List[AtomicElementSchema28] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema25(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema25(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema25(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema25] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema25] = Field(
        default_factory=lambda: LatticeUnitsSchema25.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name207(Enum):
    volume = "volume"


class Units84(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema25(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units84] = None
    value: float


class Name208(Enum):
    density = "density"


class Units85(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema25(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units85] = None
    value: float


class Units86(Enum):
    angstrom = "angstrom"


class ScalarSchema26(BaseModel):
    units: Optional[Units86] = None
    value: float


class Name209(Enum):
    symmetry = "symmetry"


class SymmetrySchema25(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema26] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name210(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio25(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name211(Enum):
    p_norm = "p-norm"


class PNorm25(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name212(Enum):
    inchi = "inchi"


class InChIRepresentationSchema25(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name213(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema25(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema25(
    RootModel[
        Union[
            VolumeSchema25,
            DensitySchema25,
            SymmetrySchema25,
            ElementalRatio25,
            PNorm25,
            InChIRepresentationSchema25,
            InChIKeyRepresentationSchema25,
        ]
    ]
):
    root: Union[
        VolumeSchema25,
        DensitySchema25,
        SymmetrySchema25,
        ElementalRatio25,
        PNorm25,
        InChIRepresentationSchema25,
        InChIKeyRepresentationSchema25,
    ] = Field(..., discriminator="name")


class Name214(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema25(BaseModel):
    name: Name214
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema25(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema26 = Field(..., title="basis schema")
    lattice: LatticeSchema25 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema25]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema25]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema9(BaseModel):
    termination_top: TerminationSchema11 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema25 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value60(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value61(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema29(BaseModel):
    value: Union[Value60, Value61]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema27(BaseModel):
    elements: List[AtomicElementSchema29] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema26(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema26(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema26(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema26] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema26] = Field(
        default_factory=lambda: LatticeUnitsSchema26.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name215(Enum):
    volume = "volume"


class Units87(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema26(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units87] = None
    value: float


class Name216(Enum):
    density = "density"


class Units88(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema26(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units88] = None
    value: float


class Units89(Enum):
    angstrom = "angstrom"


class ScalarSchema27(BaseModel):
    units: Optional[Units89] = None
    value: float


class Name217(Enum):
    symmetry = "symmetry"


class SymmetrySchema26(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema27] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name218(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio26(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name219(Enum):
    p_norm = "p-norm"


class PNorm26(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name220(Enum):
    inchi = "inchi"


class InChIRepresentationSchema26(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name221(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema26(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema26(
    RootModel[
        Union[
            VolumeSchema26,
            DensitySchema26,
            SymmetrySchema26,
            ElementalRatio26,
            PNorm26,
            InChIRepresentationSchema26,
            InChIKeyRepresentationSchema26,
        ]
    ]
):
    root: Union[
        VolumeSchema26,
        DensitySchema26,
        SymmetrySchema26,
        ElementalRatio26,
        PNorm26,
        InChIRepresentationSchema26,
        InChIKeyRepresentationSchema26,
    ] = Field(..., discriminator="name")


class Name222(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema26(BaseModel):
    name: Name222
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema26(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema27 = Field(..., title="basis schema")
    lattice: LatticeSchema26 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema26]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema26]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema11(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema26 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabConfigurationSchema6(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema9, VacuumConfigurationSchema11]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class Value62(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value63(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema30(BaseModel):
    value: Union[Value62, Value63]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema28(BaseModel):
    elements: List[AtomicElementSchema30] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema27(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema27(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema27(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema27] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema27] = Field(
        default_factory=lambda: LatticeUnitsSchema27.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name223(Enum):
    volume = "volume"


class Units90(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema27(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units90] = None
    value: float


class Name224(Enum):
    density = "density"


class Units91(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema27(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units91] = None
    value: float


class Units92(Enum):
    angstrom = "angstrom"


class ScalarSchema28(BaseModel):
    units: Optional[Units92] = None
    value: float


class Name225(Enum):
    symmetry = "symmetry"


class SymmetrySchema27(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema28] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name226(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio27(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name227(Enum):
    p_norm = "p-norm"


class PNorm27(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name228(Enum):
    inchi = "inchi"


class InChIRepresentationSchema27(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name229(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema27(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema27(
    RootModel[
        Union[
            VolumeSchema27,
            DensitySchema27,
            SymmetrySchema27,
            ElementalRatio27,
            PNorm27,
            InChIRepresentationSchema27,
            InChIKeyRepresentationSchema27,
        ]
    ]
):
    root: Union[
        VolumeSchema27,
        DensitySchema27,
        SymmetrySchema27,
        ElementalRatio27,
        PNorm27,
        InChIRepresentationSchema27,
        InChIKeyRepresentationSchema27,
    ] = Field(..., discriminator="name")


class Name230(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema27(BaseModel):
    name: Name230
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema27(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema28 = Field(..., title="basis schema")
    lattice: LatticeSchema27 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema27]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema27]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class CoordinateShapeEnum(Enum):
    cylinder = "cylinder"
    sphere = "sphere"
    box = "box"
    triangular_prism = "triangular_prism"
    plane = "plane"


class BoxCoordinateConditionSchema(BaseModel):
    shape: Literal["box"] = Field("box", title="Coordinate Shape Enum")
    min_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    max_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class SphereCoordinateConditionSchema(BaseModel):
    shape: Literal["sphere"] = Field("sphere", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)


class CylinderCoordinateConditionSchema(BaseModel):
    shape: Literal["cylinder"] = Field("cylinder", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)
    min_z: float
    max_z: float


class TriangularPrismCoordinateConditionSchema(BaseModel):
    shape: Literal["triangular_prism"] = Field("triangular_prism", title="Coordinate Shape Enum")
    position_on_surface_1: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_2: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_3: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    min_z: float
    max_z: float


class PlaneCoordinateConditionSchema(BaseModel):
    shape: Literal["plane"] = Field("plane", title="Coordinate Shape Enum")
    plane_normal: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    plane_point_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class VoidRegionSchema(BaseModel):
    crystal: CrystalSchema27 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    coordinate_condition: Union[
        BoxCoordinateConditionSchema,
        SphereCoordinateConditionSchema,
        CylinderCoordinateConditionSchema,
        TriangularPrismCoordinateConditionSchema,
        PlaneCoordinateConditionSchema,
    ] = Field(..., title="Coordinate Conditions Schema")
    """
    Combined schema for all coordinate condition types
    """


class MergeMethodsEnum(Enum):
    ADD = "ADD"
    REPLACE = "REPLACE"
    YIELD = "YIELD"


class MergeSchema(BaseModel):
    merge_components: List[Union[SlabConfigurationSchema6, VoidRegionSchema]] = Field(..., max_length=2, min_length=2)
    merge_method: Optional[MergeMethodsEnum] = Field("REPLACE", title="Merge Methods Enum")
    """
    Available methods for merging components
    """


class Value64(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value65(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema31(BaseModel):
    value: Union[Value64, Value65]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema29(BaseModel):
    elements: List[AtomicElementSchema31] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema28(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema28(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema28(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema28] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema28] = Field(
        default_factory=lambda: LatticeUnitsSchema28.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name231(Enum):
    volume = "volume"


class Units93(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema28(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units93] = None
    value: float


class Name232(Enum):
    density = "density"


class Units94(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema28(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units94] = None
    value: float


class Units95(Enum):
    angstrom = "angstrom"


class ScalarSchema29(BaseModel):
    units: Optional[Units95] = None
    value: float


class Name233(Enum):
    symmetry = "symmetry"


class SymmetrySchema28(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema29] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name234(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio28(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name235(Enum):
    p_norm = "p-norm"


class PNorm28(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name236(Enum):
    inchi = "inchi"


class InChIRepresentationSchema28(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name237(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema28(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema28(
    RootModel[
        Union[
            VolumeSchema28,
            DensitySchema28,
            SymmetrySchema28,
            ElementalRatio28,
            PNorm28,
            InChIRepresentationSchema28,
            InChIKeyRepresentationSchema28,
        ]
    ]
):
    root: Union[
        VolumeSchema28,
        DensitySchema28,
        SymmetrySchema28,
        ElementalRatio28,
        PNorm28,
        InChIRepresentationSchema28,
        InChIKeyRepresentationSchema28,
    ] = Field(..., discriminator="name")


class Name238(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema28(BaseModel):
    name: Name238
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema28(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema29 = Field(..., title="basis schema")
    lattice: LatticeSchema28 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema28]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema28]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema12(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema28 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class IslandDefectConfigurationSchema(BaseModel):
    stack_components: List[Union[SlabConfigurationSchema, MergeSchema, VacuumConfigurationSchema12]] = Field(
        ..., max_length=3, min_length=3
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """
