# generated by datamodel-codegen:
#   filename:  materials_category/defective_structures/two_dimensional/terrace/configuration.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint, constr


class ChemicalElements(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class TerminationSchema(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value35(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema(BaseModel):
    value: Union[Value, Value35]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class AtomicCoordinateSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisUnitsEnum(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AtomicLabelSchema(BaseModel):
    value: Union[Union[int, str, float], conint(ge=1, le=9)]
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema(BaseModel):
    elements: List[AtomicElementSchema] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsUnitsEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeVectorsSchema(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeTypeEnum(Enum):
    CUB = "CUB"
    BCC = "BCC"
    FCC = "FCC"
    TET = "TET"
    MCL = "MCL"
    ORC = "ORC"
    ORCC = "ORCC"
    ORCF = "ORCF"
    ORCI = "ORCI"
    HEX = "HEX"
    BCT = "BCT"
    TRI = "TRI"
    MCLC = "MCLC"
    RHL = "RHL"


class LatticeUnitsLengthEnum(Enum):
    angstrom = "angstrom"
    bohr = "bohr"


class LatticeUnitsAngleEnum(Enum):
    degree = "degree"
    radian = "radian"


class LatticeUnitsSchema(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema] = Field(
        default_factory=lambda: LatticeUnitsSchema.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name(Enum):
    volume = "volume"


class Units(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units] = None
    value: float


class Name112(Enum):
    density = "density"


class Units49(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units49] = None
    value: float


class Units50(Enum):
    angstrom = "angstrom"


class ScalarSchema(BaseModel):
    units: Optional[Units50] = None
    value: float


class Name113(Enum):
    symmetry = "symmetry"


class SymmetrySchema(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name114(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name115(Enum):
    p_norm = "p-norm"


class PNorm(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name116(Enum):
    inchi = "inchi"


class InChIRepresentationSchema(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name117(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema(
    RootModel[
        Union[
            VolumeSchema,
            DensitySchema,
            SymmetrySchema,
            ElementalRatio,
            PNorm,
            InChIRepresentationSchema,
            InChIKeyRepresentationSchema,
        ]
    ]
):
    root: Union[
        VolumeSchema,
        DensitySchema,
        SymmetrySchema,
        ElementalRatio,
        PNorm,
        InChIRepresentationSchema,
        InChIKeyRepresentationSchema,
    ] = Field(..., discriminator="name")


class DatabaseSourceSchema(BaseModel):
    id: Union[str, float]
    """
    ID string for the materials uploaded from a third party source inside the third party source. For materialsproject.org an example ID is mp-32
    """
    source: str
    """
    Third party source name, e.g. materials project, 2dmatpedia, ICSD, etc.
    """
    origin: bool
    """
    Deprecated. To be removed. A flag that is true when material is initially imported from a third party * (as opposed to being independently designed from scratch).
    """
    data: Optional[Dict[str, Any]] = None
    """
    Original response from external source.
    """
    doi: Optional[str] = None
    """
    Digital Object Identifier, e.g. 10.1088/0953-8984/25/10/105506
    """
    url: Optional[str] = None
    """
    The URL of the original record, e.g. https://next-gen.materialsproject.org/materials/mp-48; ToDo: update to use URI type per https://json-schema.org/understanding-json-schema/reference/string#resource-identifiers
    """


class FileSourceSchema(BaseModel):
    extension: Optional[str] = None
    """
    file extension
    """
    filename: str
    """
    file name without extension
    """
    text: str
    """
    file content as raw text
    """
    hash: str
    """
    MD5 hash based on file content
    """


class Name118(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class Severity(Enum):
    info = "info"
    warning = "warning"
    error = "error"


class MaterialConsistencyCheckSchema(BaseModel):
    name: Name118
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema = Field(..., title="basis schema")
    lattice: LatticeSchema = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema(BaseModel):
    termination_top: TerminationSchema = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class AxisEnum(Enum):
    x = "x"
    y = "y"
    z = "z"


class Value36(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value37(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema17(BaseModel):
    value: Union[Value36, Value37]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema15(BaseModel):
    elements: List[AtomicElementSchema17] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema14(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema14(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema14(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema14] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema14] = Field(
        default_factory=lambda: LatticeUnitsSchema14.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name119(Enum):
    volume = "volume"


class Units51(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema14(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units51] = None
    value: float


class Name120(Enum):
    density = "density"


class Units52(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema14(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units52] = None
    value: float


class Units53(Enum):
    angstrom = "angstrom"


class ScalarSchema15(BaseModel):
    units: Optional[Units53] = None
    value: float


class Name121(Enum):
    symmetry = "symmetry"


class SymmetrySchema14(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema15] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name122(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio14(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name123(Enum):
    p_norm = "p-norm"


class PNorm14(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name124(Enum):
    inchi = "inchi"


class InChIRepresentationSchema14(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name125(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema14(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema14(
    RootModel[
        Union[
            VolumeSchema14,
            DensitySchema14,
            SymmetrySchema14,
            ElementalRatio14,
            PNorm14,
            InChIRepresentationSchema14,
            InChIKeyRepresentationSchema14,
        ]
    ]
):
    root: Union[
        VolumeSchema14,
        DensitySchema14,
        SymmetrySchema14,
        ElementalRatio14,
        PNorm14,
        InChIRepresentationSchema14,
        InChIKeyRepresentationSchema14,
    ] = Field(..., discriminator="name")


class Name126(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema14(BaseModel):
    name: Name126
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema14(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema15 = Field(..., title="basis schema")
    lattice: LatticeSchema14 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema14]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema14]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema14 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class ObjectWithIdAndValueSchema(BaseModel):
    value: float
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class SlabConfigurationSchema(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema, VacuumConfigurationSchema]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class TerminationSchema8(BaseModel):
    chemical_elements: Union[ChemicalElements, constr(pattern=r"^([A-Z][a-z]?[0-9]*)+$")] = Field(
        ..., title="Chemical Elements"
    )
    """
    Chemical elements at the termination. Can be a single element (e.g. 'Si') or a compound (e.g. 'SiO')
    """
    space_group_symmetry_label: str = Field(..., title="Space Group Symmetry Label")
    """
    Space group symmetry designation for the termination
    """


class Value38(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value39(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema18(BaseModel):
    value: Union[Value38, Value39]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema16(BaseModel):
    elements: List[AtomicElementSchema18] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema15(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema15(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema15(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema15] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema15] = Field(
        default_factory=lambda: LatticeUnitsSchema15.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name127(Enum):
    volume = "volume"


class Units54(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema15(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units54] = None
    value: float


class Name128(Enum):
    density = "density"


class Units55(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema15(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units55] = None
    value: float


class Units56(Enum):
    angstrom = "angstrom"


class ScalarSchema16(BaseModel):
    units: Optional[Units56] = None
    value: float


class Name129(Enum):
    symmetry = "symmetry"


class SymmetrySchema15(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema16] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name130(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio15(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name131(Enum):
    p_norm = "p-norm"


class PNorm15(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name132(Enum):
    inchi = "inchi"


class InChIRepresentationSchema15(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name133(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema15(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema15(
    RootModel[
        Union[
            VolumeSchema15,
            DensitySchema15,
            SymmetrySchema15,
            ElementalRatio15,
            PNorm15,
            InChIRepresentationSchema15,
            InChIKeyRepresentationSchema15,
        ]
    ]
):
    root: Union[
        VolumeSchema15,
        DensitySchema15,
        SymmetrySchema15,
        ElementalRatio15,
        PNorm15,
        InChIRepresentationSchema15,
        InChIKeyRepresentationSchema15,
    ] = Field(..., discriminator="name")


class Name134(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema15(BaseModel):
    name: Name134
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema15(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema16 = Field(..., title="basis schema")
    lattice: LatticeSchema15 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema15]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema15]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class AtomicLayersUniqueRepeatedSchema6(BaseModel):
    termination_top: TerminationSchema8 = Field(..., title="Termination Schema")
    """
    Defines a specific termination of a slab
    """
    number_of_repetitions: conint(ge=1)
    """
    Number of repetitions of the unique atomic layers
    """
    miller_indices: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    crystal: CrystalSchema15 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    use_conventional_cell: Optional[bool] = True
    """
    Use the conventional cell for the crystal structure
    """


class Value40(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value41(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema19(BaseModel):
    value: Union[Value40, Value41]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema17(BaseModel):
    elements: List[AtomicElementSchema19] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema16(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema16(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema16(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema16] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema16] = Field(
        default_factory=lambda: LatticeUnitsSchema16.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name135(Enum):
    volume = "volume"


class Units57(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema16(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units57] = None
    value: float


class Name136(Enum):
    density = "density"


class Units58(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema16(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units58] = None
    value: float


class Units59(Enum):
    angstrom = "angstrom"


class ScalarSchema17(BaseModel):
    units: Optional[Units59] = None
    value: float


class Name137(Enum):
    symmetry = "symmetry"


class SymmetrySchema16(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema17] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name138(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio16(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name139(Enum):
    p_norm = "p-norm"


class PNorm16(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name140(Enum):
    inchi = "inchi"


class InChIRepresentationSchema16(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name141(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema16(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema16(
    RootModel[
        Union[
            VolumeSchema16,
            DensitySchema16,
            SymmetrySchema16,
            ElementalRatio16,
            PNorm16,
            InChIRepresentationSchema16,
            InChIKeyRepresentationSchema16,
        ]
    ]
):
    root: Union[
        VolumeSchema16,
        DensitySchema16,
        SymmetrySchema16,
        ElementalRatio16,
        PNorm16,
        InChIRepresentationSchema16,
        InChIKeyRepresentationSchema16,
    ] = Field(..., discriminator="name")


class Name142(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema16(BaseModel):
    name: Name142
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema16(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema17 = Field(..., title="basis schema")
    lattice: LatticeSchema16 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema16]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema16]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema6(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema16 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class SlabConfigurationSchema3(BaseModel):
    stack_components: List[Union[AtomicLayersUniqueRepeatedSchema6, VacuumConfigurationSchema6]] = Field(
        ..., max_length=2, min_length=2
    )
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """


class Value42(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value43(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema20(BaseModel):
    value: Union[Value42, Value43]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema18(BaseModel):
    elements: List[AtomicElementSchema20] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema17(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema17(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema17(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema17] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema17] = Field(
        default_factory=lambda: LatticeUnitsSchema17.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name143(Enum):
    volume = "volume"


class Units60(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema17(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units60] = None
    value: float


class Name144(Enum):
    density = "density"


class Units61(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema17(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units61] = None
    value: float


class Units62(Enum):
    angstrom = "angstrom"


class ScalarSchema18(BaseModel):
    units: Optional[Units62] = None
    value: float


class Name145(Enum):
    symmetry = "symmetry"


class SymmetrySchema17(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema18] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name146(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio17(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name147(Enum):
    p_norm = "p-norm"


class PNorm17(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name148(Enum):
    inchi = "inchi"


class InChIRepresentationSchema17(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name149(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema17(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema17(
    RootModel[
        Union[
            VolumeSchema17,
            DensitySchema17,
            SymmetrySchema17,
            ElementalRatio17,
            PNorm17,
            InChIRepresentationSchema17,
            InChIKeyRepresentationSchema17,
        ]
    ]
):
    root: Union[
        VolumeSchema17,
        DensitySchema17,
        SymmetrySchema17,
        ElementalRatio17,
        PNorm17,
        InChIRepresentationSchema17,
        InChIKeyRepresentationSchema17,
    ] = Field(..., discriminator="name")


class Name150(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema17(BaseModel):
    name: Name150
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema17(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema18 = Field(..., title="basis schema")
    lattice: LatticeSchema17 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema17]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema17]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class CoordinateShapeEnum(Enum):
    cylinder = "cylinder"
    sphere = "sphere"
    box = "box"
    triangular_prism = "triangular_prism"
    plane = "plane"


class BoxCoordinateConditionSchema(BaseModel):
    shape: Literal["box"] = Field("box", title="Coordinate Shape Enum")
    min_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    max_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class SphereCoordinateConditionSchema(BaseModel):
    shape: Literal["sphere"] = Field("sphere", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)


class CylinderCoordinateConditionSchema(BaseModel):
    shape: Literal["cylinder"] = Field("cylinder", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)
    min_z: float
    max_z: float


class TriangularPrismCoordinateConditionSchema(BaseModel):
    shape: Literal["triangular_prism"] = Field("triangular_prism", title="Coordinate Shape Enum")
    position_on_surface_1: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_2: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_3: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    min_z: float
    max_z: float


class PlaneCoordinateConditionSchema(BaseModel):
    shape: Literal["plane"] = Field("plane", title="Coordinate Shape Enum")
    plane_normal: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    plane_point_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class VoidRegionSchema(BaseModel):
    crystal: CrystalSchema17 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """
    coordinate_condition: Union[
        BoxCoordinateConditionSchema,
        SphereCoordinateConditionSchema,
        CylinderCoordinateConditionSchema,
        TriangularPrismCoordinateConditionSchema,
        PlaneCoordinateConditionSchema,
    ] = Field(..., title="Coordinate Conditions Schema")
    """
    Combined schema for all coordinate condition types
    """


class MergeMethodsEnum(Enum):
    ADD = "ADD"
    REPLACE = "REPLACE"
    YIELD = "YIELD"


class MergeSchema(BaseModel):
    merge_components: List[Union[SlabConfigurationSchema3, VoidRegionSchema]] = Field(..., max_length=2, min_length=2)
    merge_method: Optional[MergeMethodsEnum] = Field("REPLACE", title="Merge Methods Enum")
    """
    Available methods for merging components
    """


class Value44(Enum):
    H = "H"
    He = "He"
    Li = "Li"
    Be = "Be"
    B = "B"
    C = "C"
    N = "N"
    O = "O"
    F = "F"
    Ne = "Ne"
    Na = "Na"
    Mg = "Mg"
    Al = "Al"
    Si = "Si"
    P = "P"
    S = "S"
    Cl = "Cl"
    Ar = "Ar"
    K = "K"
    Ca = "Ca"
    Sc = "Sc"
    Ti = "Ti"
    V = "V"
    Cr = "Cr"
    Mn = "Mn"
    Fe = "Fe"
    Co = "Co"
    Ni = "Ni"
    Cu = "Cu"
    Zn = "Zn"
    Ga = "Ga"
    Ge = "Ge"
    As = "As"
    Se = "Se"
    Br = "Br"
    Kr = "Kr"
    Rb = "Rb"
    Sr = "Sr"
    Y = "Y"
    Zr = "Zr"
    Nb = "Nb"
    Mo = "Mo"
    Tc = "Tc"
    Ru = "Ru"
    Rh = "Rh"
    Pd = "Pd"
    Ag = "Ag"
    Cd = "Cd"
    In = "In"
    Sn = "Sn"
    Sb = "Sb"
    Te = "Te"
    I = "I"
    Xe = "Xe"
    Cs = "Cs"
    Ba = "Ba"
    La = "La"
    Ce = "Ce"
    Pr = "Pr"
    Nd = "Nd"
    Pm = "Pm"
    Sm = "Sm"
    Eu = "Eu"
    Gd = "Gd"
    Tb = "Tb"
    Dy = "Dy"
    Ho = "Ho"
    Er = "Er"
    Tm = "Tm"
    Yb = "Yb"
    Lu = "Lu"
    Hf = "Hf"
    Ta = "Ta"
    W = "W"
    Re = "Re"
    Os = "Os"
    Ir = "Ir"
    Pt = "Pt"
    Au = "Au"
    Hg = "Hg"
    Tl = "Tl"
    Pb = "Pb"
    Bi = "Bi"
    Po = "Po"
    At = "At"
    Rn = "Rn"
    Fr = "Fr"
    Ra = "Ra"
    Ac = "Ac"
    Th = "Th"
    Pa = "Pa"
    U = "U"
    Np = "Np"
    Pu = "Pu"
    Am = "Am"
    Cm = "Cm"
    Bk = "Bk"
    Cf = "Cf"
    Es = "Es"
    Fm = "Fm"
    Md = "Md"
    No = "No"
    Lr = "Lr"
    Rf = "Rf"
    Db = "Db"
    Sg = "Sg"
    Bh = "Bh"
    Hs = "Hs"
    Mt = "Mt"
    Ds = "Ds"
    Rg = "Rg"
    Cn = "Cn"
    Nh = "Nh"
    Fl = "Fl"
    Mc = "Mc"
    Lv = "Lv"
    Ts = "Ts"
    Og = "Og"


class Value45(Enum):
    X = "X"
    Vac = "Vac"


class AtomicElementSchema21(BaseModel):
    value: Union[Value44, Value45]
    """
    All elements, including extra elements
    """
    id: int
    """
    integer id of this entry
    """


class BasisSchema19(BaseModel):
    elements: List[AtomicElementSchema21] = Field(..., title="atomic elements schema")
    """
    atomic elements schema
    """
    coordinates: List[AtomicCoordinateSchema] = Field(..., title="atomic coordinates schema")
    """
    atomic coordinates schema
    """
    units: Optional[BasisUnitsEnum] = Field("crystal", title="basis units enum")
    labels: Optional[List[AtomicLabelSchema]] = Field(None, title="atomic labels schema")
    """
    atomic labels schema
    """


class LatticeVectorsSchema18(BaseModel):
    a: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    b: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    c: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    alat: Optional[float] = 1
    """
    lattice parameter for fractional coordinates
    """
    units: Optional[LatticeVectorsUnitsEnum] = Field("angstrom", title="lattice vectors units enum")


class LatticeUnitsSchema18(BaseModel):
    length: Optional[LatticeUnitsLengthEnum] = Field("angstrom", title="lattice units length enum")
    angle: Optional[LatticeUnitsAngleEnum] = Field("degree", title="lattice units angle enum")


class LatticeSchema18(BaseModel):
    a: float
    """
    length of the first lattice vector
    """
    b: float
    """
    length of the second lattice vector
    """
    c: float
    """
    length of the third lattice vector
    """
    alpha: float
    """
    angle between first and second lattice vector
    """
    beta: float
    """
    angle between second and third lattice vector
    """
    gamma: float
    """
    angle between first and third lattice vector
    """
    vectors: Optional[LatticeVectorsSchema18] = Field(None, title="lattice vectors schema")
    type: Optional[LatticeTypeEnum] = Field("TRI", title="lattice type enum")
    units: Optional[LatticeUnitsSchema18] = Field(
        default_factory=lambda: LatticeUnitsSchema18.model_validate({"length": "angstrom", "angle": "degree"}),
        title="Lattice units schema",
    )


class Name151(Enum):
    volume = "volume"


class Units63(Enum):
    angstrom_3 = "angstrom^3"


class VolumeSchema18(BaseModel):
    name: Literal["0#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units63] = None
    value: float


class Name152(Enum):
    density = "density"


class Units64(Enum):
    g_cm_3 = "g/cm^3"


class DensitySchema18(BaseModel):
    name: Literal["1#-datamodel-code-generator-#-object-#-special-#"]
    units: Optional[Units64] = None
    value: float


class Units65(Enum):
    angstrom = "angstrom"


class ScalarSchema19(BaseModel):
    units: Optional[Units65] = None
    value: float


class Name153(Enum):
    symmetry = "symmetry"


class SymmetrySchema18(BaseModel):
    pointGroupSymbol: Optional[str] = None
    """
    point group symbol in Schoenflies notation
    """
    spaceGroupSymbol: Optional[str] = None
    """
    space group symbol in Hermann–Mauguin notation
    """
    tolerance: Optional[ScalarSchema19] = Field(None, title="scalar schema")
    """
    tolerance used for symmetry calculation
    """
    name: Literal["2#-datamodel-code-generator-#-object-#-special-#"]


class Name154(Enum):
    elemental_ratio = "elemental_ratio"


class ElementalRatio18(BaseModel):
    name: Literal["3#-datamodel-code-generator-#-object-#-special-#"]
    value: confloat(ge=0.0, le=1.0)
    element: Optional[str] = None
    """
    the element this ratio is for
    """


class Name155(Enum):
    p_norm = "p-norm"


class PNorm18(BaseModel):
    name: Literal["4#-datamodel-code-generator-#-object-#-special-#"]
    degree: Optional[int] = None
    """
    degree of the dimensionality of the norm
    """
    value: float


class Name156(Enum):
    inchi = "inchi"


class InChIRepresentationSchema18(BaseModel):
    name: Literal["5#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class Name157(Enum):
    inchi_key = "inchi_key"


class InChIKeyRepresentationSchema18(BaseModel):
    name: Literal["6#-datamodel-code-generator-#-object-#-special-#"]
    value: str


class DerivedPropertiesSchema18(
    RootModel[
        Union[
            VolumeSchema18,
            DensitySchema18,
            SymmetrySchema18,
            ElementalRatio18,
            PNorm18,
            InChIRepresentationSchema18,
            InChIKeyRepresentationSchema18,
        ]
    ]
):
    root: Union[
        VolumeSchema18,
        DensitySchema18,
        SymmetrySchema18,
        ElementalRatio18,
        PNorm18,
        InChIRepresentationSchema18,
        InChIKeyRepresentationSchema18,
    ] = Field(..., discriminator="name")


class Name158(Enum):
    default = "default"
    atomsTooClose = "atomsTooClose"
    atomsOverlap = "atomsOverlap"


class MaterialConsistencyCheckSchema18(BaseModel):
    name: Name158
    """
    Name of the consistency check that is performed, which is listed in an enum.
    """
    key: str
    """
    Key of the property of the entity on which the consistency check is performed in Mongo dot notation, e.g. 'basis.coordinates.1'
    """
    severity: Severity
    """
    Severity level of the problem, which is used in UI to differentiate.
    """
    message: str
    """
    Message generated by the consistency check describing the problem.
    """


class CrystalSchema18(BaseModel):
    formula: Optional[str] = None
    """
    reduced chemical formula
    """
    unitCellFormula: Optional[str] = None
    """
    chemical formula based on the number of atoms of each element in the supercell
    """
    basis: BasisSchema19 = Field(..., title="basis schema")
    lattice: LatticeSchema18 = Field(..., title="lattice schema")
    derivedProperties: Optional[List[DerivedPropertiesSchema18]] = Field(None, title="derived properties schema")
    external: Optional[DatabaseSourceSchema] = Field(None, title="database source schema")
    """
    information about a database source
    """
    src: Optional[FileSourceSchema] = Field(None, title="file source schema")
    """
    file source with the information inside
    """
    scaledHash: Optional[str] = None
    """
    Hash string for a scaled structure with lattice vector a set to 1 (eg. for materials under pressure).
    """
    icsdId: Optional[int] = None
    """
    Corresponding ICSD id of the material
    """
    isNonPeriodic: Optional[bool] = None
    """
    Whether to work in the finite molecular picture (usually with atomic orbital basis)
    """
    consistencyChecks: Optional[List[MaterialConsistencyCheckSchema18]] = None
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    metadata: Optional[Dict[str, Any]] = None


class VacuumConfigurationSchema7(BaseModel):
    direction: AxisEnum = Field(..., title="Axis Enum")
    """
    Enum for axis types
    """
    size: Optional[confloat(ge=0.0)] = 10
    """
    Size of the vacuum slab in angstroms
    """
    crystal: CrystalSchema18 = Field(..., title="Crystal Schema")
    """
    A crystal structure, referencing the base material schema
    """


class TerraceDefectConfigurationSchema(BaseModel):
    stack_components: List[Union[SlabConfigurationSchema, MergeSchema, VacuumConfigurationSchema7]] = Field(
        ..., max_length=3, min_length=3
    )
    cut_direction: Optional[List[int]] = Field([0, 0, 1], max_length=3, min_length=3, title="Miller Indices Schema")
    """
    Miller indices [h, k, l] defining crystallographic planes
    """
    direction: Optional[AxisEnum] = Field("z", title="Axis Enum")
    """
    Enum for axis types
    """
    gaps: Optional[List[ObjectWithIdAndValueSchema]] = None
    """
    Gap distances between stack components as array of objects with id and value
    """
