# generated by datamodel-codegen:
#   filename:  materials_category_components/entities/core/three_dimensional/void.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Literal, Union

from pydantic import BaseModel, Field, confloat


class CoordinateShapeEnum(Enum):
    cylinder = "cylinder"
    sphere = "sphere"
    box = "box"
    triangular_prism = "triangular_prism"
    plane = "plane"


class BoxCoordinateConditionSchema(BaseModel):
    shape: Literal["box"] = Field("box", title="Coordinate Shape Enum")
    min_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    max_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class SphereCoordinateConditionSchema(BaseModel):
    shape: Literal["sphere"] = Field("sphere", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)


class CylinderCoordinateConditionSchema(BaseModel):
    shape: Literal["cylinder"] = Field("cylinder", title="Coordinate Shape Enum")
    radius: confloat(ge=0.0)
    min_z: float
    max_z: float


class TriangularPrismCoordinateConditionSchema(BaseModel):
    shape: Literal["triangular_prism"] = Field("triangular_prism", title="Coordinate Shape Enum")
    position_on_surface_1: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_2: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    position_on_surface_3: List[float] = Field(
        ..., max_length=2, min_length=2, title="array of 2 number elements schema"
    )
    min_z: float
    max_z: float


class PlaneCoordinateConditionSchema(BaseModel):
    shape: Literal["plane"] = Field("plane", title="Coordinate Shape Enum")
    plane_normal: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    plane_point_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")


class VoidSchema(BaseModel):
    center_coordinate: List[float] = Field(..., max_length=3, min_length=3, title="coordinate 3d schema")
    shape: Union[
        BoxCoordinateConditionSchema,
        SphereCoordinateConditionSchema,
        CylinderCoordinateConditionSchema,
        TriangularPrismCoordinateConditionSchema,
        PlaneCoordinateConditionSchema,
    ] = Field(..., title="Coordinate Conditions Schema")
    """
    Combined schema for all coordinate condition types
    """
