# generated by datamodel-codegen:
#   filename:  method/categorized_method.json
#   version:   0.28.5

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class ReusableCategoriesSchema(BaseModel):
    tier1: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    type: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class CategorizedUnitMethod(BaseModel):
    categories: Optional[ReusableCategoriesSchema] = Field(None, title="Reusable categories schema")
    """
    Used to categorize entities such as models and methods
    """
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """


class CategorizedMethod(BaseModel):
    units: List[CategorizedUnitMethod]
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
