# generated by datamodel-codegen:
#   filename:  methods_directory/legacy/regression.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional, Union

from pydantic import BaseModel, Field


class Type(Enum):
    linear = "linear"
    kernel_ridge = "kernel_ridge"


class Subtype(Enum):
    least_squares = "least_squares"
    ridge = "ridge"


class RegressionPrecisionPerPropertySchema(BaseModel):
    name: Optional[str] = None
    """
    property name in 'flattened' format
    """
    trainingError: float
    """
    training error of the estimator
    """
    score: Optional[float] = None
    """
    prediction score of the estimator. Eg: r2_score
    """


class RegressionPrecision(BaseModel):
    perProperty: Optional[List[RegressionPrecisionPerPropertySchema]] = None


class PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema(BaseModel):
    coefficient: Optional[float] = None
    """
    coefficient in linear regression
    """
    name: str
    """
    feature name
    """
    importance: Optional[float] = None
    """
    pvalue: https://en.wikipedia.org/wiki/P-value
    """


class LinearRegressionParametersSchema(BaseModel):
    intercept: float
    """
    intercept (shift) from the linear or non-linear fit of data points
    """
    perFeature: List[PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema]
    """
    per-feature (property used for training the ML method/model) parameters
    """


class KernelRidgeRegressionParametersSchema(BaseModel):
    xFit: List
    """
    training data
    """
    dualCoefficients: List
    """
    dual coefficients
    """
    perFeature: List[PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema]
    """
    per-feature (property used for training the ML method/model) parameters
    """


class DataSet(BaseModel):
    exabyteIds: List[str]
    """
    array of exabyteIds for materials in dataset
    """
    extra: Optional[Any] = None
    """
    holder for any extra information, eg. coming from user-uploaded CSV file
    """


class RegressionData(BaseModel):
    perProperty: Optional[List[Union[LinearRegressionParametersSchema, KernelRidgeRegressionParametersSchema]]] = None
    dataSet: Optional[DataSet] = None
    """
    dataset for ml
    """


class LegacyMethodRegression(BaseModel):
    type: Type
    """
    general type of this method, eg. `pseudopotential`
    """
    subtype: Subtype
    """
    general subtype of this method, eg. `ultra-soft`
    """
    precision: RegressionPrecision = Field(..., title="regression precision")
    """
    Object showing the actual possible precision based on theory and implementation
    """
    data: RegressionData = Field(..., title="regression data")
    """
    additional data specific to method, eg. array of pseudopotentials
    """
