# generated by datamodel-codegen:
#   filename:  methods_directory/mathematical/cg.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    cg = "cg"


class SlugifiedEntryOrSlug22(Enum):
    ordern = "ordern"


class SlugifiedEntryOrSlug23(Enum):
    diff = "diff"


class SlugifiedEntryOrSlug24(Enum):
    opt = "opt"


class ConjugateGradientMethodSchema(BaseModel):
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug22]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug23]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug24]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class UnitMethodConjugateGradient(BaseModel):
    categories: ConjugateGradientMethodSchema = Field(..., title="Conjugate gradient method schema")
    """
    Used to categorize entities such as models and methods
    """
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
