# generated by datamodel-codegen:
#   filename:  methods_directory/mathematical/regression.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    linear = "linear"
    kernel_ridge = "kernel_ridge"


class SlugifiedEntryOrSlug234(Enum):
    least_squares = "least_squares"
    ridge = "ridge"


class LinearMethodsCategorySchema(BaseModel):
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug234]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class RegressionPrecisionPerPropertySchema(BaseModel):
    name: Optional[str] = None
    """
    property name in 'flattened' format
    """
    trainingError: float
    """
    training error of the estimator
    """
    score: Optional[float] = None
    """
    prediction score of the estimator. Eg: r2_score
    """


class RegressionPrecision(BaseModel):
    perProperty: Optional[List[RegressionPrecisionPerPropertySchema]] = None


class PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema(BaseModel):
    coefficient: Optional[float] = None
    """
    coefficient in linear regression
    """
    name: str
    """
    feature name
    """
    importance: Optional[float] = None
    """
    pvalue: https://en.wikipedia.org/wiki/P-value
    """


class LinearRegressionParametersSchema(BaseModel):
    intercept: float
    """
    intercept (shift) from the linear or non-linear fit of data points
    """
    perFeature: List[PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema]
    """
    per-feature (property used for training the ML method/model) parameters
    """


class KernelRidgeRegressionParametersSchema(BaseModel):
    xFit: List
    """
    training data
    """
    dualCoefficients: List
    """
    dual coefficients
    """
    perFeature: List[PerFeaturePropertyUsedForTrainingTheMLMethodModelParametersSchema]
    """
    per-feature (property used for training the ML method/model) parameters
    """


class DataSet(BaseModel):
    exabyteIds: List[str]
    """
    array of exabyteIds for materials in dataset
    """
    extra: Optional[Any] = None
    """
    holder for any extra information, eg. coming from user-uploaded CSV file
    """


class RegressionData(BaseModel):
    perProperty: Optional[List[Union[LinearRegressionParametersSchema, KernelRidgeRegressionParametersSchema]]] = None
    dataSet: Optional[DataSet] = None
    """
    dataset for ml
    """


class UnitMethodRegression(BaseModel):
    categories: LinearMethodsCategorySchema = Field(..., title="linear methods category schema")
    """
    Used to categorize entities such as models and methods
    """
    precision: RegressionPrecision = Field(..., title="regression precision")
    """
    Object showing the actual possible precision based on theory and implementation
    """
    data: RegressionData = Field(..., title="regression data")
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
