# generated by datamodel-codegen:
#   filename:  methods_directory/physical/psp.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, confloat, conint, constr

from ..Reusable_schema_for_energy_value_with_unit_corresponding_to_a_specific_accuracy_level__e import (
    g,
)


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    psp = "psp"


class SlugifiedEntryOrSlug209(Enum):
    us = "us"
    nc = "nc"
    nc_fr = "nc-fr"
    paw = "paw"
    coulomb = "coulomb"


class SlugifiedEntryOrSlug210(Enum):
    wf = "wf"


class SlugifiedEntryOrSlug211(Enum):
    qm = "qm"


class PseudopotentialCategorySchema(BaseModel):
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug209]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug210]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug211]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class Slug(Enum):
    pseudopotential = "pseudopotential"


class Type(Enum):
    us = "us"
    nc = "nc"
    nc_fr = "nc-fr"
    paw = "paw"
    coulomb = "coulomb"


class ExchangeCorrelation(BaseModel):
    approximation: Optional[str] = None
    """
    DFT approximation
    """
    functional: Optional[str] = None
    """
    Exchange correlation functional
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """


class AtomicOrbitalSchema(BaseModel):
    orbitalName: Optional[constr(pattern=r"^[1-7][sSpPdDfF]$")] = None
    orbitalIndex: Optional[conint(ge=1)] = None
    principalNumber: Optional[conint(ge=1, le=7)] = None
    angularMomentum: Optional[conint(ge=0, le=3)] = None
    occupation: Optional[confloat(ge=0.0, le=14.0)] = None
    """
    Shell occupation
    """


class Name(Enum):
    pseudopotential = "pseudopotential"


class Cutoffs(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    wavefunction: Optional[List[g.FieldUsedForSuggestedWavefunctionAndChargeDensityCutoffs]] = None
    """
    Energy cutoff values for wavefunction plane wave expansion.
    """
    density: Optional[List[g.FieldUsedForSuggestedWavefunctionAndChargeDensityCutoffs]] = None
    """
    Energy cutoff values for charge density plane wave expansion.
    """


class FileDataItem(BaseModel):
    element: str
    """
    chemical element
    """
    hash: Optional[str] = None
    """
    MD5 hash of the pseudopotential file
    """
    type: Type
    source: str
    """
    explains where this came from
    """
    version: Optional[str] = None
    """
    explains the version of where this came from
    """
    exchangeCorrelation: ExchangeCorrelation
    valenceConfiguration: Optional[List[AtomicOrbitalSchema]] = None
    """
    contains pseudo orbital information, including orbital names and occupations
    """
    path: str
    """
    location of the pseudopotential file on filesystem
    """
    apps: List[str]
    """
    The names of the simulation engines that can use this pseudopotential, e.g. espresso
    """
    filename: Optional[str] = None
    """
    filename of pseudopotential file on filesystem
    """
    name: Optional[Name] = None
    """
    name of the data category
    """
    cutoffs: Optional[Cutoffs] = None
    """
    Suggested cutoff values for wave function and charge density.
    """


class Source(BaseModel):
    info: Optional[Dict[str, Any]] = None
    type: Optional[str] = None


class PseudopotentialFile(BaseModel):
    slug: Optional[Slug] = None
    data: Optional[FileDataItem] = Field(None, title="File data item")
    source: Optional[Source] = None
    """
    TODO: remove in the future
    """


class UnitMethodPseudopotential(BaseModel):
    categories: PseudopotentialCategorySchema = Field(..., title="Pseudopotential category schema")
    """
    Used to categorize entities such as models and methods
    """
    data: Optional[List[PseudopotentialFile]] = None
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
