# generated by datamodel-codegen:
#   filename:  methods_directory/physical/smearing.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class SlugifiedEntryOrSlug(Enum):
    smearing = "smearing"


class SlugifiedEntryOrSlug243(Enum):
    gaussian = "gaussian"
    marzari_vanderbilt = "marzari-vanderbilt"
    methfessel_paxton = "methfessel-paxton"
    fermi_dirac = "fermi-dirac"


class SlugifiedEntryOrSlug244(Enum):
    wf = "wf"


class SlugifiedEntryOrSlug245(Enum):
    qm = "qm"


class SmearingMethodsCategorySchema(BaseModel):
    type: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug243]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug244]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier1: Optional[Union[SlugifiedEntry, SlugifiedEntryOrSlug245]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class UnitMethodSmearing(BaseModel):
    categories: SmearingMethodsCategorySchema = Field(..., title="Smearing methods category schema")
    """
    Approximating Heaviside step function with smooth function
    """
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
