# generated by datamodel-codegen:
#   filename:  model/categorized_model.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class SlugifiedEntry(BaseModel):
    name: str
    """
    descriptive human-readable name of entry
    """
    slug: str
    """
    machine-readable identifier
    """


class ReusableCategoriesSchema(BaseModel):
    tier1: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    type: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class CategorizedUnitMethod(BaseModel):
    categories: Optional[ReusableCategoriesSchema] = Field(None, title="Reusable categories schema")
    """
    Used to categorize entities such as models and methods
    """
    parameters: Optional[Dict[str, Any]] = None
    """
    Instructive parameters defining the method
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """


class CategorizedMethod(BaseModel):
    units: List[CategorizedUnitMethod]
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """


class ReusableCategoriesSchema3(BaseModel):
    tier1: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier2: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    tier3: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    type: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """
    subtype: Optional[Union[SlugifiedEntry, str]] = Field(None, title="slugified entry or slug")
    """
    contains either object with slugified entry or slug only as a string
    """


class Type(Enum):
    literature = "literature"


class PagesSchema(BaseModel):
    start: str
    end: Optional[str] = None


class ExperimentAuthorSchema(BaseModel):
    first: str
    middle: Optional[str] = None
    last: str
    affiliation: Optional[str] = None


class LiteratureReferenceSchema(BaseModel):
    type: Optional[Type] = None
    doi: Optional[str] = None
    """
    Digital Object Identifier of the reference.
    """
    isbn: Optional[str] = None
    """
    International Standard Book Number of the reference.
    """
    issn: Optional[str] = None
    """
    International Standard Serial Number of the reference.
    """
    url: Optional[str] = None
    """
    Internet address of the reference.
    """
    title: Optional[str] = None
    """
    Title of the work.
    """
    publisher: Optional[str] = None
    """
    Publisher of the work.
    """
    journal: Optional[str] = None
    """
    Journal in which the work appeared.
    """
    volume: Optional[str] = None
    """
    Volume of the series in which the work appeared.
    """
    year: Optional[str] = None
    """
    Year in which the reference was published.
    """
    issue: Optional[str] = None
    """
    Issue of the collection in which the work appeared.
    """
    pages: Optional[PagesSchema] = Field(None, title="pages schema")
    """
    Start and end pages of the work.
    """
    authors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of authors of the work.
    """
    editors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of editors of the work.
    """
    reference: Optional[List[Dict[str, Any]]] = None
    """
    References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published.
    """


class CategorizedModel(BaseModel):
    method: CategorizedMethod = Field(..., title="categorized method")
    categories: ReusableCategoriesSchema3 = Field(..., title="Reusable categories schema")
    """
    Used to categorize entities such as models and methods
    """
    parameters: Dict[str, Any]
    """
    Model parameters defined in-place or via model mixins
    """
    reference: Optional[LiteratureReferenceSchema] = Field(None, title="literature reference schema")
    name: Optional[str] = None
    """
    entity name
    """
    path: Optional[str] = Field(None, title="category path schema")
    """
    TODO: Use regex once schema draft version has been updated
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
