# generated by datamodel-codegen:
#   filename:  models_directory/legacy/dft.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel


class Type(Enum):
    dft = "dft"


class Subtype(Enum):
    lda = "lda"


class BaseMethod(BaseModel):
    type: str
    """
    general type of this method, eg. `pseudopotential`
    """
    subtype: str
    """
    general subtype of this method, eg. `ultra-soft`
    """
    precision: Optional[Dict[str, Any]] = None
    """
    Object showing the actual possible precision based on theory and implementation
    """
    data: Optional[Dict[str, Any]] = None
    """
    additional data specific to method, eg. array of pseudopotentials
    """


class Functional(Enum):
    pz = "pz"
    pw = "pw"
    vwn = "vwn"
    other = "other"


class LegacyModelDensityFunctionalTheory(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    general type of the model, eg. `dft`
    """
    subtype: Subtype
    """
    general subtype of the model, eg. `lda`
    """
    method: BaseMethod = Field(..., title="base method")
    functional: Optional[Functional] = None


class Subtype1(Enum):
    gga = "gga"


class Functional1(Enum):
    pbe = "pbe"
    pbesol = "pbesol"
    pw91 = "pw91"
    other = "other"


class LegacyModelDensityFunctionalTheory1(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    general type of the model, eg. `dft`
    """
    subtype: Subtype1
    """
    general subtype of the model, eg. `lda`
    """
    method: BaseMethod = Field(..., title="base method")
    functional: Optional[Functional1] = None


class Subtype2(Enum):
    hybrid = "hybrid"


class Functional2(Enum):
    b3lyp = "b3lyp"
    hse06 = "hse06"


class LegacyModelDensityFunctionalTheory2(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    general type of the model, eg. `dft`
    """
    subtype: Subtype2
    """
    general subtype of the model, eg. `lda`
    """
    method: BaseMethod = Field(..., title="base method")
    functional: Optional[Functional2] = None


class ESSE(
    RootModel[
        Union[
            LegacyModelDensityFunctionalTheory, LegacyModelDensityFunctionalTheory1, LegacyModelDensityFunctionalTheory2
        ]
    ]
):
    root: Union[
        LegacyModelDensityFunctionalTheory, LegacyModelDensityFunctionalTheory1, LegacyModelDensityFunctionalTheory2
    ] = Field(..., title="legacy model density functional theory")


class Subtype3(Enum):
    lda = "lda"


class Functional3(Enum):
    pz = "pz"
    pw = "pw"
    vwn = "vwn"
    other = "other"


class Lda(BaseModel):
    subtype: Optional[Subtype3] = None
    functional: Optional[Functional3] = None


class Subtype4(Enum):
    gga = "gga"


class Functional4(Enum):
    pbe = "pbe"
    pbesol = "pbesol"
    pw91 = "pw91"
    other = "other"


class Gga(BaseModel):
    subtype: Optional[Subtype4] = None
    functional: Optional[Functional4] = None


class Subtype5(Enum):
    hybrid = "hybrid"


class Functional5(Enum):
    b3lyp = "b3lyp"
    hse06 = "hse06"


class Hybrid(BaseModel):
    subtype: Optional[Subtype5] = None
    functional: Optional[Functional5] = None
