# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/band_structure.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class Label(Enum):
    kpoints = "kpoints"


class Units(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[Units] = "crystal"
    """
    units for an axis
    """


class Label3(Enum):
    energy = "energy"


class Units16(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class AxisSchema6(BaseModel):
    label: Label3
    """
    label of an axis object
    """
    units: Optional[Units16] = None
    """
    units for an axis
    """


class Name(Enum):
    band_structure = "band_structure"


class SpinEnum(Enum):
    number_0_5 = 0.5
    number__0_5 = -0.5


class BandStructureSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema6 = Field(..., title="axis schema")
    name: Optional[Name] = None
    spin: Optional[List[SpinEnum]] = None
    """
    spin of each band
    """
    legend: Optional[List] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
