# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/density_of_states.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, constr


class Label(Enum):
    energy = "energy"


class Units(Enum):
    kJ_mol = "kJ/mol"
    eV = "eV"
    J_mol = "J/mol"
    hartree = "hartree"
    cm_1 = "cm-1"
    Ry = "Ry"
    eV_atom = "eV/atom"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[Units] = None
    """
    units for an axis
    """


class Label7(Enum):
    density_of_states = "density of states"


class Units176(Enum):
    states_unitcell = "states/unitcell"


class AxisSchema10(BaseModel):
    label: Label7
    """
    label of an axis object
    """
    units: Optional[Units176] = None
    """
    units for an axis
    """


class Name(Enum):
    density_of_states = "density_of_states"


class Spin(Enum):
    number_0_5 = 0.5
    number__0_5 = -0.5


class LegendItem(BaseModel):
    element: Optional[str] = None
    """
    chemical element
    """
    index: Optional[int] = None
    """
    index inside sub-array of atoms of the same element type
    """
    electronicState: Optional[constr(pattern=r"^([1-5]{1})?(s|p|d|f|g).*$")] = None
    """
    electronic character and shell of PDOS, such as `1s` or `s`, or `total`
    """
    spin: Optional[Spin] = None
    """
    spin of the electronic state
    """


class DensityOfStatesSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema10 = Field(..., title="axis schema")
    name: Optional[Name] = None
    legend: Optional[List[LegendItem]] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
