# generated by datamodel-codegen:
#   filename:  properties_directory/non_scalar/phonon_dispersions.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field


class Label(Enum):
    qpoints = "qpoints"


class Units(Enum):
    crystal = "crystal"
    cartesian = "cartesian"


class AxisSchema(BaseModel):
    label: Label
    """
    label of an axis object
    """
    units: Optional[Units] = "crystal"
    """
    units for an axis
    """


class Label9(Enum):
    frequency = "frequency"


class Units231(Enum):
    cm_1 = "cm-1"
    THz = "THz"
    meV = "meV"


class AxisSchema12(BaseModel):
    label: Label9
    """
    label of an axis object
    """
    units: Optional[Units231] = None
    """
    units for an axis
    """


class Name(Enum):
    phonon_dispersions = "phonon_dispersions"


class PhononBandStructureSchema(BaseModel):
    xAxis: AxisSchema = Field(..., title="axis schema")
    yAxis: AxisSchema12 = Field(..., title="axis schema")
    name: Optional[Name] = None
    legend: Optional[List] = Field(None, min_length=1)
    """
    Legend of y Axis data series
    """
    xDataArray: List
    """
    array containing values of x Axis
    """
    yDataSeries: List[List[Union[float, str]]] = Field(..., title="1 dimension data series schema")
