# generated by datamodel-codegen:
#   filename:  properties_directory/structural/atomic_forces.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field


class Name(Enum):
    atomic_forces = "atomic_forces"


class AtomicVectorSchema(BaseModel):
    value: List[float] = Field(..., max_length=3, min_length=3, title="vector 3d schema")
    """
    value of this entry
    """
    id: int
    """
    integer id of this entry
    """


class Units(Enum):
    eV_bohr = "eV/bohr"
    eV_angstrom = "eV/angstrom"
    Ry_a_u_ = "Ry/a.u."
    newton = "newton"
    kg_m_s_2 = "kg*m/s^2"
    eV_a_u_ = "eV/a.u."


class AtomicForces(BaseModel):
    name: Optional[Name] = None
    values: Optional[List[AtomicVectorSchema]] = Field(None, title="atomic vectors schema")
    units: Optional[Units] = None
