# generated by datamodel-codegen:
#   filename:  properties_directory/workflow/convergence/ionic.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel


class Name(Enum):
    convergence_ionic = "convergence_ionic"


class Units(Enum):
    eV = "eV"


class Units204(Enum):
    eV = "eV"
    Ry = "Ry"
    hartree = "hartree"


class Electronic(BaseModel):
    units: Optional[Units204] = None
    """
    units for force tolerance
    """
    data: Optional[List[float]] = None


class Datum(BaseModel):
    energy: Optional[float] = None
    """
    converged electronic energy for this structure (last in `electronic`)
    """
    structure: Optional[Dict[str, Any]] = None
    """
    TODO: structural information at each step to be here
    """
    electronic: Optional[Electronic] = None
    """
    data about electronic at this ionic step
    """


class IonicConvergenceSchema(BaseModel):
    name: Optional[Name] = None
    tolerance: Optional[Any] = None
    """
    for ionic convergence tolerance shows force tolerance
    """
    units: Optional[Units] = None
    """
    units for force tolerance
    """
    data: List[Datum]
    """
    energetic and structural information
    """
