# generated by datamodel-codegen:
#   filename:  property/raw.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field

from .The_source_of_a_property import (
    field_This_could_be_an_article__a_simulation_on_Exabyte__an_external_simulation__etc,
)


class Type(Enum):
    experiment = "experiment"


class ExperimentAuthorSchema(BaseModel):
    first: str
    middle: Optional[str] = None
    last: str
    affiliation: Optional[str] = None


class ScalarItem(BaseModel):
    value: Optional[str] = None


class ConditionSchema(BaseModel):
    units: Optional[str] = None
    """
    condition unit
    """
    scalar: Optional[List[ScalarItem]] = None
    """
    array of condition values
    """
    name: str
    """
    human-readable name of the condition
    """


class LocationSchema(BaseModel):
    latitude: float
    """
    location latitude
    """
    longitude: float
    """
    location longitude
    """


class Type55(Enum):
    literature = "literature"


class PagesSchema(BaseModel):
    start: str
    end: Optional[str] = None


class LiteratureReferenceSchema(BaseModel):
    type: Optional[Type55] = None
    doi: Optional[str] = None
    """
    Digital Object Identifier of the reference.
    """
    isbn: Optional[str] = None
    """
    International Standard Book Number of the reference.
    """
    issn: Optional[str] = None
    """
    International Standard Serial Number of the reference.
    """
    url: Optional[str] = None
    """
    Internet address of the reference.
    """
    title: Optional[str] = None
    """
    Title of the work.
    """
    publisher: Optional[str] = None
    """
    Publisher of the work.
    """
    journal: Optional[str] = None
    """
    Journal in which the work appeared.
    """
    volume: Optional[str] = None
    """
    Volume of the series in which the work appeared.
    """
    year: Optional[str] = None
    """
    Year in which the reference was published.
    """
    issue: Optional[str] = None
    """
    Issue of the collection in which the work appeared.
    """
    pages: Optional[PagesSchema] = Field(None, title="pages schema")
    """
    Start and end pages of the work.
    """
    authors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of authors of the work.
    """
    editors: Optional[List[ExperimentAuthorSchema]] = None
    """
    List of editors of the work.
    """
    reference: Optional[List[Dict[str, Any]]] = None
    """
    References cited by the work. Reference objects can nest as deeply as needed. This is useful, for example, when tracking the history of a value referenced in a scholarly article; the top level reference would contain information about where the data was accessed while the nested reference would contain information about where it was originally published.
    """


class InfoForCharacteristicObtainedByExperiment(BaseModel):
    type: Optional[Type] = None
    authors: List[ExperimentAuthorSchema]
    """
    experiment authors
    """
    title: str
    """
    experiment title
    """
    method: str
    """
    method used in experiment
    """
    conditions: List[ConditionSchema]
    location: Optional[LocationSchema] = Field(None, title="location schema")
    timestamp: float
    """
    epoch time.
    """
    note: Optional[str] = None
    """
    Note about experiment
    """
    references: Optional[List[LiteratureReferenceSchema]] = None
    """
    references to literature articles
    """


class SystemTag(Enum):
    isRefined = "isRefined"
    isBest = "isBest"


class SchemaOfMaterialSPreliminaryProperty(BaseModel):
    slug: Optional[str] = None
    """
    property slug, e.g. total_energy
    """
    group: Optional[str] = None
    """
    property group, e.g. qe:dft:gga:pbe
    """
    data: Dict[str, Any]
    """
    container of the information, specific to each property
    """
    source: field_This_could_be_an_article__a_simulation_on_Exabyte__an_external_simulation__etc.Field = Field(
        ...,
        title="The source of a property. This could be an article, a simulation on Exabyte, an external simulation, etc.",
    )
    exabyteId: Optional[List[str]] = None
    """
    Id of the corresponding item in the entity bank that this property is obtained for
    """
    precision: Optional[Dict[str, Any]] = None
    count: Optional[float] = None
    """
    total number of properties among which this property is the best.
    """
    systemTags: Optional[List[SystemTag]] = None
    """
    property system tags, marks property system characteristics, values refined or best (could be both)
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
