# generated by datamodel-codegen:
#   filename:  software/flavor.json
#   version:   0.28.5

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    templateId: Optional[str] = None
    templateName: Optional[str] = None
    name: Optional[str] = None
    """
    name of the resulting input file, if different than template name
    """


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class FlavorSchema(BaseModel):
    executableId: Optional[str] = None
    """
    _id of the executable this flavor belongs to
    """
    executableName: Optional[str] = None
    """
    name of the executable this flavor belongs to
    """
    applicationName: Optional[str] = None
    """
    name of the application this flavor belongs to
    """
    input: Optional[List[ExecutionUnitInputIdItemSchemaForPhysicsBasedSimulationEngines]] = Field(
        None, title="execution unit input schema"
    )
    supportedApplicationVersions: Optional[List[str]] = None
    """
    list of application versions this flavor supports
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    name: Optional[str] = None
    """
    entity name
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
