# generated by datamodel-codegen:
#   filename:  software_directory/modeling/espresso/arguments.json
#   version:   0.28.5

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, ConfigDict, conint


class QuantumEspressoArgumentsSchema(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    nimage: Optional[conint(ge=1, le=100)] = 1
    """
    Processors can be divided into different `images`, each corresponding to a different self-consistent or linear-response calculation, loosely coupled to others.
    """
    npools: Optional[conint(ge=1, le=100)] = 1
    """
    Each image can be subpartitioned into `pools`, each taking care of a group of k-points.
    """
    nband: Optional[conint(ge=1, le=100)] = 1
    """
    Each pool is subpartitioned into `band groups`, each taking care of a group of Kohn-Sham orbitals (also called bands, or wavefunctions).
    """
    ntg: Optional[conint(ge=1, le=100)] = 1
    """
    In order to allow good parallelization of the 3D FFT when the number of processors exceeds the number of FFT planes, FFTs on Kohn-Sham states are redistributed to `task` groups so that each group can process several wavefunctions at the same time.
    """
    ndiag: Optional[conint(ge=1, le=100)] = 1
    """
    A further level of parallelization, independent on PW or k-point parallelization, is the parallelization of subspace diagonalization / iterative orthonormalization. Both operations required the diagonalization of arrays whose dimension is the number of Kohn-Sham states (or a small multiple of it). All such arrays are distributed block-like across the `linear-algebra group`, a subgroup of the pool of processors, organized in a square 2D grid. As a consequence the number of processors in the linear-algebra group is given by n2, where n is an integer; n2 must be smaller than the number of processors in the PW group. The diagonalization is then performed in parallel using standard linear algebra operations.
    """
