# generated by datamodel-codegen:
#   filename:  software_directory/modeling/nwchem.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, ConfigDict, Field


class Name(Enum):
    NWChem = "NWChem"


class Summary(Enum):
    NWChem__a_comprehensive_and_scalable_open_source_solution_for_large_scale_molecular_simulations = (
        "NWChem: a comprehensive and scalable open-source solution for large scale molecular simulations"
    )


class Version(Enum):
    field_6_6 = "6.6"
    field_7_0_2 = "7.0.2"


class Exec(Enum):
    nwchem = "nwchem"


class NWChem(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    name: Optional[Name] = None
    """
    entity name
    """
    summary: Optional[Summary] = None
    """
    Application's short description.
    """
    version: Optional[Version] = None
    """
    Application version. e.g. 5.3.5
    """
    exec: Optional[Exec] = None
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
