# generated by datamodel-codegen:
#   filename:  software_directory/modeling/vasp.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, ConfigDict, Field


class Name(Enum):
    vasp = "vasp"


class Summary(Enum):
    vienna_ab_initio_simulation_package = "vienna ab-initio simulation package"


class Flavor(Enum):
    vasp = "vasp"
    vasp_nscf = "vasp_nscf"
    vasp_bands = "vasp_bands"


class Version(Enum):
    field_5_3_5 = "5.3.5"


class Exec(Enum):
    vasp = "vasp"


class ViennaAbInitoSimulationPackage(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    name: Optional[Name] = None
    """
    entity name
    """
    summary: Optional[Summary] = None
    """
    Application's short description.
    """
    flavor: Optional[Flavor] = None
    version: Optional[Version] = None
    """
    Application version. e.g. 5.3.5
    """
    exec: Optional[Exec] = None
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
