# generated by datamodel-codegen:
#   filename:  software_directory/scripting/shell.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, Field


class Name(Enum):
    shell = "shell"


class Flavor(Enum):
    sh = "sh"
    bash = "bash"
    zsh = "zsh"
    csh = "csh"


class Summary(Enum):
    Shell_Script = "Shell Script"


class Version(Enum):
    field_4_2_46 = "4.2.46"


class Exec(Enum):
    sh = "sh"
    bash = "bash"
    zsh = "zsh"
    csh = "csh"


class ShellScriptingLanguageSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    name: Optional[Name] = None
    """
    entity name
    """
    flavor: Optional[Flavor] = None
    summary: Optional[Summary] = None
    """
    Application's short description.
    """
    version: Optional[Version] = None
    """
    Application version. e.g. 5.3.5
    """
    exec: Optional[Exec] = None
    arguments: Optional[str] = None
    """
    Optional arguments passed to the Shell script
    """
    environment: Optional[Dict[str, Any]] = None
    """
    Optional environment variables exported before running the Shell script
    """
    shortName: Optional[str] = None
    """
    The short name of the application. e.g. qe
    """
    build: Optional[str] = None
    """
    Application build. e.g. VTST
    """
    hasAdvancedComputeOptions: Optional[bool] = None
    """
    Whether advanced compute options are present
    """
    isLicensed: Optional[bool] = None
    """
    Whether licensing is present
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
